/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Arrays;

public class CreateEnumeratedClassesTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateEnumeratedClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Color");
        RDFResource a = cls.createInstance("a");
        RDFResource b = cls.createInstance("b");
        cls.addSuperclass(this.owlModel.createOWLEnumeratedClass(Arrays.asList(a, b)));
        OntModel ontModel = this.createOntModel();
        EnumeratedClass enumeratedClass = (EnumeratedClass)ontModel.listEnumeratedClasses().next();
        ExtendedIterator it = enumeratedClass.listOneOf();
        CreateEnumeratedClassesTestCase.assertEquals((Object)ontModel.getIndividual(a.getURI()), it.next());
        CreateEnumeratedClassesTestCase.assertEquals((Object)ontModel.getIndividual(b.getURI()), it.next());
        CreateEnumeratedClassesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testCreateEnumeratedEquivalentClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Color");
        RDFResource a = cls.createInstance("a");
        RDFResource b = cls.createInstance("b");
        OWLEnumeratedClass enumerationCls = this.owlModel.createOWLEnumeratedClass(Arrays.asList(a, b));
        cls.addEquivalentClass(enumerationCls);
        OntModel newModel = this.createOntModel();
        EnumeratedClass enumeratedClass = (EnumeratedClass)newModel.listEnumeratedClasses().next();
        ExtendedIterator it = enumeratedClass.listOneOf();
        CreateEnumeratedClassesTestCase.assertEquals((Object)newModel.getIndividual(a.getURI()), it.next());
        CreateEnumeratedClassesTestCase.assertEquals((Object)newModel.getIndividual(b.getURI()), it.next());
        CreateEnumeratedClassesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testCreateEnumeratedClassWithClsAndSlot() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Color");
        OWLNamedClass a = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty b = this.owlModel.createOWLObjectProperty("slot");
        cls.addSuperclass(this.owlModel.createOWLEnumeratedClass(Arrays.asList(a, b)));
        OntModel newModel = this.createOntModel();
        EnumeratedClass enumeratedClass = (EnumeratedClass)newModel.listEnumeratedClasses().next();
        ExtendedIterator it = enumeratedClass.listOneOf();
        CreateEnumeratedClassesTestCase.assertEquals((Object)newModel.getIndividual(a.getURI()), it.next());
        CreateEnumeratedClassesTestCase.assertEquals((Object)newModel.getIndividual(b.getURI()), it.next());
        CreateEnumeratedClassesTestCase.assertFalse((boolean)it.hasNext());
    }
}

