/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactOWLClassParser;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ParseRDFSDatatypesTestCase
extends AbstractJenaTestCase {
    private OWLClassParser parser = new CompactOWLClassParser();

    public void testParseClosedIntInterval() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        this.owlModel.createOWLDatatypeProperty("hasAge");
        String expression = "hasAge * int[18,24]";
        RDFSClass cls = this.parser.parseClass(this.owlModel, expression);
        ParseRDFSDatatypesTestCase.assertTrue((boolean)(cls instanceof OWLAllValuesFrom));
        OWLAllValuesFrom allValuesFrom = (OWLAllValuesFrom)cls;
        ParseRDFSDatatypesTestCase.assertEquals((String)"int[18,24]", (String)allValuesFrom.getFiller().getBrowserText());
    }

    public void testParseOpenIntInterval() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        this.owlModel.createOWLDatatypeProperty("hasAge");
        String expression = "hasAge * int(18,..)";
        RDFSClass cls = this.parser.parseClass(this.owlModel, expression);
        ParseRDFSDatatypesTestCase.assertTrue((boolean)(cls instanceof OWLAllValuesFrom));
        OWLAllValuesFrom allValuesFrom = (OWLAllValuesFrom)cls;
        ParseRDFSDatatypesTestCase.assertEquals((String)"int(18,..)", (String)allValuesFrom.getFiller().getBrowserText());
    }

    public void testParseOpenIntIntervalAbbrev() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        this.owlModel.createOWLDatatypeProperty("hasAge");
        String expression = "hasAge * int(18,..)";
        RDFSClass cls = this.parser.parseClass(this.owlModel, expression);
        ParseRDFSDatatypesTestCase.assertTrue((boolean)(cls instanceof OWLAllValuesFrom));
        OWLAllValuesFrom allValuesFrom = (OWLAllValuesFrom)cls;
        ParseRDFSDatatypesTestCase.assertEquals((String)"int(18,..)", (String)allValuesFrom.getFiller().getBrowserText());
    }
}

