/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class SynchronizeSuperclassesTestCase
extends AbstractJenaTestCase {
    public void testDefaultSuperclass() {
        RDFProperty subClassOfProperty = this.owlModel.getRDFProperty("rdfs:subClassOf");
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        SynchronizeSuperclassesTestCase.assertEquals((int)1, (int)cls.getSuperclassCount());
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, cls.getSuperclasses(false));
        SynchronizeSuperclassesTestCase.assertSize(1, cls.getPropertyValues(subClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, cls.getPropertyValues(subClassOfProperty));
    }

    public void testChangingSuperclass() {
        RDFProperty subClassOfProperty = this.owlModel.getRDFProperty("rdfs:subClassOf");
        RDFSNamedClass superclass = this.owlModel.createRDFSNamedClass("Superclass");
        RDFSNamedClass subclass = this.owlModel.createRDFSNamedClass("Subclass");
        subclass.addSuperclass(superclass);
        SynchronizeSuperclassesTestCase.assertSize(2, subclass.getPropertyValues(subClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, subclass.getPropertyValues(subClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)superclass, subclass.getPropertyValues(subClassOfProperty));
        subclass.removeSuperclass(this.owlThing);
        SynchronizeSuperclassesTestCase.assertSize(1, subclass.getPropertyValues(subClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)superclass, subclass.getPropertyValues(subClassOfProperty));
    }

    public void testCreateSuperclass() {
        RDFProperty subClassOfProperty = this.owlModel.getRDFProperty("rdfs:subClassOf");
        RDFSNamedClass superclass = this.owlModel.createRDFSNamedClass("Superclass");
        RDFSNamedClass subclass = this.owlModel.createRDFSNamedSubclass("Subclass", superclass);
        SynchronizeSuperclassesTestCase.assertSize(1, subclass.getPropertyValues(subClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)superclass, subclass.getPropertyValues(subClassOfProperty));
    }

    public void testAnonymousSuperclassToImportedClass() throws Exception {
        RDFProperty subClassOfProperty = this.owlModel.getRDFProperty("rdfs:subClassOf");
        this.loadRemoteOntology("importTravel.owl");
        OWLNamedClass c = this.owlModel.getOWLNamedClass("travel:Activity");
        SynchronizeSuperclassesTestCase.assertNotNull((Object)c);
        SynchronizeSuperclassesTestCase.assertSize(0, c.getPropertyValues(subClassOfProperty));
        OWLComplementClass anon = this.owlModel.createOWLComplementClass(c);
        c.addSuperclass(anon);
        Collection supers = c.getPropertyValues(subClassOfProperty);
        SynchronizeSuperclassesTestCase.assertSize(2, supers);
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, supers);
        SynchronizeSuperclassesTestCase.assertContains((Object)anon, supers);
        TripleStore topTS = this.owlModel.getTripleStoreModel().getTopTripleStore();
        TripleStore importedTS = this.owlModel.getTripleStoreModel().getTripleStore(2);
        SynchronizeSuperclassesTestCase.assertTrue((boolean)topTS.contains(c, subClassOfProperty, anon));
        SynchronizeSuperclassesTestCase.assertTrue((boolean)importedTS.contains(c, subClassOfProperty, this.owlThing));
    }

    public void testOWLEquivalentClassWithNamedClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        a.addEquivalentClass(b);
        SynchronizeSuperclassesTestCase.assertContains((Object)b, a.getEquivalentClasses());
        SynchronizeSuperclassesTestCase.assertContains((Object)b, a.getPropertyValues(this.owlModel.getOWLEquivalentClassProperty()));
    }

    public void testSuperclassOfRDFSNamedClass() {
        RDFProperty rdfsSubClassOfProperty = this.owlModel.getRDFSSubClassOfProperty();
        RDFSNamedClass subclass = this.owlModel.createRDFSNamedClass("Sub");
        RDFSNamedClass superclass = this.owlModel.createRDFSNamedClass("Super");
        subclass.addSuperclass(superclass);
        SynchronizeSuperclassesTestCase.assertSize(2, subclass.getSuperclasses(false));
        SynchronizeSuperclassesTestCase.assertContains((Object)superclass, subclass.getSuperclasses(false));
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, subclass.getSuperclasses(false));
        SynchronizeSuperclassesTestCase.assertSize(2, subclass.getPropertyValues(rdfsSubClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)superclass, subclass.getPropertyValues(rdfsSubClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, subclass.getPropertyValues(rdfsSubClassOfProperty));
        subclass.removeSuperclass(superclass);
        SynchronizeSuperclassesTestCase.assertSize(1, subclass.getSuperclasses(false));
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, subclass.getSuperclasses(false));
        SynchronizeSuperclassesTestCase.assertSize(1, subclass.getPropertyValues(rdfsSubClassOfProperty));
        SynchronizeSuperclassesTestCase.assertContains((Object)this.owlThing, subclass.getPropertyValues(rdfsSubClassOfProperty));
    }
}

