/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLSomeValuesFrom;

public abstract class AbstractOWLRestriction
extends AbstractOWLAnonymousClass
implements OWLRestriction {
    public AbstractOWLRestriction(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    AbstractOWLRestriction() {
    }

    public static void checkExpression(String text, RDFProperty onProperty, RDFProperty restrictionProperty) throws OWLClassParseException {
        if (onProperty == null) {
            throw new OWLClassParseException("Please select a property.");
        }
        if (text.trim().length() == 0) {
            throw new OWLClassParseException("Please enter a filler.");
        }
        if (restrictionProperty.getName().equals("owl:hasValue")) {
            DefaultOWLHasValue.checkFillerText(text, onProperty);
        } else if (restrictionProperty.getName().equals("owl:allValuesFrom")) {
            DefaultOWLAllValuesFrom.checkFillerText(text, onProperty, restrictionProperty.getOWLModel());
        } else if (restrictionProperty.getName().equals("owl:someValuesFrom")) {
            DefaultOWLSomeValuesFrom.checkFillerText(text, onProperty);
        } else {
            AbstractOWLCardinalityBase.checkFillerText(text, onProperty);
        }
    }

    protected String getBrowserTextFiller() {
        return this.isDefined() ? this.getFillerText() : "?";
    }

    protected String getBrowserTextPropertyName() {
        RDFProperty property = this.getOnProperty();
        if (property == null) {
            return "<property>";
        }
        return property.getBrowserText();
    }

    public String getNestedBrowserText() {
        return "(" + this.getBrowserText() + ")";
    }

    public RDFProperty getOnProperty() {
        RDFProperty slot = this.getOWLModel().getRDFProperty("owl:onProperty");
        return (RDFProperty)this.getDirectOwnSlotValue(slot);
    }

    public boolean isDefined() {
        return this.getOnProperty() != null && this.isFillerDefined();
    }

    protected boolean isFillerDefined() {
        return this.getDirectOwnSlotValue(this.getFillerProperty()) != null;
    }

    public void setOnProperty(RDFProperty property) {
        RDFProperty onPropertySlot = this.getOWLModel().getRDFProperty("owl:onProperty");
        this.setDirectOwnSlotValue(onPropertySlot, property);
    }
}

