/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class OWLUtil {
    public static void addIsDefinedBy(Instance source, Instance instance) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        source.addOwnSlotValue((Slot)owlModel.getRDFSIsDefinedByProperty(), (Object)instance);
    }

    public static void addLabel(RDFResource source, String label, String language) {
        Object value = null;
        value = language != null && language.trim().length() > 0 ? source.getOWLModel().createRDFSLiteralOrString(label, language.trim()) : label;
        RDFProperty property = source.getOWLModel().getRDFSLabelProperty();
        if (!source.getPropertyValues(property).contains(value)) {
            source.addPropertyValue(property, value);
        }
    }

    public static void addSameAs(Instance source, Instance instance) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        source.addOwnSlotValue((Slot)owlModel.getOWLSameAsProperty(), (Object)instance);
    }

    public static void addVersionInfo(Instance source, String versionInfo) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        source.addOwnSlotValue((Slot)owlModel.getOWLVersionInfoProperty(), (Object)versionInfo);
    }

    public static void assignUniqueURI(RDFUntypedResource eri) {
        OWLModel owlModel = eri.getOWLModel();
        String prefix = "http://protege.stanford.edu/";
        String suffix = "";
        int index = 1;
        while (owlModel.getRDFUntypedResource(String.valueOf(prefix) + index + suffix, false) != null) {
            ++index;
        }
        eri.setName(String.valueOf(prefix) + index + suffix);
    }

    public static boolean confirmSaveAndReload() {
        return OWLUtil.confirmSaveAndReload(null);
    }

    public static boolean confirmSaveAndReload(Project project) {
        return ProtegeUI.getModalDialogFactory().showConfirmDialog((OWLModel)project.getKnowledgeBase(), "This change will not take effect until you save and\nreload your project.  Do you want to do this now?", "Confirm Reload");
    }

    public static void copyAnnotations(Instance source, Instance target) {
        for (Slot slot : source.getKnowledgeBase().getSlots()) {
            List values;
            if (!(slot instanceof OWLProperty) || !((OWLProperty)slot).isAnnotationProperty() || (values = source.getDirectOwnSlotValues(slot)).size() <= 0) continue;
            target.setOwnSlotValues(slot, (Collection)values);
        }
    }

    public static void convertEquivalentClsIntoSuperClses(RDFSClass ownerClass, RDFSClass equivalentClass) {
        if (equivalentClass instanceof OWLIntersectionClass) {
            OWLIntersectionClass intersectionCls = (OWLIntersectionClass)equivalentClass;
            ArrayList<RDFSClass> neo = new ArrayList<RDFSClass>();
            for (RDFSClass operand : intersectionCls.getOperands()) {
                RDFSClass copy = operand.createClone();
                neo.add(copy);
            }
            intersectionCls.delete();
            for (RDFSClass aClass : neo) {
                ownerClass.addSuperclass(aClass);
            }
        } else {
            equivalentClass.removeSuperclass(ownerClass);
        }
    }

    public static void convertSuperClsIntoEquivalentCls(OWLNamedClass ownerCls, RDFSClass superClass) {
        RDFSClass definition = ownerCls.getDefinition();
        OWLUtil.convertSuperClsIntoEquivalentCls(ownerCls, superClass, definition);
    }

    public static void convertSuperClsIntoEquivalentCls(OWLNamedClass ownerCls, RDFSClass superClass, RDFSClass definition) {
        if (definition == null) {
            superClass.addSuperclass(ownerCls);
        } else {
            OWLIntersectionClass intersection;
            RDFSClass copy = superClass.createClone();
            ArrayList<RDFSClass> operands = new ArrayList<RDFSClass>();
            OWLModel owlModel = ownerCls.getOWLModel();
            if (definition instanceof OWLIntersectionClass) {
                intersection = (OWLIntersectionClass)definition;
                for (RDFSClass oldOperand : intersection.getOperands()) {
                    RDFSClass newOperand = oldOperand.createClone();
                    operands.add(newOperand);
                }
            } else {
                RDFSClass equiCopy = definition.createClone();
                operands.add(equiCopy);
            }
            operands.add(copy);
            intersection = owlModel.createOWLIntersectionClass(operands);
            ownerCls.addEquivalentClass(intersection);
            ownerCls.removeSuperclass(definition);
            ownerCls.removeSuperclass(superClass);
        }
    }

    public static Cls createClone(Cls cls) {
        String expression = cls.getBrowserText();
        OWLModel owlModel = (OWLModel)cls.getKnowledgeBase();
        RDFSClass clone = OWLUtil.createClone(owlModel, expression);
        OWLUtil.copyAnnotations((Instance)cls, clone);
        return clone;
    }

    public static RDFSClass createClone(OWLModel owlModel, String expression) {
        OWLClassParser parser = owlModel.getOWLClassParser();
        try {
            return parser.parseClass(owlModel, expression);
        }
        catch (Exception ex) {
            System.err.println("Error in OWLUtil.createClone (" + expression + ")");
            ex.printStackTrace();
            return null;
        }
    }

    public static void ensureSubclassesDisjoint(OWLNamedClass cls) {
        List subclasses = OWLUtil.getPotentiallyDisjointSubclasses(cls);
        for (OWLNamedClass outerCls : subclasses) {
            if (outerCls.isSystem()) continue;
            Collection disjoints = outerCls.getDisjointClasses();
            for (RDFSNamedClass innerClass : subclasses) {
                if (outerCls.equals(innerClass) || disjoints.contains(innerClass)) continue;
                outerCls.addDisjointClass(innerClass);
            }
        }
    }

    public static boolean equalsStructurally(Collection collection1, Collection collection2) {
        if (collection1.size() == collection2.size()) {
            for (RDFObject object1 : collection1) {
                boolean found = false;
                for (RDFObject object2 : collection2) {
                    if (!object1.equalsStructurally(object2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Collection getDocumentation(Instance source) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        return source.getOwnSlotValues((Slot)owlModel.getRDFSCommentProperty());
    }

    public static Collection getInferredDirectTypes(RDFResource resource) {
        RDFProperty inferredTypesProperty = resource.getOWLModel().getRDFProperty("protege:inferredType");
        return resource.getPropertyValues(inferredTypesProperty);
    }

    public static Collection getIsDefinedBy(Instance source) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        return source.getOwnSlotValues((Slot)owlModel.getRDFSIsDefinedByProperty());
    }

    public static Collection getLabels(RDFResource source) {
        return source.getPropertyValues(source.getOWLModel().getRDFSLabelProperty());
    }

    public static Collection getPathsToRoot(Cls cls) {
        ArrayList results = new ArrayList();
        return OWLUtil.getPathToRoot(cls, new LinkedList(), results);
    }

    private static List getPathToRoot(Cls cls, LinkedList list, Collection lists) {
        list.add(0, cls);
        Iterator i = cls.getDirectSuperclasses().iterator();
        Cls rootCls = cls.getKnowledgeBase().getRootCls();
        while (i.hasNext()) {
            Cls superclass = (Cls)i.next();
            if (!cls.isVisible()) continue;
            ArrayList copy = new ArrayList(list);
            OWLUtil.getPathToRoot(superclass, list, lists);
            if (list.getFirst().equals(rootCls)) {
                lists.add(list);
                continue;
            }
            list.clear();
            list.addAll(copy);
        }
        return list;
    }

    public static List getPotentiallyDisjointSubclasses(OWLNamedClass cls) {
        ArrayList<RDFSNamedClass> subclasses = new ArrayList<RDFSNamedClass>();
        for (RDFSNamedClass subClass : cls.getNamedSubclasses()) {
            if (!(subClass instanceof OWLNamedClass) || ((OWLNamedClass)subClass).getDefinition() != null || !subClass.isVisible()) continue;
            subclasses.add(subClass);
        }
        return subclasses;
    }

    public static Set getReferringAnonymousClses(RDFResource instance) {
        Slot directSubclassesSlot = instance.getKnowledgeBase().getSlot(":DIRECT-SUBCLASSES");
        RDFProperty rdfFirstProperty = instance.getOWLModel().getRDFFirstProperty();
        HashSet<Frame> result = new HashSet<Frame>();
        for (Reference reference : instance.getReferences()) {
            if (reference.getFrame() instanceof OWLAnonymousClass) {
                if (directSubclassesSlot.equals(reference.getSlot())) continue;
                result.add(reference.getFrame());
                continue;
            }
            if (!(reference.getFrame() instanceof RDFList) || !rdfFirstProperty.equals(reference.getSlot())) continue;
            RDFList list = (RDFList)reference.getFrame();
            RDFList start = list.getStart();
            OWLUtil.getReferringLogicalClasses(start, result);
        }
        return result;
    }

    public static void getReferringLogicalClasses(RDFList list, Set set) {
        OWLModel kb = list.getOWLModel();
        Collection refs = kb.getReferences(list, 1000);
        for (Reference ref : refs) {
            if (!(ref.getFrame() instanceof OWLNAryLogicalClass) && !(ref.getFrame() instanceof OWLEnumeratedClass)) continue;
            set.add(ref.getFrame());
        }
    }

    public static Collection getSameAs(Instance source) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        return source.getOwnSlotValues((Slot)owlModel.getOWLSameAsProperty());
    }

    public static Collection getSelectableNamedClses(OWLModel owlModel) {
        Collection clses = owlModel.getUserDefinedRDFSNamedClasses();
        clses.add(owlModel.getOWLThingClass());
        if (owlModel.getOWLNamedClassClass().isVisible()) {
            clses.add(owlModel.getOWLNamedClassClass());
        }
        if (owlModel.getRDFPropertyClass().isVisible()) {
            clses.add(owlModel.getOWLDatatypePropertyClass());
            clses.add(owlModel.getOWLObjectPropertyClass());
        }
        return clses;
    }

    public static Collection getVersionInfo(Instance source) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        return source.getOwnSlotValues((Slot)owlModel.getOWLVersionInfoProperty());
    }

    public static boolean hasDirectRestriction(Cls cls, Slot slot, Cls metaCls) {
        for (Cls superCls : cls.getDirectSuperclasses()) {
            OWLRestriction restriction;
            if (!superCls.getDirectType().equals(metaCls) || !(restriction = (OWLRestriction)superCls).getOnProperty().equals(slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOWLDLProfile(OWLModel owlModel) {
        return ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.OWL_DL) && !OWLUtil.hasOWLFullProfile(owlModel);
    }

    public static boolean hasOWLFullProfile(OWLModel owlModel) {
        return ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.OWL_Full);
    }

    public static boolean hasRDFProfile(OWLModel owlModel) {
        return ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.RDF_but_not_OWL);
    }

    public static boolean isInconsistent(Cls cls) {
        Slot slot = ((AbstractOWLModel)cls.getKnowledgeBase()).getSlot("protege:inferredSubclassOf");
        List values = cls.getDirectOwnSlotValues(slot);
        return values.contains(((AbstractOWLModel)cls.getKnowledgeBase()).getOWLNothing());
    }

    public static void printStackTrace() {
        try {
            throw new RuntimeException("Debugging purposes only");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public static void removeIsDefinedBy(Instance source, Instance instance) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        source.removeOwnSlotValue((Slot)owlModel.getRDFSIsDefinedByProperty(), (Object)instance);
    }

    public static void removeLabel(RDFResource source, String label, String language) {
        Object value = null;
        value = language != null && language.trim().length() > 0 ? source.getOWLModel().createRDFSLiteralOrString(label, language.trim()) : label;
        source.removePropertyValue(source.getOWLModel().getRDFSLabelProperty(), value);
    }

    public static void removeSameAs(Instance source, Instance instance) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        source.removeOwnSlotValue((Slot)owlModel.getOWLSameAsProperty(), (Object)instance);
    }

    public static void removeSubclassesDisjoint(OWLNamedClass cls) {
        ArrayList<RDFSNamedClass> subclasses = new ArrayList<RDFSNamedClass>();
        for (RDFSNamedClass subClass : cls.getNamedSubclasses()) {
            if (!(subClass instanceof OWLNamedClass) || ((OWLNamedClass)subClass).getDefinition() != null || !subClass.isVisible()) continue;
            subclasses.add(subClass);
        }
        TripleStoreModel tsm = cls.getOWLModel().getTripleStoreModel();
        RDFProperty owlDisjointWithProperty = cls.getOWLModel().getOWLDisjointWithProperty();
        for (OWLNamedClass oWLNamedClass : subclasses) {
            if (!oWLNamedClass.isEditable()) continue;
            Collection disjoints = oWLNamedClass.getDisjointClasses();
            for (OWLNamedClass oWLNamedClass2 : subclasses) {
                if (oWLNamedClass.equals(oWLNamedClass2) || !disjoints.contains(oWLNamedClass2) || !tsm.isEditableTriple(oWLNamedClass, owlDisjointWithProperty, oWLNamedClass2)) continue;
                oWLNamedClass.removeDisjointClass(oWLNamedClass2);
            }
        }
    }

    public static void removeVersionInfo(Instance source, String versionInfo) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        source.removeOwnSlotValue((Slot)owlModel.getOWLVersionInfoProperty(), (Object)versionInfo);
    }

    public static void resetComputedSuperclasses(OWLModel owlModel) {
        OWLUtil.resetComputedSuperclasses(owlModel, owlModel.getUserDefinedOWLNamedClasses());
    }

    public static void resetComputedSuperclasses(OWLModel owlModel, Collection clses) {
        AbstractOWLModel abstractOWLModel = (AbstractOWLModel)owlModel;
        RDFProperty computedSubClassesSlot = abstractOWLModel.getProtegeInferredSubclassesProperty();
        RDFProperty computedSuperClassesSlot = abstractOWLModel.getProtegeInferredSuperclassesProperty();
        for (OWLNamedClass owlCls : clses) {
            owlCls.setOwnSlotValues(computedSubClassesSlot, Collections.EMPTY_LIST);
            owlCls.setOwnSlotValues(computedSuperClassesSlot, Collections.EMPTY_LIST);
        }
        owlModel.getOWLThingClass().setOwnSlotValues(computedSubClassesSlot, Collections.EMPTY_LIST);
    }

    public static boolean saveAndReloadProject() {
        ProjectManager projectManager = ProjectManager.getProjectManager();
        if (projectManager.saveProjectRequest()) {
            URI uri = projectManager.getCurrentProject().getProjectURI();
            if (projectManager.closeProjectRequest()) {
                projectManager.loadProject(uri);
                return true;
            }
        }
        return false;
    }

    public static void setDocumentation(Instance source, Collection values) {
        OWLModel owlModel = (OWLModel)source.getKnowledgeBase();
        source.setOwnSlotValues((Slot)owlModel.getRDFSCommentProperty(), values);
    }

    public static void setConsistentClassificationStatus(OWLNamedClass namedCls) {
        if (namedCls.isMetaclass()) {
            namedCls.setClassificationStatus(1);
        } else {
            Collection asserted = namedCls.getNamedSuperclasses();
            Collection inferred = namedCls.getInferredSuperclasses();
            ArrayList diff = new ArrayList(inferred);
            diff.removeAll(asserted);
            int status = diff.size() == 0 ? 1 : 3;
            namedCls.setClassificationStatus(status);
        }
    }

    public static void sortSubclasses(Cls superCls) {
        if (superCls.getDirectSubclassCount() > 1) {
            ArrayList oldSuperclasses = new ArrayList(superCls.getDirectSubclasses());
            ArrayList clses = new ArrayList(oldSuperclasses);
            Collections.sort(clses, new FrameComparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof RDFSNamedClass && o2 instanceof RDFSNamedClass) {
                        return ((RDFSNamedClass)o1).getBrowserText().compareTo(((RDFSNamedClass)o2).getBrowserText());
                    }
                    if (o1 instanceof RDFSNamedClass) {
                        return 1;
                    }
                    if (o2 instanceof RDFSNamedClass) {
                        return -1;
                    }
                    return 0;
                }
            });
            int i = 0;
            while (i < clses.size() - 1) {
                Cls a = (Cls)clses.get(i);
                Cls b = (Cls)clses.get(i + 1);
                superCls.moveDirectSubclass(b, a);
                ++i;
            }
        }
    }

    public static void addProtegeType(RDFResource resource, RDFSClass type) {
        resource.getOWLModel().addDirectType(resource, type);
    }

    public static RDFSClass getDirectRDFType(RDFResource resource) {
        return (RDFSClass)resource.getOWLModel().getDirectType(resource);
    }

    public static Collection getDirectRDFTypes(RDFResource resource) {
        return resource.getOWLModel().getDirectTypes(resource);
    }

    public static boolean hasProtegeType(RDFResource resource, RDFSClass type) {
        return resource.getOWLModel().hasDirectType(resource, type);
    }

    public static boolean hasProtegeType(RDFResource resource, RDFSClass type, boolean includingSuperclasses) {
        if (includingSuperclasses) {
            return resource.getOWLModel().hasType(resource, type);
        }
        return resource.getOWLModel().hasDirectType(resource, type);
    }

    public static void removeProtegeType(RDFResource resource, RDFSClass type) {
        resource.getOWLModel().removeDirectType(resource, type);
    }

    public static void setProtegeType(RDFResource resource, RDFSClass type) {
        resource.getOWLModel().setDirectType(resource, type);
    }

    public static void setProtegeTypes(RDFResource resource, Collection types) {
        resource.getOWLModel().setDirectTypes(resource, types);
    }

    public static void addDifferentFrom(RDFResource resource, RDFResource differentFrom) {
        OWLModel owlModel = resource.getOWLModel();
        owlModel.addOwnSlotValue((Frame)resource, owlModel.getOWLDifferentFromProperty(), differentFrom);
    }

    public static void removeDifferentFrom(RDFResource resource, RDFResource differentFrom) {
        OWLModel owlModel = resource.getOWLModel();
        owlModel.removeOwnSlotValue((Frame)resource, owlModel.getOWLDifferentFromProperty(), differentFrom);
    }

    public static void addComment(RDFResource resource, String comment) {
        OWLModel owlModel = resource.getOWLModel();
        owlModel.addOwnSlotValue((Frame)resource, owlModel.getRDFSCommentProperty(), comment);
    }

    public static void removeComment(RDFResource resource, String comment) {
        OWLModel owlModel = resource.getOWLModel();
        owlModel.removeOwnSlotValue((Frame)resource, owlModel.getRDFSCommentProperty(), comment);
    }

    public static void addPropertyValue(RDFResource resource, RDFProperty property, Object value) {
        OWLModel kb = resource.getOWLModel();
        kb.addOwnSlotValue((Frame)resource, property, value);
    }

    public static Collection getComments(RDFResource resource) {
        OWLModel owlModel = resource.getOWLModel();
        return resource.getPropertyValues(owlModel.getRDFSCommentProperty());
    }

    public static void setComment(RDFResource resource, String comment) {
        OWLModel owlModel = resource.getOWLModel();
        resource.setPropertyValues(owlModel.getRDFSCommentProperty(), comment == null ? Collections.EMPTY_LIST : (Collection)Collections.singleton(comment));
    }

    public static void setComments(RDFResource resource, Collection comments) {
        OWLModel owlModel = resource.getOWLModel();
        resource.setPropertyValues(owlModel.getRDFSCommentProperty(), comments);
    }

    public static void setInferredTypes(RDFResource resource, Collection types) {
        RDFProperty inferredTypesProperty = resource.getOWLModel().getRDFProperty("protege:inferredType");
        resource.setPropertyValues(inferredTypesProperty, types);
    }

    public static Collection getDifferentFrom(RDFResource resource) {
        OWLModel owlModel = resource.getOWLModel();
        return resource.getPropertyValues(owlModel.getRDFProperty("owl:differentFrom"));
    }

    public static Object getPropertyValue(RDFResource resource, RDFProperty property, boolean includingSubproperties) {
        Collection values = OWLUtil.getPropertyValues(resource, property, includingSubproperties);
        return values.isEmpty() ? null : values.iterator().next();
    }

    public static int getPropertyValueCount(RDFResource resource, RDFProperty property) {
        return resource.getOWLModel().getDirectOwnSlotValues((Frame)resource, property).size();
    }

    public static Collection getPropertyValues(RDFResource resource, RDFProperty property, boolean includingSubproperties) {
        if (includingSubproperties) {
            return resource.getOWLModel().getOWLFrameStore().getOwnSlotValuesConverting((Frame)resource, property);
        }
        return resource.getOWLModel().getOWLFrameStore().getDirectOwnSlotValuesConverting((Frame)resource, property);
    }

    public static Iterator listPropertyValues(RDFResource resource, RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.getPropertyValues(resource, property, includingSubproperties).iterator();
    }

    public static void removePropertyValue(RDFResource resource, RDFProperty property, Object value) {
        OWLModel kb = resource.getOWLModel();
        if (value instanceof RDFSLiteral) {
            value = ((DefaultRDFSLiteral)value).getRawValue();
        }
        kb.removeOwnSlotValue((Frame)resource, property, value);
    }

    public static void setPropertyValue(RDFResource resource, RDFProperty property, Object value) {
        OWLModel owlModel = resource.getOWLModel();
        owlModel.setOwnSlotValues((Frame)resource, property, value == null ? Collections.EMPTY_LIST : (Collection)Collections.singleton(value));
    }

    public static void setPropertyValues(RDFResource resource, RDFProperty property, Collection values) {
        OWLModel kb = resource.getOWLModel();
        kb.setOwnSlotValues((Frame)resource, property, values);
    }

    public static boolean isSystem(Frame resource) {
        Slot directTypeSlot;
        MergingNarrowFrameStore mnfs = MergingNarrowFrameStore.get((KnowledgeBase)resource.getKnowledgeBase());
        NarrowFrameStore systemFrameStore = mnfs.getSystemFrameStore();
        return systemFrameStore.getValuesCount(resource, directTypeSlot = resource.getKnowledgeBase().getSlot(":DIRECT-TYPE"), null, false) > 0;
    }

    public static Collection getPropertyValueLiterals(RDFResource resource, RDFProperty property) {
        return ((AbstractOWLModel)resource.getOWLModel()).getPropertyValueLiterals(resource, property);
    }

    public static RDFSLiteral getPropertyValueLiteral(RDFResource resource, RDFProperty property) {
        Object value = OWLUtil.getPropertyValue(resource, property, false);
        if (value != null) {
            if (value instanceof RDFSLiteral) {
                return (RDFSLiteral)value;
            }
            return resource.getOWLModel().createRDFSLiteral(value);
        }
        return null;
    }

    public static Collection getRDFProperties(RDFResource resource) {
        ArrayList<RDFProperty> result = new ArrayList<RDFProperty>();
        OWLModel owlModel = resource.getOWLModel();
        ArrayList properties = new ArrayList(owlModel.getRDFProperties());
        if (!(resource instanceof RDFProperty)) {
            properties.remove(owlModel.getRDFSSubPropertyOfProperty());
        }
        for (RDFProperty property : properties) {
            if (resource.getPropertyValueCount(property) <= 0) continue;
            result.add(property);
        }
        return result;
    }

    public static void addResourceListener(RDFResource resource, ResourceListener listener) {
        if (!(listener instanceof ResourceAdapter)) {
            throw new IllegalArgumentException("Listener must be a ResourceAdapter");
        }
        resource.addInstanceListener(listener);
    }

    public static void removeResourceListener(RDFResource resource, ResourceListener listener) {
        if (!(listener instanceof ResourceAdapter)) {
            throw new IllegalArgumentException("Listener must be a ResourceAdapter");
        }
        resource.removeInstanceListener(listener);
    }

    public static boolean hasPropertyValue(RDFResource resource, RDFProperty property, Object value, boolean includingSubproperties) {
        return resource.getPropertyValues(property, includingSubproperties).contains(value);
    }

    public static void addPropertyValueListener(RDFResource resource, PropertyValueListener listener) {
        if (!(listener instanceof PropertyValueAdapter)) {
            throw new IllegalArgumentException("Listener must be a PropertyValueAdapter");
        }
        resource.addFrameListener(listener);
    }

    public static void removePropertyValueListener(RDFResource resource, PropertyValueListener listener) {
        resource.removeFrameListener(listener);
    }

    public static Collection getPossibleRDFProperties(RDFResource resource) {
        HashSet<RDFProperty> result = new HashSet<RDFProperty>();
        for (RDFSClass type : resource.getProtegeTypes()) {
            Collection ps = type.getUnionDomainProperties(true);
            result.addAll(ps);
            for (RDFProperty property : ps) {
                for (RDFProperty subproperty : property.getSubproperties(true)) {
                    if (subproperty.getDomain(false) != null) continue;
                    result.add(subproperty);
                }
            }
        }
        return result;
    }

    public static RDFResource as(RDFResource resource, Class javaInterface) {
        return resource.getOWLModel().getOWLJavaFactory().as(resource, javaInterface);
    }

    public static boolean canAs(RDFResource resource, Class javaInterface) {
        return resource.getOWLModel().getOWLJavaFactory().canAs(resource, javaInterface);
    }

    public static Collection getPropertyValuesAs(RDFResource resource, RDFProperty property, Class javaInterface) {
        ArrayList<RDFResource> results = new ArrayList<RDFResource>();
        for (Object o : resource.getPropertyValues(property)) {
            if (o instanceof RDFResource) {
                results.add(((RDFResource)o).as(javaInterface));
                continue;
            }
            results.add((RDFResource)o);
        }
        return results;
    }

    public static RDFResource getPropertyValueAs(RDFResource resource, RDFProperty property, Class javaInterface) {
        RDFResource r = (RDFResource)resource.getPropertyValue(property);
        if (r != null) {
            return r.as(javaInterface);
        }
        return null;
    }

    public static Iterator listPropertyValuesAs(RDFResource resource, RDFProperty property, Class javaInterface) {
        return OWLUtil.getPropertyValuesAs(resource, property, javaInterface).iterator();
    }

    public static boolean hasPropertyValue(RDFResource resource, RDFProperty property) {
        return resource.getPropertyValueCount(property) > 0;
    }

    public static boolean hasPropertyValue(RDFResource resource, RDFProperty property, boolean includingSubproperties) {
        if (includingSubproperties) {
            return resource.getPropertyValues(property, includingSubproperties).size() > 0;
        }
        return OWLUtil.hasPropertyValue(resource, property);
    }

    public static RDFSClass getRDFType(RDFResource resource) {
        return (RDFSClass)resource.getPropertyValue(resource.getOWLModel().getRDFTypeProperty());
    }

    public static Collection getRDFTypes(RDFResource resource) {
        return resource.getPropertyValues(resource.getOWLModel().getRDFTypeProperty());
    }

    public static void addRDFType(RDFResource resource, RDFSClass type) {
        OWLUtil.addProtegeType(resource, type);
    }

    public static void removeRDFType(RDFResource resource, RDFSClass type) {
        OWLUtil.removeProtegeType(resource, type);
    }

    public static boolean hasRDFType(RDFResource resource, RDFSClass type) {
        return resource.getRDFTypes().contains(type);
    }

    public static boolean hasRDFType(RDFResource resource, RDFSClass type, boolean includingSuperclasses) {
        if (includingSuperclasses) {
            return OWLUtil.hasProtegeType(resource, type, includingSuperclasses);
        }
        return OWLUtil.hasRDFType(resource, type);
    }

    public static void sortSubclasses(OWLModel owlModel) {
        for (OWLNamedClass namedCls : owlModel.getUserDefinedOWLNamedClasses()) {
            OWLUtil.sortSubclasses(namedCls);
        }
        OWLUtil.sortSubclasses(owlModel.getOWLThingClass());
    }

    public static void setRDFType(RDFResource resource, RDFSClass type) {
        OWLUtil.setProtegeType(resource, type);
    }

    public static void setRDFTypes(RDFResource resource, Collection types) {
        OWLUtil.setProtegeTypes(resource, types);
    }

    public static Collection getHasValuesOnTypes(RDFResource resource, RDFProperty property) {
        HashSet<Object> results = new HashSet<Object>();
        for (RDFSClass type : resource.getRDFTypes()) {
            Object hasValue;
            if (!(type instanceof OWLNamedClass) || (hasValue = ((OWLNamedClass)type).getHasValue(property)) == null) continue;
            results.add(hasValue);
        }
        return results;
    }

    public static boolean containsAnonymousClass(Collection clses) {
        for (Cls cls : clses) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            return true;
        }
        return false;
    }

    public static List removeInvisibleResources(Iterator it) {
        ArrayList<RDFResource> results = new ArrayList<RDFResource>();
        while (it.hasNext()) {
            RDFResource resource = (RDFResource)it.next();
            if (!resource.isVisible()) continue;
            results.add(resource);
        }
        return results;
    }

    public static boolean isValidPropertyValue(RDFResource resource, RDFProperty property, Object object) {
        return resource.getOWLModel().isValidPropertyValue(resource, property, object);
    }

    public static RDFResource getAllValuesFromOnTypes(RDFResource resource, RDFProperty property) {
        Iterator types = resource.listRDFTypes();
        while (types.hasNext()) {
            RDFResource all;
            RDFSClass type = (RDFSClass)types.next();
            if (!(type instanceof OWLNamedClass) || (all = ((OWLNamedClass)type).getAllValuesFrom(property)) == null) continue;
            return all;
        }
        return property.getRange();
    }

    public static OWLOntology getActiveOntology(OWLModel owlModel) {
        OWLOntology owlOntology = owlModel.getDefaultOWLOntology();
        for (OWLOntology curOnt : owlModel.getOWLOntologies()) {
            TripleStoreModel tsm = owlModel.getTripleStoreModel();
            TripleStore activeTripleStore = tsm.getActiveTripleStore();
            if (!activeTripleStore.contains(curOnt, owlModel.getRDFTypeProperty(), owlModel.getOWLOntologyClass())) continue;
            owlOntology = curOnt;
            break;
        }
        return owlOntology;
    }
}

