/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class AbstractOWLPropertyTestCase
extends AbstractJenaTestCase {
    public void testInverseFunctionalProperty() {
        RDFSNamedClass metaclass = this.owlModel.getRDFSNamedClass("owl:InverseFunctionalProperty");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        AbstractOWLPropertyTestCase.assertFalse((boolean)property.isInverseFunctional());
        property.setInverseFunctional(true);
        AbstractOWLPropertyTestCase.assertTrue((boolean)property.isInverseFunctional());
        AbstractOWLPropertyTestCase.assertSize(2, property.getProtegeTypes());
        AbstractOWLPropertyTestCase.assertTrue((boolean)property.hasProtegeType(metaclass));
        property.setInverseFunctional(false);
        AbstractOWLPropertyTestCase.assertFalse((boolean)property.isInverseFunctional());
        AbstractOWLPropertyTestCase.assertSize(1, property.getProtegeTypes());
        property.addProtegeType(metaclass);
        AbstractOWLPropertyTestCase.assertTrue((boolean)property.isInverseFunctional());
    }

    public void testInverseFunctionalSuperproperty() {
        RDFSNamedClass metaclass = this.owlModel.getRDFSNamedClass("owl:InverseFunctionalProperty");
        OWLDatatypeProperty superproperty = this.owlModel.createOWLDatatypeProperty("super");
        OWLDatatypeProperty subproperty = this.owlModel.createOWLDatatypeProperty("sub");
        subproperty.addSuperproperty(superproperty);
        superproperty.setInverseFunctional(true);
        AbstractOWLPropertyTestCase.assertFalse((boolean)subproperty.hasProtegeType(metaclass));
        AbstractOWLPropertyTestCase.assertTrue((boolean)subproperty.isInverseFunctional());
    }
}

