/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DefaultOWLUnionClassTestCase
extends AbstractJenaTestCase {
    public void testSimpleUnion() {
        RDFProperty unionOfProperty = this.owlModel.getRDFProperty("owl:unionOf");
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("ClassA");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("ClassB");
        OWLUnionClass c = this.owlModel.createOWLUnionClass();
        DefaultOWLUnionClassTestCase.assertEquals((Object)unionOfProperty, (Object)c.getOperandsProperty());
        c.addOperand(clsA);
        c.addOperand(clsB);
        DefaultOWLUnionClassTestCase.assertSize(2, c.getOperands());
        DefaultOWLUnionClassTestCase.assertSize(1, c.getPropertyValues(unionOfProperty));
        RDFList list = (RDFList)c.getPropertyValue(unionOfProperty);
        DefaultOWLUnionClassTestCase.assertContains((Object)clsA, list.getValues());
        DefaultOWLUnionClassTestCase.assertContains((Object)clsB, list.getValues());
        DefaultOWLUnionClassTestCase.assertTrue((boolean)list.isClosed());
        c.removeOperand(clsB);
        DefaultOWLUnionClassTestCase.assertSize(1, c.getOperands());
        DefaultOWLUnionClassTestCase.assertContains((Object)clsA, c.getOperands());
        list = (RDFList)c.getPropertyValue(unionOfProperty);
        DefaultOWLUnionClassTestCase.assertTrue((boolean)list.isClosed());
    }
}

