/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class GetExpressionRootTestCase
extends AbstractJenaTestCase {
    public void testThisIsRoot() {
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(aCls);
        personCls.addSuperclass(complementCls);
        GetExpressionRootTestCase.assertEquals((Object)complementCls, (Object)complementCls.getExpressionRoot());
    }

    public void testOWLIntersectionClass() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(bCls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(aCls);
        intersectionCls.addOperand(complementCls);
        personCls.addSuperclass(intersectionCls);
        GetExpressionRootTestCase.assertEquals((Object)intersectionCls, (Object)intersectionCls.getExpressionRoot());
        GetExpressionRootTestCase.assertEquals((Object)intersectionCls, (Object)complementCls.getExpressionRoot());
    }

    public void testDeepOWLUnionClass() {
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("children");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(aCls);
        OWLAllValuesFrom allRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, complementCls);
        OWLComplementClass complementOfAll = this.owlModel.createOWLComplementClass(allRestriction);
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(aCls);
        unionCls.addOperand(complementOfAll);
        GetExpressionRootTestCase.assertEquals((Object)unionCls, (Object)complementCls.getExpressionRoot());
        GetExpressionRootTestCase.assertEquals((Object)unionCls, (Object)allRestriction.getExpressionRoot());
        GetExpressionRootTestCase.assertEquals((Object)unionCls, (Object)complementOfAll.getExpressionRoot());
        GetExpressionRootTestCase.assertEquals((Object)unionCls, (Object)unionCls.getExpressionRoot());
    }
}

