/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;
import java.util.HashSet;

public class OWLModelGetOWLIndividualsTestCase
extends AbstractJenaTestCase {
    public void testDefaultOWLIndividuals() {
        Collection indis = this.owlModel.getOWLIndividuals();
        OWLModelGetOWLIndividualsTestCase.assertSize(0, indis);
    }

    public void testGetOWLIndividuals() {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass parentClass = this.owlModel.createOWLNamedSubclass("Parent", personClass);
        OWLIndividual personA = personClass.createOWLIndividual("A");
        OWLIndividual personB = personClass.createOWLIndividual("B");
        OWLIndividual parentC = parentClass.createOWLIndividual("C");
        HashSet indis = new HashSet(this.owlModel.getOWLIndividuals());
        OWLModelGetOWLIndividualsTestCase.assertSize(3, indis);
        OWLModelGetOWLIndividualsTestCase.assertContains((Object)personA, indis);
        OWLModelGetOWLIndividualsTestCase.assertContains((Object)personB, indis);
        OWLModelGetOWLIndividualsTestCase.assertContains((Object)parentC, indis);
        OWLAllDifferent allDifferent = this.owlModel.createOWLAllDifferent();
        allDifferent.addDistinctMember(personA);
        allDifferent.addDistinctMember(personB);
        OWLModelGetOWLIndividualsTestCase.assertEquals(indis, new HashSet(this.owlModel.getOWLIndividuals()));
        this.owlModel.createOWLOntology("Test", "http://dummy/ont");
        OWLModelGetOWLIndividualsTestCase.assertEquals(indis, new HashSet(this.owlModel.getOWLIndividuals()));
    }

    public void testRDFIndividual() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFIndividual indi = cls.createRDFIndividual("Individual");
        OWLModelGetOWLIndividualsTestCase.assertSize(0, this.owlModel.getOWLIndividuals());
    }

    public void testMatthewsOWLIndividuals() {
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("ClsA");
        OWLIndividual indOfA = clsA.createOWLIndividual("indInstA");
        OWLIndividual anonInd = this.owlModel.getOWLThingClass().createOWLIndividual(this.owlModel.getNextAnonymousResourceName());
        OWLSomeValuesFrom someValuesFrom = this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.owlModel.createOWLObjectProperty("propP"), this.owlModel.createOWLNamedClass("ClsB"));
        OWLIndividual indOfAnon = (OWLIndividual)someValuesFrom.createInstance("indInstAnon");
        Collection instancesOfOWLThing = this.owlModel.getOWLThingClass().getInstances(true);
        Collection owlIndividuals = this.owlModel.getOWLIndividuals();
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)(indOfA instanceof OWLIndividual));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)(anonInd instanceof OWLIndividual));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)(indOfAnon instanceof OWLIndividual));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)instancesOfOWLThing.contains(indOfA));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)owlIndividuals.contains(indOfA));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)instancesOfOWLThing.contains(anonInd));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)owlIndividuals.contains(anonInd));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)instancesOfOWLThing.contains(indOfAnon));
        OWLModelGetOWLIndividualsTestCase.assertTrue((boolean)owlIndividuals.contains(indOfAnon));
    }
}

