/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TripleStoreUtil {
    public static void addToTripleStore(OWLModel owlModel, TripleStore tripleStore, RDFResource subject, RDFProperty predicate, Object object) {
        TripleStore oldTripleStore = owlModel.getTripleStoreModel().getActiveTripleStore();
        if (oldTripleStore != tripleStore) {
            owlModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
            subject.addPropertyValue(predicate, object);
            owlModel.getTripleStoreModel().setActiveTripleStore(oldTripleStore);
        } else {
            subject.addPropertyValue(predicate, object);
        }
    }

    public static TripleStore ensureActiveTripleStore(RDFResource resource) {
        OWLModel owlModel = resource.getOWLModel();
        TripleStoreModel tsm = owlModel.getTripleStoreModel();
        if (tsm != null) {
            TripleStore tripleStore = tsm.getHomeTripleStore(resource);
            tsm.setActiveTripleStore(tripleStore);
            return tripleStore;
        }
        return null;
    }

    public static RDFResource getFirstOntology(OWLModel owlModel, TripleStore tripleStore) {
        OWLNamedClass owlOntologyClass = owlModel.getOWLOntologyClass();
        Iterator ontologies = tripleStore.listSubjects(owlModel.getRDFTypeProperty(), owlOntologyClass);
        if (ontologies.hasNext()) {
            Frame next = (Frame)ontologies.next();
            if (next instanceof RDFResource) {
                return (RDFResource)next;
            }
            return new DefaultOWLOntology(owlModel, next.getFrameID());
        }
        return null;
    }

    public static TripleStore getTripleStoreOf(RDFResource subject, Slot slot, Object object) {
        if (subject.getOWLModel() instanceof OWLDatabaseModel) {
            return subject.getOWLModel().getTripleStoreModel().getTopTripleStore();
        }
        if (object instanceof RDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        OWLModel owlModel = subject.getOWLModel();
        for (TripleStore ts : owlModel.getTripleStoreModel().getTripleStores()) {
            if (!ts.getNarrowFrameStore().getValues((Frame)subject, slot, null, false).contains(object)) continue;
            return ts;
        }
        return null;
    }

    public static Iterator listDependingTriples(RDFResource subject) {
        ArrayList result = new ArrayList();
        TripleStoreUtil.getDependingTriples(subject, result);
        return result.iterator();
    }

    private static void getDependingTriples(RDFResource subject, List result) {
        OWLModel owlModel = subject.getOWLModel();
        Iterator it = owlModel.getTripleStoreModel().listTriplesWithSubject(subject);
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            result.add(triple);
            if (!(triple.getObject() instanceof RDFResource)) continue;
            RDFResource object = (RDFResource)triple.getObject();
            if (object.isAnonymous()) {
                TripleStoreUtil.getDependingTriples(object, result);
                continue;
            }
            RDFSClass type = object.getRDFType();
            if (type == null) continue;
            DefaultTriple typeTriple = new DefaultTriple(object, owlModel.getRDFTypeProperty(), type);
            result.add(typeTriple);
        }
    }

    public static void moveResources(Collection resources, TripleStore sourceTS, TripleStore targetTS) {
        if (!resources.isEmpty()) {
            OWLModel owlModel = ((RDFResource)resources.iterator().next()).getOWLModel();
            NarrowFrameStore sourceFS = sourceTS.getNarrowFrameStore();
            NarrowFrameStore targetFS = targetTS.getNarrowFrameStore();
            Collection slots = owlModel.getSlots();
            for (RDFResource resource : resources) {
                TripleStoreUtil.moveResource(resource, slots, sourceFS, targetFS);
            }
            owlModel.flushCache();
        }
    }

    private static void moveResource(Instance instance, Collection slots, NarrowFrameStore sourceFS, NarrowFrameStore targetFS) {
        for (Slot slot : slots) {
            List values = sourceFS.getValues((Frame)instance, slot, null, false);
            for (Object value : values) {
                sourceFS.removeValue((Frame)instance, slot, null, false, value);
            }
            targetFS.addValues((Frame)instance, slot, null, false, (Collection)values);
        }
    }

    public static void replaceTriple(final Triple oldTriple, final Triple newTriple) {
        OWLModel owlModel = oldTriple.getSubject().getOWLModel();
        TripleStore ts = TripleStoreUtil.getTripleStoreOf(oldTriple.getSubject(), oldTriple.getPredicate(), oldTriple.getObject());
        TripleStoreUtil.runInTripleStore(owlModel, ts, new Runnable(){

            public void run() {
                oldTriple.getSubject().removePropertyValue(oldTriple.getPredicate(), oldTriple.getObject());
                newTriple.getSubject().addPropertyValue(newTriple.getPredicate(), newTriple.getObject());
            }
        });
    }

    public static void runInHomeTripleStoreOf(RDFResource resource, Runnable runnable) {
        OWLModel owlModel = resource.getOWLModel();
        TripleStore homeTS = owlModel.getTripleStoreModel().getHomeTripleStore(resource);
        TripleStoreUtil.runInTripleStore(owlModel, homeTS, runnable);
    }

    public static void runInTripleStore(OWLModel owlModel, TripleStore ts, Runnable runnable) {
        TripleStoreModel tsm = owlModel.getTripleStoreModel();
        TripleStore oldActiveTS = tsm.getActiveTripleStore();
        if (oldActiveTS != ts && ts != null) {
            tsm.setActiveTripleStore(ts);
            runnable.run();
            tsm.setActiveTripleStore(oldActiveTS);
        } else {
            runnable.run();
        }
    }

    public static void sortSlotValues(NarrowFrameStore narrowFrameStore, Instance instance, Slot slot, Comparator comparator) {
        List oldValues = narrowFrameStore.getValues((Frame)instance, slot, null, false);
        if (!oldValues.isEmpty()) {
            ArrayList values = new ArrayList(oldValues);
            Collections.sort(values, comparator);
            narrowFrameStore.setValues((Frame)instance, slot, null, false, values);
        }
    }

    public static void sortSubclasses(OWLModel owlModel) {
        NarrowFrameStore nfs;
        Slot subclassesSlot = owlModel.getSlot(":DIRECT-SUBCLASSES");
        Collection namedClasses = owlModel.getUserDefinedRDFSNamedClasses();
        for (RDFSNamedClass namedClass : namedClasses) {
            TripleStore homeTripleStore = owlModel.getTripleStoreModel().getHomeTripleStore(namedClass);
            nfs = homeTripleStore.getNarrowFrameStore();
            TripleStoreUtil.sortSlotValues(nfs, namedClass, subclassesSlot, (Comparator)new FrameComparator());
        }
        OWLNamedClass owlThingClass = owlModel.getOWLThingClass();
        Iterator tripleStores = owlModel.getTripleStoreModel().listUserTripleStores();
        while (tripleStores.hasNext()) {
            TripleStore tripleStore = (TripleStore)tripleStores.next();
            nfs = tripleStore.getNarrowFrameStore();
            TripleStoreUtil.sortSlotValues(nfs, owlThingClass, subclassesSlot, (Comparator)new FrameComparator());
        }
        owlModel.flushCache();
    }

    public static void switchTripleStore(OWLModel owlModel, TripleStore tripleStore) {
        TripleStoreModel tsm = owlModel.getTripleStoreModel();
        if (tsm.getActiveTripleStore() != tripleStore) {
            WaitCursor waitCursor = new WaitCursor(ProtegeUI.getTopLevelContainer(owlModel.getProject()));
            tsm.setActiveTripleStore(tripleStore);
            tsm.updateEditableResourceState();
            ProtegeUI.reloadUI(owlModel.getProject());
            waitCursor.hide();
        }
    }

    public static void updateFrameInclusion(MergingNarrowFrameStore mnfs, Slot nameSlot) {
        NarrowFrameStore activeFrameStore = mnfs.getActiveFrameStore();
        TripleStoreUtil.updateFrameInclusion(activeFrameStore, nameSlot, false);
        NarrowFrameStore systemFrameStore = mnfs.getSystemFrameStore();
        for (NarrowFrameStore frameStore : mnfs.getAllFrameStores()) {
            if (frameStore == systemFrameStore || frameStore == activeFrameStore) continue;
            TripleStoreUtil.updateFrameInclusion(frameStore, nameSlot, true);
        }
    }

    private static void updateFrameInclusion(NarrowFrameStore frameStore, Slot nameSlot, boolean included) {
        for (Frame frame : frameStore.getFrames()) {
            if (frame.isSystem() || frameStore.getValuesCount(frame, nameSlot, null, false) <= 0) continue;
            frame.setIncluded(included);
            frame.setEditable(!included);
        }
    }
}

