/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.TripleChangePostProcessor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTripleStoreModel
implements TripleStoreModel {
    protected MergingNarrowFrameStore mnfs;
    private Slot nameSlot;
    private OWLModel owlModel;
    protected List<TripleStore> ts = new ArrayList<TripleStore>();

    public AbstractTripleStoreModel(OWLModel owlModel) {
        this.nameSlot = owlModel.getSlot(":NAME");
        this.mnfs = MergingNarrowFrameStore.get((KnowledgeBase)owlModel);
        this.owlModel = owlModel;
    }

    public void endTripleStoreChanges() {
        this.owlModel.flushCache();
        Collection resources = this.owlModel.getRDFResources();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            RDFResource resource = (RDFResource)it.next();
            if (!resource.isSystem()) continue;
            it.remove();
        }
        OWLJavaFactoryUpdater.run(this.owlModel, resources);
        this.owlModel.setGenerateEventsEnabled(false);
        try {
            TripleChangePostProcessor.postProcess(this.owlModel);
        }
        finally {
            this.owlModel.setGenerateEventsEnabled(true);
        }
        this.owlModel.flushCache();
    }

    public TripleStore getActiveTripleStore() {
        if (this.mnfs == null && this.ts.size() == 1) {
            return this.ts.get(0);
        }
        NarrowFrameStore activeFrameStore = this.mnfs.getActiveFrameStore();
        String name = activeFrameStore.getName();
        return this.getTripleStore(name);
    }

    public TripleStore getHomeTripleStore(RDFResource resource) {
        for (TripleStore tripleStore : this.ts) {
            if (tripleStore.getNarrowFrameStore().getValuesCount((Frame)resource, this.nameSlot, null, false) <= 0) continue;
            return tripleStore;
        }
        return null;
    }

    public Collection getPropertyValues(RDFResource resource, RDFProperty property) {
        List values = this.mnfs.getValues((Frame)resource, (Slot)property, null, false);
        return this.owlModel.getOWLFrameStore().getConvertedValues(values);
    }

    public Collection getSlotValues(Instance instance, Slot slot) {
        return this.mnfs.getValues((Frame)instance, slot, null, false);
    }

    public TripleStore getTripleStore(String name) {
        if (name == null) {
            return this.ts.get(1);
        }
        for (TripleStore tripleStore : this.ts) {
            if (!name.equals(tripleStore.getName())) continue;
            return tripleStore;
        }
        return null;
    }

    public TripleStore getTripleStore(int index) {
        return (TripleStore)this.getTripleStores().get(index);
    }

    public List getTripleStores() {
        return new ArrayList<TripleStore>(this.ts);
    }

    public TripleStore getTopTripleStore() {
        if (this.mnfs == null && this.ts.size() == 1) {
            return this.ts.get(0);
        }
        return this.ts.get(1);
    }

    public boolean isActiveTriple(RDFResource subject, RDFProperty predicate, Object object) {
        return this.getActiveTripleStore().contains(subject, predicate, object);
    }

    public boolean isEditableTriple(RDFResource subject, RDFProperty predicate, Object object) {
        object = DefaultRDFSLiteral.getPlainValueIfPossible(object);
        Iterator it = this.listUserTripleStores();
        while (it.hasNext()) {
            TripleStore ts = (TripleStore)it.next();
            if (!ts.contains(subject, predicate, object)) continue;
            return this.isEditableTripleStore(ts);
        }
        return false;
    }

    public boolean isEditableTripleStore(TripleStore tripleStore) {
        int index = this.ts.indexOf(tripleStore);
        if (index == 0) {
            return false;
        }
        if (index == 1) {
            return true;
        }
        try {
            URI uri = new URI(tripleStore.getName());
            return this.owlModel.getRepositoryManager().getRepository(uri).isWritable(uri);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Iterator listTriplesWithSubject(RDFResource subject) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        for (TripleStore ts : this.getTripleStores()) {
            Iterator triples = ts.listTriplesWithSubject(subject);
            while (triples.hasNext()) {
                Triple triple = (Triple)triples.next();
                result.add(triple);
            }
        }
        return result.iterator();
    }

    public Iterator listUserTripleStores() {
        Iterator it = this.getTripleStores().iterator();
        it.next();
        return it;
    }

    public void replaceJavaObject(RDFResource subject) {
        this.mnfs.replaceFrame((Frame)subject);
    }

    public void setActiveTripleStore(TripleStore tripleStore) {
        if (this.mnfs.getActiveFrameStore() != tripleStore.getNarrowFrameStore()) {
            this.mnfs.setActiveFrameStore(tripleStore.getNarrowFrameStore());
        }
    }

    public void setHomeTripleStore(RDFResource resource, TripleStore tripleStore) {
        TripleStore home = this.getHomeTripleStore(resource);
        if (home != tripleStore) {
            List values = this.mnfs.getValues((Frame)resource, this.nameSlot, null, false);
            String name = (String)values.get(0);
            home.getNarrowFrameStore().removeValue((Frame)resource, this.nameSlot, null, false, (Object)name);
            tripleStore.getNarrowFrameStore().addValues((Frame)resource, this.nameSlot, null, false, (Collection)Collections.singleton(name));
        }
    }

    public void updateEditableResourceState() {
        Slot nameSlot = this.owlModel.getSlot(":NAME");
        TripleStoreUtil.updateFrameInclusion(this.mnfs, nameSlot);
    }
}

