/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactory;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTTPRepository
implements Repository {
    private static transient Logger log = Log.getLogger(HTTPRepository.class);
    private URL ontologyURL;
    private URI ontologyName;

    static {
        RepositoryFactory factory = RepositoryFactory.getInstance();
        factory.registerRepositoryFactoryPlugin(new HTTPRepositoryFactoryPlugin());
    }

    public HTTPRepository(URL ontologyURL) {
        this.ontologyURL = ontologyURL;
        this.ontologyName = null;
        this.update();
    }

    public String getRepositoryDescriptor() {
        return this.ontologyURL.toString();
    }

    public String getOntologyLocationDescription(URI ontologyName) {
        String s = "";
        if (this.ontologyName.equals(ontologyName)) {
            s = this.ontologyURL.toString();
        }
        return s;
    }

    private void update() {
        try {
            PrintStream oldErr = System.err;
            System.setErr(new PrintStream(new OutputStream(){

                public void write(int b) throws IOException {
                }
            }));
            InputStream is = ProtegeOWLParser.getInputStream(this.ontologyURL);
            OntologyNameExtractor extractor = new OntologyNameExtractor(is, this.ontologyURL);
            this.ontologyName = extractor.getOntologyName();
            System.setErr(oldErr);
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public boolean isSystem() {
        return false;
    }

    public URL getOntologyURL() {
        return this.ontologyURL;
    }

    public boolean contains(URI ontologyName) {
        if (this.ontologyName != null) {
            return this.ontologyName.equals(ontologyName);
        }
        return false;
    }

    public void refresh() {
        this.update();
    }

    public Collection getOntologies() {
        if (this.ontologyName != null) {
            return Collections.singleton(this.ontologyName);
        }
        return Collections.EMPTY_LIST;
    }

    public URL getLocation(URI ontologyName) {
        if (ontologyName == null) {
            return null;
        }
        if (ontologyName.equals(this.ontologyName)) {
            return this.ontologyURL;
        }
        return null;
    }

    public InputStream getInputStream(URI ontologyName) throws IOException {
        return ProtegeOWLParser.getInputStream(this.ontologyURL);
    }

    public boolean isWritable(URI ontologyName) {
        try {
            File file = new File(new URI(this.ontologyURL.toString()));
            return file.canWrite();
        }
        catch (Exception e) {
            Log.emptyCatchBlock((Throwable)e);
            return false;
        }
    }

    public OutputStream getOutputStream(URI ontologyName) throws IOException {
        FileOutputStream os = null;
        if (this.isWritable(ontologyName)) {
            try {
                File file = new File(new URI(this.ontologyURL.toString()));
                os = new FileOutputStream(file);
            }
            catch (URISyntaxException e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
        }
        return os;
    }

    public String getRepositoryDescription() {
        return "URL";
    }
}

