/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.parser;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLIncompleteRuleException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class SWRLParser {
    public static final char AND_CHAR = '\u2227';
    public static final char IMP_CHAR = '\u2192';
    private OWLModel owlModel;
    private SWRLFactory swrlFactory;
    private boolean parseOnly;
    private StringTokenizer tokenizer;
    private String delimiters = " ?\n\t()[],#\"\u2227\u2192";
    private Collection xmlSchemaSymbols = XMLSchemaDatatypes.getSlotSymbols();
    private HashSet variables;
    private boolean inHead = false;

    public SWRLParser(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.swrlFactory = new SWRLFactory(owlModel);
        this.parseOnly = true;
        this.variables = new HashSet();
    }

    public void setParseOnly(boolean parseOnly) {
        this.parseOnly = parseOnly;
    }

    public SWRLImp parse(String rule) throws SWRLParseException {
        return this.parse(rule, null);
    }

    public SWRLImp parse(String rule, SWRLImp imp) throws SWRLParseException {
        SWRLAtomList head = null;
        SWRLAtomList body = null;
        SWRLAtom atom = null;
        boolean atLeastOneAtom = false;
        boolean justProcessedAtom = false;
        this.inHead = false;
        this.variables.clear();
        this.tokenizer = new StringTokenizer(rule.trim(), this.delimiters, true);
        if (!this.parseOnly) {
            head = this.swrlFactory.createAtomList();
            body = this.swrlFactory.createAtomList();
        }
        if (!this.parseOnly && !this.tokenizer.hasMoreTokens()) {
            throw new SWRLParseException("Empty rule.");
        }
        do {
            String message = justProcessedAtom ? (this.inHead ? "Expecting '\u2227'" : "Expecting '\u2192' or '\u2227'") : (this.inHead ? "Expecting atom." : "Expecting atom or '\u2192'.");
            String token = this.getNextNonSpaceToken(message);
            if (token.equals("\u2192")) {
                if (this.inHead) {
                    throw new SWRLParseException("Second occurence of '\u2192'.");
                }
                this.inHead = true;
                justProcessedAtom = false;
                continue;
            }
            if (token.equals("-") || token.equals("->")) continue;
            if (token.equals("\u2227")) {
                if (!justProcessedAtom) {
                    throw new SWRLParseException("'\u2227' may occur only after an atom.");
                }
                justProcessedAtom = false;
                continue;
            }
            atom = this.parseAtom(token);
            atLeastOneAtom = true;
            if (!this.parseOnly) {
                if (this.inHead) {
                    head.append(atom);
                } else {
                    body.append(atom);
                }
            }
            justProcessedAtom = true;
        } while (this.tokenizer.hasMoreTokens());
        if (!this.parseOnly) {
            if (!atLeastOneAtom) {
                throw new SWRLParseException("Incomplete rule - no antecedent or consequent.");
            }
            if (imp == null) {
                imp = this.swrlFactory.createImp(head, body);
            } else {
                imp.setHead(head);
                imp.setBody(body);
            }
        } else {
            imp = null;
        }
        return imp;
    }

    private SWRLAtom parseAtom(String identifier) throws SWRLParseException {
        SWRLAtom atom = null;
        List enumeratedList = null;
        boolean isEnumeratedList = false;
        this.checkThatIdentifierIsValid(identifier);
        if (identifier.startsWith("[")) {
            enumeratedList = this.parseDObjectList();
            isEnumeratedList = true;
        }
        if (isEnumeratedList) {
            this.checkAndSkipToken("(", "Expecting parameters enclosed in parentheses for data range atom.");
        } else {
            this.checkAndSkipToken("(", "Expecting parameters enclosed in parentheses for atom '" + identifier + "'.");
        }
        if (isEnumeratedList) {
            atom = this.parseEnumeratedListParameters(enumeratedList);
        } else if (this.isSameAs(identifier)) {
            atom = this.parseSameAsAtomParameters();
        } else if (this.isDifferentFrom(identifier)) {
            atom = this.parseDifferentFromAtomParameters();
        } else if (this.isOWLClassName(identifier)) {
            atom = this.parseClassAtomParameters(identifier);
        } else if (this.isOWLObjectPropertyName(identifier)) {
            atom = this.parseIndividualPropertyAtomParameters(identifier);
        } else if (this.isOWLDatatypePropertyName(identifier)) {
            atom = this.parseDatavaluedPropertyAtomParameters(identifier);
        } else if (this.isBuiltinName(identifier)) {
            atom = this.parseBuiltinParameters(identifier);
        } else if (this.isXSDDatatype(identifier)) {
            atom = this.parseXSDDatatypeParameters(identifier);
        } else {
            throw new SWRLParseException("Invalid atom name '" + identifier + "'.");
        }
        return atom;
    }

    private void checkAndSkipToken(String skipToken, String unexpectedTokenMessage) throws SWRLParseException {
        String token = this.getNextNonSpaceToken(unexpectedTokenMessage);
        if (!token.equalsIgnoreCase(skipToken)) {
            throw new SWRLParseException("Expecting '" + skipToken + "', got '" + token + "'. " + unexpectedTokenMessage);
        }
    }

    private String getNextStringToken(String noTokenMessage) throws SWRLParseException {
        String token = "";
        String errorMessage = "Incomplete rule. " + noTokenMessage;
        if (!this.tokenizer.hasMoreTokens()) {
            if (this.parseOnly) {
                throw new SWRLIncompleteRuleException(errorMessage);
            }
            throw new SWRLParseException(errorMessage);
        }
        if (this.tokenizer.hasMoreTokens()) {
            token = this.tokenizer.nextToken("\"");
            return token;
        }
        if (this.parseOnly) {
            throw new SWRLIncompleteRuleException(errorMessage);
        }
        throw new SWRLParseException(errorMessage);
    }

    /*
     * Unable to fully structure code
     */
    private String getNextNonSpaceToken(String noTokenMessage) throws SWRLParseException {
        token = "";
        errorMessage = "Incomplete rule. " + noTokenMessage;
        if (this.tokenizer.hasMoreTokens()) ** GOTO lbl10
        if (this.parseOnly) {
            throw new SWRLIncompleteRuleException(errorMessage);
        }
        throw new SWRLParseException(errorMessage);
lbl-1000:
        // 1 sources

        {
            token = this.tokenizer.nextToken(this.delimiters);
            if (token.equals(" ") || token.equals("\n") || token.equals("\t")) continue;
            return token;
lbl10:
            // 2 sources

            ** while (this.tokenizer.hasMoreTokens())
        }
lbl11:
        // 1 sources

        if (this.parseOnly) {
            throw new SWRLIncompleteRuleException(errorMessage);
        }
        throw new SWRLParseException(errorMessage);
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasMoreNonSpaceTokens() {
        if (this.tokenizer.hasMoreTokens()) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            token = this.tokenizer.nextToken(this.delimiters);
            if (token.equals(" ") || token.equals("\n") || token.equals("\t")) continue;
            return true;
lbl6:
            // 2 sources

            ** while (this.tokenizer.hasMoreTokens())
        }
lbl7:
        // 1 sources

        return false;
    }

    private SWRLAtom parseSameAsAtomParameters() throws SWRLParseException {
        SWRLSameIndividualAtom atom = null;
        RDFResource iObject1 = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for SameAsAtom.");
        RDFResource iObject2 = this.parseIObject();
        if (!this.parseOnly) {
            atom = this.swrlFactory.createSameIndividualAtom(iObject1, iObject2);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameters in SameAsAtom");
        return atom;
    }

    private SWRLAtom parseDifferentFromAtomParameters() throws SWRLParseException {
        SWRLDifferentIndividualsAtom atom = null;
        RDFResource iObject1 = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameters for DifferentFromAtom");
        RDFResource iObject2 = this.parseIObject();
        if (!this.parseOnly) {
            atom = this.swrlFactory.createDifferentIndividualsAtom(iObject1, iObject2);
        }
        this.checkAndSkipToken(")", "Only two parameters allowed for DifferentFromAtom");
        return atom;
    }

    private SWRLAtom parseClassAtomParameters(String identifier) throws SWRLParseException {
        SWRLClassAtom atom = null;
        RDFResource iObject = this.parseIObject();
        if (!this.parseOnly) {
            OWLNamedClass aClass = this.owlModel.getOWLNamedClass(identifier);
            atom = this.swrlFactory.createClassAtom(aClass, iObject);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis for parameter for ClassAtom '" + identifier + "'.");
        return atom;
    }

    private SWRLAtom parseIndividualPropertyAtomParameters(String identifier) throws SWRLParseException {
        SWRLIndividualPropertyAtom atom = null;
        RDFResource iObject1 = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for IndividualPropertyAtom '" + identifier + "'");
        RDFResource iObject2 = this.parseIObject();
        if (!this.parseOnly) {
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty(identifier);
            if (objectProperty == null) {
                throw new SWRLParseException("no datatype slot found for IndividualPropertyAtom: " + identifier);
            }
            atom = this.swrlFactory.createIndividualPropertyAtom(objectProperty, iObject1, iObject2);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameter of IndividualPropertyAtom '" + identifier + "'.");
        return atom;
    }

    private SWRLAtom parseDatavaluedPropertyAtomParameters(String identifier) throws SWRLParseException {
        SWRLDatavaluedPropertyAtom atom = null;
        String errorMessage = "Expecting literal qualification symbol '#' or closing parenthesis after second parameter of DatavaluedPropertyAtom' ";
        RDFResource iObject = this.parseIObject();
        this.checkAndSkipToken(",", "Expecting comma-separated second parameter for DatavaluedPropertyAtom '" + identifier + "'.");
        RDFObject dObject = this.parseDObject();
        String token = this.getNextNonSpaceToken(String.valueOf(errorMessage) + identifier + "'.");
        if (token.equals("#")) {
            token = this.getNextNonSpaceToken("Expecting XML Schema datatype.");
            if (this.tokenizer.hasMoreTokens() && !this.isXSDDatatype(token)) {
                throw new SWRLParseException("Invalid XML Schema datatype name: '" + token + "'.");
            }
            if (!this.parseOnly) {
                dObject = this.owlModel.createRDFSLiteral(dObject.getBrowserText(), token);
            }
            this.checkAndSkipToken(")", "Expecting closing parenthesis after second parameter of DatavaluedPropertyAtom");
        } else if (!token.equals(")")) {
            throw new SWRLParseException(String.valueOf(errorMessage) + identifier + "'.");
        }
        if (!this.parseOnly) {
            OWLDatatypeProperty datatypeSlot = this.owlModel.getOWLDatatypeProperty(identifier);
            atom = this.swrlFactory.createDatavaluedPropertyAtom(datatypeSlot, iObject, dObject);
        }
        return atom;
    }

    private SWRLAtom parseBuiltinParameters(String identifier) throws SWRLParseException {
        SWRLBuiltinAtom atom = null;
        List objects = new ArrayList();
        objects = this.parseObjectList();
        if (!this.parseOnly) {
            SWRLBuiltin builtin = this.swrlFactory.getBuiltin(identifier);
            atom = this.swrlFactory.createBuiltinAtom(builtin, objects.iterator());
        }
        return atom;
    }

    private SWRLAtom parseXSDDatatypeParameters(String identifier) throws SWRLParseException {
        SWRLDataRangeAtom atom = null;
        RDFObject dObject = this.parseDObject();
        if (!this.parseOnly) {
            RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByName(identifier);
            atom = this.swrlFactory.createDataRangeAtom(datatype, dObject);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after DataRangeAtom '" + identifier + "'.");
        return atom;
    }

    private SWRLAtom parseEnumeratedListParameters(List enumeratedList) throws SWRLParseException {
        SWRLDataRangeAtom atom = null;
        RDFObject dObject = this.parseDObject();
        if (!this.parseOnly) {
            OWLDataRange dataRange = this.owlModel.createOWLDataRange();
            RDFProperty oneOfProperty = this.owlModel.getOWLOneOfProperty();
            for (Object literalValue : enumeratedList) {
                dataRange.addPropertyValue(oneOfProperty, literalValue);
            }
            atom = this.swrlFactory.createDataRangeAtom(dataRange, dObject);
        }
        this.checkAndSkipToken(")", "Expecting closing parenthesis after parameter in DataRangeAtom.");
        return atom;
    }

    private List parseDObjectList() throws SWRLParseException {
        ArrayList<RDFObject> dObjects = null;
        if (!this.parseOnly) {
            dObjects = new ArrayList<RDFObject>();
        }
        RDFObject dObject = this.parseDObject();
        if (!this.parseOnly) {
            dObjects.add(dObject);
        }
        String token = this.getNextNonSpaceToken("Expecting additional comma-separated variables or literals or closing parenthesis.");
        while (token.equals(",")) {
            dObject = this.parseDObject();
            if (!this.parseOnly) {
                dObjects.add(dObject);
            }
            if ((token = this.getNextNonSpaceToken("Expecting ',' or ')'.")).equals(",") || token.equals(")")) continue;
            throw new SWRLParseException("Expecting ',' or ')', got '" + token + "'.");
        }
        return dObjects;
    }

    private List parseObjectList() throws SWRLParseException {
        ArrayList<RDFObject> objects = null;
        if (!this.parseOnly) {
            objects = new ArrayList<RDFObject>();
        }
        RDFObject object = this.parseObject();
        if (!this.parseOnly) {
            objects.add(object);
        }
        String token = this.getNextNonSpaceToken("Expecting additional comma-separated variables, literals or individual names or closing parenthesis.");
        while (token.equals(",")) {
            object = this.parseObject();
            if (!this.parseOnly) {
                objects.add(object);
            }
            if ((token = this.getNextNonSpaceToken("Expecting ',' or ')'.")).equals(",") || token.equals(")")) continue;
            throw new SWRLParseException("Expecting ',' or ')', got '" + token + "'.");
        }
        return objects;
    }

    private RDFObject parseObject() throws SWRLParseException {
        RDFObject parsedEntity = null;
        String parsedString = this.getNextNonSpaceToken("Expecting variable or individual name or literal.");
        if (parsedString.equals("?")) {
            parsedEntity = this.parseVariable();
        } else if (this.isValidIndividualName(parsedString)) {
            if (!this.parseOnly) {
                parsedEntity = this.getIndividual(parsedString);
            }
        } else {
            parsedEntity = this.parseLiteral(parsedString);
        }
        return parsedEntity;
    }

    private RDFResource parseIObject() throws SWRLParseException {
        RDFResource parsedEntity = null;
        String parsedString = this.getNextNonSpaceToken("Expecting variable or individual name.");
        if (parsedString.equals("?")) {
            parsedEntity = this.parseVariable();
        } else {
            if (!this.isValidIndividualName(parsedString) && this.tokenizer.hasMoreTokens()) {
                throw new SWRLParseException("Invalid individual name: '" + parsedString + "'.");
            }
            if (!this.parseOnly) {
                parsedEntity = this.getIndividual(parsedString);
            }
        }
        return parsedEntity;
    }

    private RDFObject parseDObject() throws SWRLParseException {
        RDFObject parsedEntity = null;
        String parsedString = this.getNextNonSpaceToken("Expecting variable or literal.");
        parsedEntity = parsedString.equals("?") ? this.parseVariable() : this.parseLiteral(parsedString);
        return parsedEntity;
    }

    private RDFResource parseVariable() throws SWRLParseException {
        SWRLVariable parsedEntity = null;
        String variableName = this.getNextNonSpaceToken("Expected variable name");
        this.checkThatIdentifierIsValid(variableName);
        if (this.tokenizer.hasMoreTokens()) {
            if (!this.inHead) {
                this.variables.add(variableName);
            } else if (!this.variables.contains(variableName)) {
                throw new SWRLParseException("Variable '" + variableName + "' referred to in consequent not present in antecedent.");
            }
        }
        if (!this.parseOnly) {
            parsedEntity = this.getSWRLVariable(variableName);
        }
        return parsedEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RDFObject parseLiteral(String parsedString) throws SWRLParseException {
        RDFSLiteral parsedEntity = null;
        if (parsedString.equals("\"")) {
            String stringValue = this.getNextStringToken("Expected a string.");
            if (!this.parseOnly) {
                parsedEntity = this.owlModel.createRDFSLiteral(stringValue, this.owlModel.getXSDstring());
            }
        } else {
            if (parsedString.startsWith("t") || parsedString.startsWith("T") || parsedString.startsWith("f") || parsedString.startsWith("F")) {
                if (!this.tokenizer.hasMoreTokens()) return parsedEntity;
                if (!parsedString.equalsIgnoreCase("true")) {
                    if (!parsedString.equalsIgnoreCase("false")) throw new SWRLParseException("Invalid literal '" + parsedString + "'.");
                }
                if (this.parseOnly) return parsedEntity;
                return this.owlModel.createRDFSLiteral(parsedString, this.owlModel.getXSDboolean());
            }
            try {
                int integerValue = Integer.parseInt(parsedString);
                if (this.parseOnly) return parsedEntity;
                return this.owlModel.createRDFSLiteral(parsedString, this.owlModel.getXSDint());
            }
            catch (NumberFormatException e1) {
                try {
                    float floatValue = Float.parseFloat(parsedString);
                    if (this.parseOnly) return parsedEntity;
                    return this.owlModel.createRDFSLiteral(parsedString, this.owlModel.getXSDfloat());
                }
                catch (NumberFormatException e3) {
                    try {
                        double doubleValue = Double.parseDouble(parsedString);
                        if (this.parseOnly) return parsedEntity;
                        return this.owlModel.createRDFSLiteral(parsedString, this.owlModel.getXSDdouble());
                    }
                    catch (NumberFormatException e4) {
                        try {
                            long longValue = Long.parseLong(parsedString);
                            if (this.parseOnly) return parsedEntity;
                            return this.owlModel.createRDFSLiteral(parsedString, this.owlModel.getXSDlong());
                        }
                        catch (Exception e5) {
                            throw new SWRLParseException("Invalid literal '" + parsedString + "'.");
                        }
                    }
                }
            }
        }
        this.checkAndSkipToken("\"", "Expected \" to close string.");
        return parsedEntity;
    }

    private void checkThatVariableNameIsValid(String variableName) throws SWRLParseException {
        this.checkThatIdentifierIsValid(variableName);
        RDFResource resource = this.owlModel.getRDFResource(variableName);
        if (resource != null && !(resource instanceof SWRLVariable)) {
            throw new SWRLParseException("Invalid variable name: '" + variableName + "'. Cannot use name of existing OWL class, property, or individual.");
        }
    }

    private boolean isSameAs(String identifier) throws SWRLParseException {
        return identifier.equalsIgnoreCase("sameAs");
    }

    private boolean isDifferentFrom(String identifier) throws SWRLParseException {
        return identifier.equalsIgnoreCase("differentFrom");
    }

    private boolean isOWLClassName(String identifier) throws SWRLParseException {
        return this.owlModel.getRDFResource(identifier) instanceof RDFSNamedClass;
    }

    private boolean isOWLObjectPropertyName(String identifier) throws SWRLParseException {
        return this.owlModel.getRDFResource(identifier) instanceof OWLObjectProperty;
    }

    private boolean isOWLDatatypePropertyName(String identifier) throws SWRLParseException {
        return this.owlModel.getRDFResource(identifier) instanceof OWLDatatypeProperty;
    }

    private boolean isBuiltinName(String identifier) throws SWRLParseException {
        RDFResource resource = this.owlModel.getRDFResource(identifier);
        return resource != null && resource.getProtegeType().getName().equals("swrl:Builtin");
    }

    private boolean isXSDDatatype(String identifier) throws SWRLParseException {
        return identifier.startsWith("xsd:") && this.xmlSchemaSymbols.contains(identifier.substring(4));
    }

    private void checkThatIdentifierIsValid(String identifier) throws SWRLParseException {
        if (!this.isValidIdentifier(identifier)) {
            throw new SWRLParseException("Invalid identifier: '" + identifier + "'.");
        }
    }

    private boolean isValidIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != ':' && c != '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidIndividualName(String name) throws SWRLParseException {
        RDFResource resource = this.owlModel.getRDFResource(name);
        if (resource == null) {
            return false;
        }
        return resource instanceof OWLIndividual;
    }

    private RDFResource getIndividual(String name) throws SWRLParseException {
        RDFResource resource = this.owlModel.getRDFResource(name);
        if (resource == null) {
            throw new SWRLParseException("'" + name + "' is not a valid individual name");
        }
        if (resource instanceof SWRLVariable) {
            throw new SWRLParseException("'" + name + "' is the name of an OWL individual representing a SWRL variable - " + "it cannot be referenced directly in a SWRL rule");
        }
        return resource;
    }

    private SWRLVariable getSWRLVariable(String name) throws SWRLParseException {
        RDFResource resource = this.owlModel.getRDFResource(name);
        if (resource instanceof SWRLVariable) {
            return (SWRLVariable)resource;
        }
        if (resource == null) {
            return this.swrlFactory.createVariable(name);
        }
        throw new SWRLParseException(String.valueOf(name) + " cannot be used as a variable name");
    }
}

