/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.tab;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTablePanel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;

public class SWRLTab
extends AbstractTabWidget {
    private SWRLTablePanel panel;

    private void activateSWRL() {
        JenaOWLModel owlModel = (JenaOWLModel)this.getKnowledgeBase();
        try {
            owlModel.getNamespaceManager().setPrefix(new URI("http://www.w3.org/2003/11/swrl#"), "swrl");
            owlModel.getNamespaceManager().setPrefix(new URI("http://www.w3.org/2003/11/swrlb#"), "swrlb");
            ProtegeOWLParser.addImport(owlModel, new URI("http://www.w3.org/2003/11/swrl"));
            ProtegeOWLParser.addImport(owlModel, new URI("http://www.w3.org/2003/11/swrlb"));
            owlModel.getDefaultOWLOntology().addImports(new URI("http://www.w3.org/2003/11/swrl"));
            owlModel.getDefaultOWLOntology().addImports(new URI("http://www.w3.org/2003/11/swrlb"));
            this.activateSWRLFactoryIfNecessary(owlModel);
            System.out.println(owlModel.getNamespaceManager().getPrefixes());
            SWRLProjectPlugin.adjustWidgets(this.getProject());
            owlModel.getTripleStoreModel().updateEditableResourceState();
            ProtegeUI.reloadUI(this.getProject());
        }
        catch (Exception ex) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not activate SWRL support:\n" + ex + ".\nYour project might be in an inconsistent state now.");
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
    }

    public void initialize() {
        this.setLabel("SWRL Rules");
        this.setIcon(SWRLIcons.getImpsIcon());
        this.setLayout(new GridLayout(2, 1));
        if (!(this.getKnowledgeBase() instanceof OWLModel)) {
            this.add("Center", new JLabel("This tab can only be used with OWL projects."));
            return;
        }
        OWLModel owlModel = (OWLModel)this.getKnowledgeBase();
        if (!SWRLProjectPlugin.isSWRLImported(owlModel)) {
            if (this.isSWRLImported(owlModel)) {
                this.activateSWRLFactoryIfNecessary(owlModel);
            } else {
                this.setLayout(new FlowLayout());
                this.add(new JLabel("Your ontology needs to import the SWRL ontology (http://www.w3.org/2003/11/swrl#)."));
                JButton activateButton = new JButton("Activate SWRL...");
                activateButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SWRLTab.this.activateSWRL();
                    }
                });
                this.add(activateButton);
                if (!(owlModel instanceof JenaOWLModel)) {
                    activateButton.setEnabled(false);
                }
            }
        }
        if (SWRLProjectPlugin.isSWRLImported(owlModel)) {
            this.panel = new SWRLTablePanel(owlModel, null, this);
            this.add(this.panel);
        }
    }

    private void activateSWRLFactoryIfNecessary(OWLModel owlModel) {
        SWRLJavaFactory factory = new SWRLJavaFactory(owlModel);
        owlModel.setOWLJavaFactory(factory);
        if (owlModel instanceof JenaOWLModel) {
            OWLJavaFactoryUpdater.run((JenaOWLModel)owlModel);
        }
    }

    private boolean isSWRLImported(OWLModel owlModel) {
        boolean swrlFound = false;
        boolean swrlbFound = false;
        Iterator iter = owlModel.getOWLOntologies().iterator();
        try {
            while (!(!iter.hasNext() || swrlbFound && swrlFound)) {
                OWLOntology ont = (OWLOntology)iter.next();
                if (ont.getNamespace().equals("http://www.w3.org/2003/11/swrl#")) {
                    swrlFound = true;
                }
                if (!ont.getNamespace().equals("http://www.w3.org/2003/11/swrlb#")) continue;
                swrlbFound = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return swrlFound && swrlbFound;
    }

    public static boolean isSuitable(Project p, Collection errors) {
        if (p.getKnowledgeBase() instanceof OWLModel) {
            return true;
        }
        errors.add("This tab can only be used with OWL projects.");
        return false;
    }
}

