/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.style;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SubclassesRestrictionDuplicatesThatOfSuperTest
extends AbstractOWLTest
implements RDFSClassTest,
AutoRepairableOWLTest {
    private static String failedRest;

    public String getDocumentation() {
        return "Find classes that reimplement the same restriction as on a subclass";
    }

    public String getGroup() {
        return "Style";
    }

    public String getName() {
        return "Duplicate Restriction on Superclass";
    }

    public List test(RDFSClass aClass) {
        if (SubclassesRestrictionDuplicatesThatOfSuperTest.fails(aClass)) {
            return Collections.singletonList(new DefaultOWLTestResult("This class duplicates restrictions from parents (" + failedRest + ")", aClass, 2, this));
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean fails(RDFSClass aClass) {
        boolean result = false;
        failedRest = null;
        if (aClass instanceof OWLNamedClass) {
            Iterator i = SubclassesRestrictionDuplicatesThatOfSuperTest.getDuplicateRestrictions((OWLNamedClass)aClass);
            while (i.hasNext()) {
                result = true;
                failedRest = failedRest == null ? ((OWLRestriction)i.next()).getBrowserText() : String.valueOf(failedRest) + ", " + ((OWLRestriction)i.next()).getBrowserText();
            }
        }
        return result;
    }

    public boolean repair(OWLTestResult testResult) {
        boolean result = false;
        if (testResult.getHost() instanceof OWLNamedClass) {
            result = SubclassesRestrictionDuplicatesThatOfSuperTest.fix((OWLNamedClass)testResult.getHost());
        }
        return result;
    }

    public static boolean fix(OWLNamedClass namedClass) {
        boolean result = false;
        Iterator i = SubclassesRestrictionDuplicatesThatOfSuperTest.getDuplicateRestrictions(namedClass);
        while (i.hasNext()) {
            ((OWLRestriction)i.next()).delete();
            result = true;
        }
        return result;
    }

    private static Collection getAllInheritedRestrictions(OWLNamedClass aClass) {
        Iterator superclasses = aClass.getNamedSuperclasses(true).iterator();
        ArrayList restrs = new ArrayList();
        while (superclasses.hasNext()) {
            RDFSClass superclass = (RDFSClass)superclasses.next();
            if (!(superclass instanceof OWLNamedClass) || superclass.equals(aClass)) continue;
            restrs.addAll(((OWLNamedClass)superclass).getRestrictions());
        }
        return restrs;
    }

    private static Iterator getDuplicateRestrictions(OWLNamedClass namedClass) {
        Collection directRestrictions = namedClass.getRestrictions();
        Collection inheritedRestrictions = SubclassesRestrictionDuplicatesThatOfSuperTest.getAllInheritedRestrictions(namedClass);
        ArrayList<OWLRestriction> duplicateRestrictions = new ArrayList<OWLRestriction>();
        for (OWLRestriction directRestr : directRestrictions) {
            for (OWLRestriction inheritedRestr : inheritedRestrictions) {
                if (!directRestr.equalsStructurally(inheritedRestr)) continue;
                duplicateRestrictions.add(directRestr);
            }
        }
        return duplicateRestrictions.iterator();
    }
}

