/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.Deprecatable;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.manchester.ManchesterOWLParserUtil;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.Icon;

public class ResourceRenderer
extends FrameRenderer {
    private Frame focusedFrame;
    protected RDFSClass loadedClass;
    protected SimpleInstance loadedInstance;
    public static final Color FOCUS_COLOR = new Color(128, 0, 255);
    private Slot directSuperclassesSlot;
    private HashMap colorMap;
    private HashMap greyedColorMap;
    private static final Color RESTRICTION_KEYWORD_COLOR = Color.MAGENTA.darker();
    private static final Color GREYED_RESTRICTION_KEYWORD_COLOR = new Color(180, 100, 200);
    private static final Color LOGICAL_OPERAND_KEYWORD_COLOR = Color.CYAN.darker();
    private static final Color GREYED_LOGICAL_OPERAND_COLOR = new Color(120, 160, 245);
    private static final Color COMMENT_COLOR = Color.GRAY;

    public ResourceRenderer() {
        this(null);
    }

    public ResourceRenderer(Slot directSuperclassesSlot) {
        this.directSuperclassesSlot = directSuperclassesSlot;
        this.setDisplayHiddenIcon(false);
        this.colorMap = new HashMap();
        this.greyedColorMap = new HashMap();
        this.addKeyword(ManchesterOWLParserUtil.getMinKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getExactKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getMaxKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getSomeKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getAllKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getHasKeyword(), RESTRICTION_KEYWORD_COLOR, GREYED_RESTRICTION_KEYWORD_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getAndKeyword(), LOGICAL_OPERAND_KEYWORD_COLOR, GREYED_LOGICAL_OPERAND_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getOrKeyword(), LOGICAL_OPERAND_KEYWORD_COLOR, GREYED_LOGICAL_OPERAND_COLOR);
        this.addKeyword(ManchesterOWLParserUtil.getNotKeyword(), LOGICAL_OPERAND_KEYWORD_COLOR, GREYED_LOGICAL_OPERAND_COLOR);
    }

    protected void addKeyword(String keyWord, Color color, Color greyedColor) {
        this.colorMap.put(keyWord, color);
        this.colorMap.put(keyWord.toLowerCase(), color);
        this.colorMap.put(keyWord.toUpperCase(), color);
        this.greyedColorMap.put(keyWord, greyedColor);
        this.greyedColorMap.put(keyWord.toLowerCase(), greyedColor);
        this.greyedColorMap.put(keyWord.toUpperCase(), greyedColor);
    }

    public static void addAnnotationFlag(FrameRenderer renderer, Cls cls) {
        for (Slot slot : cls.getKnowledgeBase().getSlots()) {
            if (!(slot instanceof OWLProperty) || !((OWLProperty)slot).isAnnotationProperty() || cls.getDirectOwnSlotValues(slot).size() <= 0) continue;
            renderer.appendIcon((Icon)OWLIcons.getImageIcon("Annotations"));
            return;
        }
    }

    private void addInverseSlot(Slot slot) {
        Slot inverse = slot.getInverseSlot();
        if (inverse != null) {
            this.appendText(" \u2194 " + inverse.getBrowserText());
        }
    }

    private void addNamedEquivalentClses(OWLNamedClass cls) {
        for (Cls nextCls : cls.getDirectOwnSlotValues(this.directSuperclassesSlot)) {
            OWLNamedClass otherCls;
            if (!(nextCls instanceof OWLNamedClass) || !(otherCls = (OWLNamedClass)nextCls).getDirectOwnSlotValues(this.directSuperclassesSlot).contains(cls)) continue;
            this.appendText(" \u2261 " + otherCls.getBrowserText());
        }
    }

    protected Icon getClsIcon(Cls cls) {
        return cls.getIcon();
    }

    private Color getTextColor(String text) {
        Color c = null;
        c = !this._grayedText ? (Color)this.colorMap.get(text) : (Color)this.greyedColorMap.get(text);
        return c;
    }

    protected void paintString(Graphics graphics, String s, Point point, Color color, Dimension dimension) {
        if (this.loadedClass != null) {
            if (this.loadedClass instanceof OWLClass) {
                if (color != null) {
                    graphics.setColor(color);
                }
                int y = (dimension.height + this._fontMetrics.getAscent()) / 2 - 2;
                StringTokenizer tok = new StringTokenizer(s, " ()[]{}", true);
                while (tok.hasMoreTokens()) {
                    String curTok = tok.nextToken();
                    Color oldColor = graphics.getColor();
                    Font oldFont = graphics.getFont();
                    Color highlightColor = null;
                    int fontStyle = 0;
                    if (this.loadedClass instanceof OWLAnonymousClass) {
                        if (s.startsWith("//")) {
                            highlightColor = COMMENT_COLOR;
                            fontStyle = 2;
                        } else {
                            highlightColor = this.getTextColor(curTok);
                            fontStyle = 1;
                        }
                    }
                    if (highlightColor != null) {
                        graphics.setColor(highlightColor);
                        graphics.setFont(graphics.getFont().deriveFont(fontStyle));
                    } else {
                        RDFResource f;
                        OWLModel model = this.loadedClass.getOWLModel();
                        if (model instanceof JenaOWLModel && (f = model.getRDFResource(curTok)) instanceof OWLNamedClass && !((OWLNamedClass)f).isConsistent()) {
                            graphics.setColor(Color.RED);
                            graphics.setFont(graphics.getFont().deriveFont(1));
                        }
                    }
                    graphics.drawString(curTok, point.x, y);
                    point.x += graphics.getFontMetrics().stringWidth(curTok);
                    graphics.setColor(oldColor);
                    graphics.setFont(oldFont);
                }
            } else {
                super.paintString(graphics, s, point, color, dimension);
            }
        } else {
            if (this.loadedInstance != null) {
                OWLModel model = ((RDFResource)this.loadedInstance).getOWLModel();
                if (this.loadedInstance.getDirectType() == model.getOWLOntologyClass() && !((DefaultOWLOntology)this.loadedInstance).isAssociatedTriplestoreEditable()) {
                    color = Color.GRAY;
                    graphics.setFont(graphics.getFont().deriveFont(2));
                }
            }
            super.paintString(graphics, s, point, color, dimension);
        }
    }

    protected void loadCls(Cls cls) {
        this.setMainIcon(this.getClsIcon(cls));
        this.loadClsAfterIcon(cls);
    }

    public void load(Object o) {
        super.load(o);
        if (o instanceof RDFSClass) {
            this.loadedClass = (RDFSClass)o;
        } else if (o instanceof SimpleInstance) {
            this.loadedInstance = (SimpleInstance)o;
        }
    }

    protected void loadClsAfterIcon(Cls cls) {
        this.setMainText(cls.getBrowserText());
        this.appendText(this.getInstanceCountString(cls));
        this.setBackgroundSelectionColor(Colors.getClsSelectionColor());
        if (cls instanceof RDFSClass) {
            if (cls instanceof OWLAnonymousClass) {
                ResourceRenderer.addAnnotationFlag(this, cls);
            } else if (this.directSuperclassesSlot != null && cls instanceof OWLNamedClass) {
                this.addNamedEquivalentClses((OWLNamedClass)cls);
            }
            if (cls instanceof Deprecatable && ((Deprecatable)cls).isDeprecated()) {
                this.addIcon(OWLIcons.getDeprecatedIcon());
            }
            this.loadedClass = (RDFSClass)cls;
        } else {
            this.loadedClass = null;
        }
    }

    protected void loadSlot(Slot slot) {
        super.loadSlot(slot);
        this.addInverseSlot(slot);
        if (slot instanceof Deprecatable && ((Deprecatable)slot).isDeprecated()) {
            this.addIcon(OWLIcons.getDeprecatedIcon());
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.loadedClass != null && this.focusedFrame != null) {
            int ICON_TEXT_GAP = 3;
            int baseX = ICON_TEXT_GAP + this.getMainIcon().getIconWidth();
            String str = this.getMainText();
            int len = str.length();
            String browserText = this.focusedFrame.getBrowserText();
            int browserTextLen = browserText.length();
            int i = 0;
            while (i < len) {
                if (!(i != 0 && this.isOWLNameCharacter(str.charAt(i - 1)) || !str.regionMatches(i, browserText, 0, browserTextLen) || i + browserTextLen < len && this.isOWLNameCharacter(str.charAt(i + browserTextLen)))) {
                    g.setColor(FOCUS_COLOR);
                    int x = baseX + this._fontMetrics.stringWidth(str.substring(0, i));
                    int y = this.getHeight() - 1;
                    int width = this._fontMetrics.stringWidth(browserText);
                    g.drawRect(x - 1, 0, width + 2, y);
                    i += browserTextLen;
                }
                ++i;
            }
        }
    }

    private boolean isOWLNameCharacter(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    public void setFocusedFrame(Frame frame) {
        this.focusedFrame = frame;
    }
}

