/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions.triple;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.actions.triple.AbstractTripleAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Iterator;

public class DeleteTripleAction
extends AbstractTripleAction {
    public DeleteTripleAction() {
        super("Delete property value", "Delete", OWLIcons.class);
    }

    public boolean isSuitable(Triple triple) {
        return DeleteTripleAction.isSuitable(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public static boolean isSuitable(RDFResource subject, RDFProperty predicate, Object object) {
        if (!predicate.isReadOnly()) {
            RDFResource resource;
            if (object instanceof RDFResource && (resource = (RDFResource)object).isAnonymous()) {
                return false;
            }
            TripleStoreModel tsm = predicate.getOWLModel().getTripleStoreModel();
            if (tsm.isEditableTriple(subject, predicate, object)) {
                int count;
                return !(object instanceof RDFSNamedClass) || !predicate.equals(predicate.getOWLModel().getRDFSSubClassOfProperty()) && !predicate.equals(predicate.getOWLModel().getRDFTypeProperty()) || (count = DeleteTripleAction.getNamedClassValues(subject, predicate)) != 1;
            }
        }
        return false;
    }

    private static int getNamedClassValues(RDFResource subject, RDFProperty property) {
        int count = 0;
        Iterator it = subject.listPropertyValues(property);
        while (it.hasNext()) {
            if (!(it.next() instanceof RDFSNamedClass)) continue;
            ++count;
        }
        return count;
    }

    public void run(Triple triple) {
        triple.getSubject().removePropertyValue(triple.getPredicate(), triple.getObject());
    }
}

