/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchiesHost;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.cls.SecondaryHierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.InferredSubsumptionTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class HierarchiesPanel
extends JPanel
implements HierarchyManager {
    private List hierarchyPanels = new ArrayList();
    private HierarchiesHost host;

    public HierarchiesPanel(HierarchiesHost host) {
        this.host = host;
    }

    public void addHierarchy(Hierarchy hierarchy) {
        SecondaryHierarchyPanel panel = new SecondaryHierarchyPanel(hierarchy, this);
        if (hierarchy.isDefaultSynchronized()) {
            panel.startSynchronize();
        }
        this.addHierarchyPanel(panel);
    }

    public void addHierarchyPanel(final HierarchyPanel panel) {
        this.hierarchyPanels.add(panel);
        this.setLayout(new BorderLayout());
        HierarchyPanel defaultPanel = (HierarchyPanel)this.hierarchyPanels.get(0);
        int width = defaultPanel.getWidth();
        panel.setSize(width, defaultPanel.getHeight());
        this.refillPanels();
        this.host.hierarchiesChanged(this.getWidth() + width);
        panel.getHierarchy().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                Cls cls;
                Hierarchy hierarchy;
                Collection sels;
                if (panel.isSynchronized() && (sels = (hierarchy = panel.getHierarchy()).getSelection()).size() == 1 && (cls = (Cls)sels.iterator().next()) instanceof RDFSNamedClass) {
                    HierarchiesPanel.this.synchronizePanels((RDFSNamedClass)cls);
                }
            }
        });
    }

    public void addHierarchyWindow(Hierarchy panel) {
        HierarchyPanel defaultPanel = (HierarchyPanel)this.hierarchyPanels.get(0);
        int width = defaultPanel.getWidth();
        int height = defaultPanel.getHeight();
        final JFrame frame = ComponentFactory.createFrame();
        frame.setTitle(panel.getTitle());
        Container cp = frame.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add("Center", (Component)((Object)panel));
        frame.setBounds(10, 10, width, height);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ComponentUtilities.dispose((Component)frame);
            }
        });
    }

    public void close(Hierarchy hierarchy) {
        HierarchyPanel panel = this.getHierarchyPanel(hierarchy);
        this.hierarchyPanels.remove(panel);
        ComponentUtilities.dispose((Component)panel);
        int oldWidth = this.getWidth();
        this.refillPanels();
        this.host.hierarchiesChanged(oldWidth - panel.getWidth());
    }

    public void closeInferredHierarchies() {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            Hierarchy hierarchy = hierarchyPanel.getHierarchy();
            if (!(hierarchy instanceof InferredSubsumptionTreePanel)) continue;
            hierarchies.add(hierarchy);
        }
        for (Hierarchy hierarchy : hierarchies) {
            this.close(hierarchy);
        }
    }

    public void expandRootsOfInferredTrees() {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            Hierarchy hierarchy = hierarchyPanel.getHierarchy();
            if (!(hierarchy instanceof InferredSubsumptionTreePanel)) continue;
            ((InferredSubsumptionTreePanel)hierarchy).expandRoot();
        }
    }

    private HierarchyPanel getHierarchyPanel(Hierarchy hierarchy) {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            if (hierarchyPanel.getHierarchy() != hierarchy) continue;
            return hierarchyPanel;
        }
        return null;
    }

    private boolean inferredHierarchyExists() {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            if (!(hierarchyPanel.getHierarchy() instanceof InferredSubsumptionTreePanel)) continue;
            return true;
        }
        return false;
    }

    private void refillPanels() {
        this.removeAll();
        Component comp = this.refillPanels(this.hierarchyPanels.iterator());
        this.add("Center", comp);
        this.revalidate();
    }

    private Component refillPanels(Iterator it) {
        HierarchyPanel panel = (HierarchyPanel)it.next();
        if (it.hasNext()) {
            Component nextComponent = this.refillPanels(it);
            JSplitPane splitPane = new JSplitPane(1, panel, nextComponent);
            splitPane.setDividerLocation(panel.getWidth());
            splitPane.setOneTouchExpandable(true);
            return splitPane;
        }
        return panel;
    }

    public void showInferredHierarchy(OWLModel owlModel) {
        if (!this.inferredHierarchyExists()) {
            InferredSubsumptionTreePanel inferredTreePanel = new InferredSubsumptionTreePanel(owlModel);
            this.addHierarchy(inferredTreePanel);
            this.getTopLevelAncestor().validate();
        }
    }

    public void spawnHierarchy(Hierarchy hierarchy) {
        this.addHierarchyWindow(hierarchy);
    }

    private void synchronizePanels(RDFSNamedClass aClass) {
        for (HierarchyPanel hierarchyPanel : this.hierarchyPanels) {
            if (!hierarchyPanel.isSynchronized()) continue;
            hierarchyPanel.getHierarchy().setSelectedClass(aClass);
        }
    }
}

