/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OWLResourceNameMatcher
implements ResourceNameMatcher {
    public static final int SCALABLE_FRAME_COUNT = 1000;

    public String getInsertString(RDFResource resource) {
        return resource.getBrowserText();
    }

    public List getMatchingResources(String prefix, String leftString, OWLModel owlModel) {
        if (owlModel instanceof OWLDatabaseModel && prefix.length() < 3) {
            return Collections.EMPTY_LIST;
        }
        ArrayList frames = new ArrayList();
        OWLClassParseException ex = OWLClassParseException.getRecentInstance();
        if (ex.nextCouldBeClass || owlModel.getRDFResource(prefix) instanceof RDFSNamedClass) {
            OWLResourceNameMatcher.getMatchingRDFSNamedClasses(prefix, frames, owlModel);
        }
        if (ex.nextCouldBeIndividual || owlModel.getRDFResource(prefix) != null) {
            OWLResourceNameMatcher.getMatchingRDFIndividuals(prefix, frames, owlModel);
        }
        if (ex.nextCouldBeProperty || owlModel.getRDFResource(prefix) instanceof RDFProperty) {
            OWLResourceNameMatcher.getMatchingRDFProperties(prefix, frames, owlModel);
        }
        if (ex.nextCouldBeDatatypeName || owlModel.getRDFResource(prefix) instanceof RDFSDatatype) {
            OWLResourceNameMatcher.getMatchingDatatypeNames(prefix, frames, owlModel);
        }
        return frames;
    }

    public static void getMatchingRDFSNamedClasses(String prefix, List result, OWLModel owlModel) {
        block3: {
            block2: {
                if (prefix.length() != 0) break block2;
                int count = owlModel.getRDFSClassCount();
                if (count >= 1000) break block3;
                for (RDFSNamedClass aClass : OWLUtil.getSelectableNamedClses(owlModel)) {
                    if (!aClass.isVisibleFromOWLThing()) continue;
                    result.add(aClass);
                }
                break block3;
            }
            Collection matches = owlModel.getResourceNameMatches(String.valueOf(prefix) + "*", 1000);
            for (Frame frame : matches) {
                if (!(frame instanceof RDFSNamedClass) || !frame.isVisible() || !OWLResourceNameMatcher.isSlowProject(owlModel) && !((RDFSNamedClass)frame).isVisibleFromOWLThing()) continue;
                result.add(frame);
            }
        }
    }

    private static boolean isSlowProject(OWLModel owlModel) {
        return owlModel.getProject().isMultiUserClient();
    }

    public static void getMatchingRDFProperties(String prefix, List result, OWLModel owlModel) {
        Collection matches = owlModel.getResourceNameMatches(String.valueOf(prefix) + "*", 1000);
        for (Frame frame : matches) {
            if (!(frame instanceof RDFProperty) || !frame.isVisible()) continue;
            result.add(frame);
        }
    }

    public static void getMatchingRDFIndividuals(String prefix, List result, OWLModel owlModel) {
        Collection matches = owlModel.getResourceNameMatches(String.valueOf(prefix) + "*", 1000);
        for (Frame frame : matches) {
            if (!(frame instanceof RDFIndividual) || !frame.isVisible()) continue;
            result.add(frame);
        }
    }

    public static void getMatchingDatatypeNames(String prefix, List result, OWLModel owlModel) {
        Collection matches = owlModel.getRDFSDatatypes();
        for (RDFSDatatype datatype : matches) {
            if (datatype.isAnonymous() || !datatype.getBrowserText().startsWith(prefix)) continue;
            result.add(datatype);
        }
    }
}

