/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextFormatter;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public abstract class SymbolTextField
extends JTextField
implements KeyListener,
SymbolEditor {
    private SymbolEditorHandler editorHandler;
    private JComboBox comboBox;
    private SymbolErrorDisplay errorDisplay;
    private ResourceNameMatcher resourceNameMatcher;
    private OWLModel owlModel;
    private KeyEvent previousKeyPressed;
    public static final int SCALABLE_FRAME_COUNT = 1000;
    private SyntaxConverter syntaxConverter;
    private boolean inSaveTestMode = false;

    public SymbolTextField(OWLModel kb, SymbolErrorDisplay errorDisplay, ResourceNameMatcher resourceNameMatcher, SyntaxConverter syntaxConverter) {
        this.resourceNameMatcher = resourceNameMatcher;
        this.owlModel = kb;
        this.syntaxConverter = syntaxConverter;
        this.errorDisplay = errorDisplay;
        this.setBackground(Color.white);
        this.removeAll();
        this.addKeyListener(this);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (SymbolTextField.this.previousKeyPressed != null) {
                    int keyCode = SymbolTextField.this.previousKeyPressed.getKeyCode();
                    if (!SymbolTextField.isIdChar(SymbolTextField.this.previousKeyPressed.getKeyChar()) && keyCode != 8 && keyCode != 127) {
                        SymbolTextField.this.closeComboBox();
                    }
                }
            }
        });
    }

    private void acceptSelectedResource() {
        String text = this.getText();
        int pos = this.getCaretPosition();
        int i = pos - 1;
        while (i >= 0 && SymbolTextField.isIdChar(text.charAt(i))) {
            --i;
        }
        String prefix = text.substring(i + 1, pos);
        RDFResource resource = (RDFResource)this.comboBox.getSelectedItem();
        this.extendPartialName(prefix, this.resourceNameMatcher.getInsertString(resource));
        this.updateErrorDisplay();
        this.closeComboBox();
    }

    public void assignExpression() {
        this.handleEnter();
    }

    public void backspace() {
        String selText = this.getSelectedText();
        if (selText != null && selText.length() > 0) {
            int start = this.getSelectionStart();
            try {
                this.getDocument().remove(start, this.getSelectionEnd() - start);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
            this.setCaretPosition(start);
        } else {
            int pos = this.getCaretPosition();
            if (pos > 0) {
                try {
                    this.getDocument().remove(pos - 1, 1);
                }
                catch (BadLocationException ex) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                }
                this.setCaretPosition(pos - 1);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    public void cancelEditing() {
        this.handleEscape();
    }

    protected abstract void checkUniCodeExpression(String var1) throws Throwable;

    protected boolean isInSaveTestMode() {
        return this.inSaveTestMode;
    }

    private void closeComboBox() {
        this.removeAll();
    }

    public void displayError() {
        try {
            String uniCodeText = this.getText();
            this.checkUniCodeExpression(uniCodeText);
            this.errorDisplay.displayError((Throwable)null);
        }
        catch (Throwable ex) {
            this.errorDisplay.displayError(ex);
        }
        this.requestFocus();
    }

    private void extendPartialName(String prefix, String fullName) {
        try {
            this.getDocument().remove(this.getCaretPosition() - prefix.length(), prefix.length());
            this.getDocument().insertString(this.getCaretPosition(), fullName, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void extendPartialName(boolean autoInsert) {
        String text = this.getText();
        int pos = this.getCaretPosition();
        int i = pos - 1;
        while (i >= 0 && SymbolTextField.isIdChar(text.charAt(i))) {
            --i;
        }
        String prefix = text.substring(i + 1, pos);
        String leftString = text.substring(0, i + 1);
        List resources = this.resourceNameMatcher.getMatchingResources(prefix, leftString, this.owlModel);
        if (autoInsert && resources.size() == 1) {
            RDFResource resource = (RDFResource)resources.get(0);
            this.extendPartialName(prefix, this.resourceNameMatcher.getInsertString(resource));
            this.closeComboBox();
        } else if (resources.size() > 1) {
            this.showComboBox(resources, i + 1);
        }
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private int getXOfPosition(int pos) {
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        return metrics.stringWidth(this.getText().substring(0, pos));
    }

    private void handleDown() {
        int index;
        if (this.comboBox != null && this.comboBox.isVisible() && (index = this.comboBox.getSelectedIndex()) < this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(index + 1);
        }
    }

    protected void handleEnter() {
        if (this.isComboBoxVisible()) {
            this.acceptSelectedResource();
        } else {
            this.inSaveTestMode = true;
            try {
                String uniCodeText = this.getText();
                this.checkUniCodeExpression(uniCodeText);
                this.stopEditing();
            }
            catch (Throwable ex) {
                this.errorDisplay.displayError(ex);
                this.requestFocus();
            }
            this.inSaveTestMode = false;
        }
    }

    private void handleEscape() {
        if (this.isComboBoxVisible()) {
            this.closeComboBox();
        } else {
            this.editorHandler.cancelEditing();
        }
    }

    private void handleUp() {
        int index;
        if (this.isComboBoxVisible() && (index = this.comboBox.getSelectedIndex()) > 0) {
            this.comboBox.setSelectedIndex(index - 1);
        }
    }

    public void insertText(String text) {
        this.insertText(text, text.length());
    }

    public void insertText(String text, int caretOffset) {
        String selText = this.getSelectedText();
        if (selText != null && selText.length() > 0) {
            int start = this.getSelectionStart();
            try {
                this.getDocument().remove(start, this.getSelectionEnd() - start);
                this.getDocument().insertString(start, text, null);
                this.setCaretPosition(start + caretOffset);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        } else {
            try {
                int pos = this.getCaretPosition();
                this.getDocument().insertString(pos, text, null);
                this.setCaretPosition(pos + caretOffset);
            }
            catch (BadLocationException ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    private boolean isComboBoxVisible() {
        return this.comboBox != null && this.comboBox.isVisible() && this.comboBox.isShowing();
    }

    public static boolean isIdChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == ':' || ch == '-';
    }

    public void keyPressed(KeyEvent e) {
        this.updateErrorDisplay();
        this.previousKeyPressed = e;
        int code = e.getKeyCode();
        if (e.getKeyCode() == 9 || e.getKeyChar() == ' ' && (e.getModifiers() & 2) != 0) {
            this.extendPartialName(true);
            e.consume();
        } else {
            switch (code) {
                case 40: {
                    this.handleDown();
                    e.consume();
                    break;
                }
                case 38: {
                    this.handleUp();
                    e.consume();
                    break;
                }
                case 27: {
                    this.handleEscape();
                    e.consume();
                    break;
                }
                case 10: {
                    this.handleEnter();
                    e.consume();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        this.perhapsConvertSyntax(e);
        this.updateErrorDisplay();
        int code = e.getKeyCode();
        if (code != 40 && code != 38) {
            this.refreshComboBox();
        }
    }

    public void keyTyped(KeyEvent e) {
        this.perhapsConvertSyntax(e);
    }

    private void perhapsConvertSyntax(KeyEvent e) {
        if (this.syntaxConverter != null) {
            char ch = e.getKeyChar();
            int code = e.getKeyCode();
            if (!SymbolTextField.isIdChar(ch) && code != 8 && code != 127) {
                this.syntaxConverter.convertSyntax(this);
            }
        }
    }

    private void refreshComboBox() {
        if (this.isComboBoxVisible()) {
            String leftString;
            String text = this.getText();
            int pos = this.getCaretPosition();
            int i = pos - 1;
            while (i >= 0 && SymbolTextField.isIdChar(text.charAt(i))) {
                --i;
            }
            String prefix = text.substring(i + 1, pos);
            List frames = this.resourceNameMatcher.getMatchingResources(prefix, leftString = text.substring(0, i + 1), this.owlModel);
            if (frames.size() == 0) {
                this.closeComboBox();
            } else {
                this.showComboBox(frames, i + 1);
            }
        }
    }

    void replaceText(String text) {
        this.setText(text);
        this.updateErrorDisplay();
        this.requestFocus();
    }

    public void setSymbolEditorHandler(SymbolEditorHandler editorHandler) {
        this.editorHandler = editorHandler;
    }

    private void showComboBox(List frames, int startIndex) {
        this.closeComboBox();
        Frame[] fs = frames.toArray(new Frame[0]);
        Arrays.sort(fs, new ResourceIgnoreCaseComparator());
        this.comboBox = new JComboBox<Frame>(fs);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.setSize(this.comboBox.getPreferredSize().width + 20, 0);
        int x = this.getXOfPosition(startIndex) - 16;
        this.comboBox.setLocation(x, this.getHeight());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((long)e.getModifiers() & 0x10L) != 0L) {
                    SymbolTextField.this.acceptSelectedResource();
                }
            }
        });
        this.add(this.comboBox);
        this.comboBox.showPopup();
    }

    protected void stopEditing() {
        if (this.editorHandler != null) {
            this.editorHandler.stopEditing();
        }
    }

    private void updateErrorDisplay() {
        String uniCodeText = this.getText();
        try {
            this.checkUniCodeExpression(uniCodeText);
            this.errorDisplay.displayError((Throwable)null);
            this.setBackground(Color.white);
        }
        catch (Throwable ex) {
            this.errorDisplay.setErrorFlag(true);
            this.setBackground(new Color(240, 240, 240));
        }
    }

    protected void updateSyntax() {
        OWLTextFormatter.updateSyntax(this, this.owlModel);
    }
}

