/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.datarangefield;

import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class DataRangeFieldComponent
extends AbstractPropertyValuesComponent {
    private JComboBox comboBox;
    private Action deleteAction = new AbstractAction("Delete value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent e) {
            DataRangeFieldComponent.this.handleDeleteAction();
        }
    };

    public DataRangeFieldComponent(RDFProperty predicate) {
        super(predicate);
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataRangeFieldComponent.this.assignComboBoxValue();
            }
        });
        String label = this.getLabel();
        OWLLabeledComponent lc = new OWLLabeledComponent(label, this.comboBox);
        lc.addHeaderButton(this.deleteAction);
        this.add("Center", (Component)((Object)lc));
    }

    private void assignComboBoxValue() {
        Object value = this.comboBox.getSelectedItem();
        this.getSubject().setPropertyValue(this.getPredicate(), value);
    }

    private OWLDataRange getDataRange() {
        RDFResource range;
        RDFProperty predicate = this.getPredicate();
        OWLDataRange dataRange = null;
        for (RDFSNamedClass type : this.getSubject().getRDFTypes()) {
            if (!(type instanceof OWLNamedClass)) continue;
            OWLNamedClass namedClass = (OWLNamedClass)type;
            RDFResource allValuesFrom = namedClass.getAllValuesFrom(predicate);
            if (allValuesFrom instanceof OWLDataRange) {
                dataRange = (OWLDataRange)allValuesFrom;
                break;
            }
            RDFResource someValuesFrom = namedClass.getSomeValuesFrom(predicate);
            if (!(someValuesFrom instanceof OWLDataRange)) continue;
            dataRange = (OWLDataRange)someValuesFrom;
            break;
        }
        if (dataRange == null && (range = predicate.getRange(true)) instanceof OWLDataRange) {
            dataRange = (OWLDataRange)range;
        }
        return dataRange;
    }

    private Collection getDataRangeValues() {
        OWLDataRange dataRange;
        if (this.getSubject() != null && (dataRange = this.getDataRange()) != null) {
            return dataRange.getOneOfValueLiterals();
        }
        return Collections.EMPTY_LIST;
    }

    private void handleDeleteAction() {
        this.getSubject().setPropertyValue(this.getPredicate(), null);
    }

    public void setSubject(RDFResource subject) {
        super.setSubject(subject);
        this.updateActionState();
        Collection values = this.getDataRangeValues();
        Object[] items = values.toArray();
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(items));
        this.updateComboBoxState();
    }

    private void updateActionState() {
        this.deleteAction.setEnabled(this.getSubject() != null && this.getSubject().getPropertyValue(this.getPredicate()) != null && this.hasOnlyEditableValues());
    }

    private void updateComboBoxState() {
        this.comboBox.setEnabled(this.getSubject() != null && this.hasOnlyEditableValues());
    }

    public void valuesChanged() {
        Object value = this.getObject();
        if (value != null && !(value instanceof RDFSLiteral) && !(value instanceof RDFResource)) {
            value = this.getOWLModel().createRDFSLiteral(value);
        }
        this.comboBox.setSelectedItem(value);
        this.updateActionState();
        this.updateComboBoxState();
    }
}

