/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.literaltable.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.components.literaltable.LiteralTableModel;

public class LiteralTableModelTestCase
extends AbstractJenaTestCase {
    public void testHasValueRestriction() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        String hasValue = "Test";
        cls.addSuperclass(this.owlModel.createOWLHasValue(property, "Test"));
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        LiteralTableModel tableModel = new LiteralTableModel(property);
        tableModel.setSubject(individual);
        LiteralTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        LiteralTableModelTestCase.assertFalse((boolean)tableModel.isCellEditable(0, 0));
        LiteralTableModelTestCase.assertFalse((boolean)tableModel.isCellEditable(0, 1));
    }

    public void testRangelessProperty() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        LiteralTableModel tableModel = new LiteralTableModel(property);
        tableModel.setSubject(individual);
        LiteralTableModelTestCase.assertEquals((int)0, (int)tableModel.getRowCount());
        LiteralTableModelTestCase.assertEquals((int)2, (int)tableModel.getColumnCount());
        LiteralTableModelTestCase.assertFalse((boolean)tableModel.isStringProperty());
        LiteralTableModelTestCase.assertEquals(RDFSDatatype.class, (Object)tableModel.getColumnClass(1));
    }

    public void testResourceValues() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFResource resource = cls.createInstance("Instance");
        resource.setPropertyValue(property, this.owlThing);
        LiteralTableModel tableModel = new LiteralTableModel(property);
        tableModel.setSubject(resource);
        tableModel.updateValues();
        LiteralTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        LiteralTableModelTestCase.assertEquals((Object)this.owlThing, (Object)tableModel.getObject(0));
    }

    public void testStringProperty() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDstring()));
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        LiteralTableModel tableModel = new LiteralTableModel(property);
        tableModel.setSubject(individual);
        LiteralTableModelTestCase.assertEquals((int)0, (int)tableModel.getRowCount());
        LiteralTableModelTestCase.assertEquals((int)2, (int)tableModel.getColumnCount());
        LiteralTableModelTestCase.assertTrue((boolean)tableModel.isStringProperty());
        LiteralTableModelTestCase.assertEquals(String.class, (Object)tableModel.getColumnClass(1));
        individual.addPropertyValue(property, this.owlModel.createRDFSLiteral("Value", "Lang"));
        tableModel.updateValues();
        LiteralTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        LiteralTableModelTestCase.assertEquals((Object)"Value", (Object)tableModel.getValueAt(0, 0));
        LiteralTableModelTestCase.assertEquals((Object)"Lang", (Object)tableModel.getValueAt(0, 1));
        LiteralTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(0, 1));
    }

    public void testSubPropertyValues() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty superproperty = this.owlModel.createOWLDatatypeProperty("hasPrice");
        OWLDatatypeProperty subproperty = this.owlModel.createOWLDatatypeProperty("hasSpecialPrice");
        subproperty.addSuperproperty(superproperty);
        OWLIndividual subject = cls.createOWLIndividual("Individual");
        RDFSLiteral value = this.owlModel.createRDFSLiteral("42", this.owlModel.getXSDint());
        subject.addPropertyValue(subproperty, value);
        LiteralTableModel tableModel = new LiteralTableModel(superproperty);
        tableModel.setSubject(subject);
        LiteralTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        LiteralTableModelTestCase.assertEquals((Object)value, (Object)tableModel.getObject(0));
        LiteralTableModelTestCase.assertFalse((boolean)tableModel.isCellEditable(0, 0));
        LiteralTableModelTestCase.assertFalse((boolean)tableModel.isCellEditable(0, 1));
    }

    public void testRDFPropertyWithXSDIntRange() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFIndividual subject = cls.createRDFIndividual("Individual");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setRange(this.owlModel.getXSDint());
        property.setDomain(cls);
        subject.addPropertyValue(property, new Integer(42));
        LiteralTableModel tableModel = new LiteralTableModel(property);
        tableModel.setSubject(subject);
        LiteralTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        LiteralTableModelTestCase.assertTrue((boolean)tableModel.isCellEditable(0, 0));
        LiteralTableModelTestCase.assertTrue((boolean)tableModel.isDeleteEnabled(new int[1]));
    }
}

