/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class ConditionsTableItem
implements ConditionsTableConstants,
Comparable {
    RDFSClass aClass;
    private OWLIntersectionClass definition;
    private boolean isNew;
    private int localIndex;
    private OWLNamedClass originCls;
    private int type;
    public static final String INHERITED = "INHERITED ";
    public static final String NECESSARY = "NECESSARY ";
    public static final String SUFFICIENT = "NECESSARY & SUFFICIENT ";

    private ConditionsTableItem(RDFSClass aClass, int type, OWLNamedClass originCls, OWLIntersectionClass definition, boolean isNew) {
        this.aClass = aClass;
        this.definition = definition;
        this.type = type;
        this.originCls = originCls;
        this.isNew = isNew;
    }

    public int compareTo(Object o) {
        if (o instanceof ConditionsTableItem) {
            ConditionsTableItem other = (ConditionsTableItem)o;
            if (this.type > other.type) {
                return -1;
            }
            if (this.type < other.type) {
                return 1;
            }
            if (other.isSeparator()) {
                return 1;
            }
            if (this.isSeparator()) {
                return -1;
            }
            return this.compareToWithSameType(other.aClass);
        }
        return 0;
    }

    int compareToWithSameType(RDFSClass otherClass) {
        if (this.aClass instanceof OWLNamedClass) {
            if (otherClass instanceof OWLNamedClass) {
                return this.aClass.compareTo(otherClass);
            }
            return -1;
        }
        if (otherClass instanceof OWLNamedClass) {
            return 1;
        }
        return this.compareToWithAnonymousClses((OWLAnonymousClass)otherClass);
    }

    private int compareToWithAnonymousClses(OWLAnonymousClass otherCls) {
        if (this.aClass instanceof OWLRestriction) {
            if (otherCls instanceof OWLRestriction) {
                return this.compareToWithRestrictions((OWLRestriction)otherCls);
            }
            return 1;
        }
        return this.aClass.compareTo(otherCls);
    }

    private int compareToWithRestrictions(OWLRestriction otherCls) {
        RDFProperty otherProperty;
        OWLRestriction restriction = (OWLRestriction)this.aClass;
        RDFProperty property = restriction.getOnProperty();
        if (property.equals(otherProperty = otherCls.getOnProperty())) {
            OWLModel owlModel = this.aClass.getOWLModel();
            List<RDFSNamedClass> metaClses = Arrays.asList(owlModel.getOWLRestrictionMetaclasses());
            int clsIndex = metaClses.indexOf(restriction.getProtegeType());
            int otherIndex = metaClses.indexOf(otherCls.getProtegeType());
            return new Integer(clsIndex).compareTo(new Integer(otherIndex));
        }
        return property.compareTo(otherProperty);
    }

    static ConditionsTableItem create(RDFSClass aClass, int type) {
        return new ConditionsTableItem(aClass, type, null, null, false);
    }

    static ConditionsTableItem createInherited(RDFSClass aClass, OWLNamedClass originCls) {
        return new ConditionsTableItem(aClass, -2, originCls, null, false);
    }

    static ConditionsTableItem createNew(int type) {
        return new ConditionsTableItem(null, type, null, null, true);
    }

    static ConditionsTableItem createSufficient(RDFSClass aClass, int type, OWLIntersectionClass definition) {
        return new ConditionsTableItem(aClass, type, null, definition, false);
    }

    static ConditionsTableItem createSeparator(int type) {
        return new ConditionsTableItem(null, type, null, null, false);
    }

    RDFSClass getCls() {
        return this.aClass;
    }

    OWLIntersectionClass getDefinition() {
        return this.definition;
    }

    Icon getIcon(int rowHeight) {
        if (this.isSeparator()) {
            return null;
        }
        if (this.isDefinition()) {
            return null;
        }
        if (this.type == -2) {
            return OWLIcons.getImageIcon("SuperclassInherited");
        }
        if (this.type == -1) {
            return ConditionsTableItem.getSuperclassIcon();
        }
        return null;
    }

    OWLNamedClass getOriginCls() {
        return this.originCls;
    }

    static Icon getSuperclassIcon() {
        return OWLIcons.getImageIcon("Superclass");
    }

    int getType() {
        return this.type;
    }

    boolean isDefinition() {
        return this.type >= 0;
    }

    boolean isInherited() {
        return this.type == -2;
    }

    boolean isNew() {
        return this.isNew;
    }

    boolean isSeparator() {
        return this.aClass == null && !this.isNew();
    }

    void setLocalIndex(int value) {
        this.localIndex = value;
    }

    void setType(int value) {
        this.type = value;
    }

    public String toString() {
        if (this.isSeparator()) {
            if (this.isDefinition()) {
                return SUFFICIENT;
            }
            if (this.isInherited()) {
                return INHERITED;
            }
            return NECESSARY;
        }
        if (this.isInherited()) {
            return String.valueOf(this.getDisplayText()) + "    [" + this.originCls.getBrowserText() + "]";
        }
        if (this.isNew()) {
            return "";
        }
        return this.getDisplayText();
    }

    private String getDisplayText() {
        return this.aClass.getBrowserText();
    }
}

