/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.SelectClsesPanel;
import edu.stanford.smi.protege.ui.SelectInstanceFromCollectionPanel;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.AbstractSelectionDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectClassPanel;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectResourcesFromCollectionPanel;
import edu.stanford.smi.protegex.owl.ui.dialogs.SelectResourcesPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultSelectionDialogFactory
extends AbstractSelectionDialogFactory {
    private static Collection getFirstTwoClasses(OWLModel owlModel, Collection allowedClasses) {
        HashSet concreteClasses = new HashSet();
        if (allowedClasses.isEmpty()) {
            allowedClasses = Collections.singleton(owlModel.getOWLThingClass());
        }
        DefaultSelectionDialogFactory.getFirstTwoClasses(allowedClasses, concreteClasses);
        return concreteClasses;
    }

    private static void getFirstTwoClasses(Collection allowedClasses, Collection classes) {
        Iterator i = allowedClasses.iterator();
        while (i.hasNext() && classes.size() != 2) {
            Cls cls = (Cls)i.next();
            classes.add(cls);
            if (classes.size() == 2) break;
            DefaultSelectionDialogFactory.getFirstTwoClasses(cls.getDirectSubclasses(), classes);
        }
    }

    private static boolean hasOneClass(Collection rootClses) {
        Cls cls;
        boolean hasOneClass = rootClses.size() == 1 ? (cls = (Cls)CollectionUtilities.getFirstItem((Collection)rootClses)).getDirectSubclassCount() == 0 : false;
        return hasOneClass;
    }

    private static Collection pickClasses(Component component, OWLModel owlModel, Collection rootClses, String label, boolean multiple) {
        Collection clses;
        boolean editable = true;
        if (rootClses.isEmpty()) {
            clses = Collections.EMPTY_LIST;
        } else if (DefaultSelectionDialogFactory.hasOneClass(rootClses)) {
            clses = rootClses;
        } else {
            SelectClassPanel panel = new SelectClassPanel(owlModel, rootClses, multiple, editable);
            int result = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)((Object)panel), label, 11);
            clses = result == 1 ? panel.getSelection() : Collections.EMPTY_LIST;
        }
        return clses;
    }

    private static Cls pickClass(Component component, OWLModel owlModel, Collection allowedClasses, String label) {
        Cls cls;
        Collection concreteClses = DefaultSelectionDialogFactory.getFirstTwoClasses(owlModel, allowedClasses);
        switch (concreteClses.size()) {
            case 0: {
                ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "There are no allowed classes");
                cls = null;
                break;
            }
            case 1: {
                cls = (Cls)CollectionUtilities.getFirstItem((Collection)concreteClses);
                break;
            }
            case 2: {
                cls = DefaultSelectionDialogFactory.promptForClass(component, owlModel, allowedClasses, label);
                break;
            }
            default: {
                Assert.fail((String)("bad size: " + concreteClses.size()));
                cls = null;
            }
        }
        return cls;
    }

    private static Instance pickInstanceFromCollection(Component component, Collection collection, int initialSelection, String label) {
        Instance instance = null;
        if (collection != null && collection.size() > 0) {
            Collection modifiedVis = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(collection, true);
            SelectInstanceFromCollectionPanel panel = new SelectInstanceFromCollectionPanel(collection, initialSelection);
            int result = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)panel, label, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(modifiedVis, false);
            if (result == 1) {
                instance = panel.getSelection();
            }
        }
        return instance;
    }

    private static Collection pickInstancesFromCollection(Component component, Collection instances, String label) {
        List selectedSlots = Collections.EMPTY_LIST;
        if (instances != null && instances.size() > 0) {
            Collection modifiedVis = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(instances, true);
            SelectResourcesFromCollectionPanel panel = new SelectResourcesFromCollectionPanel(instances);
            int result = ProtegeUI.getModalDialogFactory().showDialog(component, panel, label, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(modifiedVis, false);
            switch (result) {
                case 1: {
                    return panel.getSelection();
                }
                case 4: {
                    break;
                }
                default: {
                    Assert.fail((String)("bad result: " + result));
                }
            }
        }
        return selectedSlots;
    }

    private static RDFSNamedClass promptForClass(final Component component, OWLModel owlModel, Collection clses, final String label) {
        Object first;
        final SelectClsesPanel p = new SelectClsesPanel((KnowledgeBase)owlModel, clses);
        ModalDialogFactory.CloseCallback callback = new ModalDialogFactory.CloseCallback(){

            public boolean canClose(int result) {
                boolean canClose;
                if (result == 1) {
                    Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)p.getSelection());
                    boolean bl = canClose = cls != null;
                    if (!canClose) {
                        ProtegeUI.getModalDialogFactory().showMessageDialog(component, label, "Information");
                    }
                } else {
                    canClose = true;
                }
                return canClose;
            }
        };
        int result = ProtegeUI.getModalDialogFactory().showDialog(component, (Component)p, label, 11, callback);
        if (result == 1 && (first = CollectionUtilities.getFirstItem((Collection)p.getSelection())) instanceof RDFSNamedClass) {
            return (RDFSNamedClass)first;
        }
        return null;
    }

    public RDFSNamedClass selectClass(Component parent, OWLModel owlModel, Collection rootClasses, String title) {
        Cls cls;
        if (parent == null) {
            parent = ProtegeUI.getProjectView(owlModel.getProject());
        }
        if ((cls = DefaultSelectionDialogFactory.pickClass(parent, owlModel, rootClasses, title)) instanceof RDFSNamedClass) {
            return (RDFSNamedClass)cls;
        }
        return null;
    }

    public Set selectClasses(Component parent, OWLModel owlModel, Collection rootClasses, String title) {
        if (parent == null) {
            parent = ProtegeUI.getProjectView(owlModel.getProject());
        }
        return new HashSet(DefaultSelectionDialogFactory.pickClasses(parent, owlModel, rootClasses, title, true));
    }

    public RDFProperty selectProperty(Component parent, OWLModel owlModel, Collection allowedProperties, String title) {
        if (parent == null) {
            parent = ProtegeUI.getProjectView(owlModel.getProject());
        }
        return (RDFProperty)DefaultSelectionDialogFactory.pickInstanceFromCollection(parent, allowedProperties, allowedProperties.isEmpty() ? -1 : 0, title);
    }

    public RDFResource selectResourceFromCollection(Component parent, OWLModel owlModel, Collection resources, String title) {
        if (parent == null) {
            parent = ProtegeUI.getTopLevelContainer(owlModel.getProject());
        }
        return (RDFResource)DefaultSelectionDialogFactory.pickInstanceFromCollection(parent, resources, resources.isEmpty() ? -1 : 0, title);
    }

    public RDFResource selectResourceByType(Component parent, OWLModel owlModel, Collection allowedClasses, String title) {
        if (!allowedClasses.isEmpty()) {
            if (parent == null) {
                parent = ProtegeUI.getTopLevelContainer(owlModel.getProject());
            }
            Collection modifiedVis = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(allowedClasses, true);
            SelectResourcesPanel panel = new SelectResourcesPanel(owlModel, allowedClasses, true);
            int result = ProtegeUI.getModalDialogFactory().showDialog(parent, (Component)((Object)panel), title, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(modifiedVis, false);
            if (result == 1) {
                Collection instances = panel.getSelection();
                for (Instance instance : instances) {
                    if (!(instance instanceof RDFResource)) continue;
                    return (RDFResource)instance;
                }
            }
        }
        return null;
    }

    public Set selectResourcesByType(Component parent, OWLModel owlModel, Collection allowedClasses, String title) {
        if (!allowedClasses.isEmpty()) {
            Collection modifiedVis = DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(allowedClasses, true);
            if (parent == null) {
                parent = ProtegeUI.getTopLevelContainer(owlModel.getProject());
            }
            SelectResourcesPanel panel = new SelectResourcesPanel(owlModel, allowedClasses, true);
            int result = ProtegeUI.getModalDialogFactory().showDialog(parent, (Component)((Object)panel), title, 11);
            DefaultSelectionDialogFactory.ensureResourcesHaveVisibility(modifiedVis, false);
            if (result == 1) {
                Collection instances = panel.getSelection();
                HashSet<Instance> set = new HashSet<Instance>();
                for (Instance instance : instances) {
                    if (!(instance instanceof RDFResource)) continue;
                    set.add(instance);
                }
                return set;
            }
        }
        return Collections.EMPTY_SET;
    }

    public Set selectResourcesFromCollection(Component parent, OWLModel owlModel, Collection resources, String title) {
        if (parent == null) {
            parent = ProtegeUI.getTopLevelContainer(owlModel.getProject());
        }
        return new HashSet(DefaultSelectionDialogFactory.pickInstancesFromCollection(parent, resources, title));
    }

    public static Collection ensureResourcesHaveVisibility(Collection allowedResources, boolean visible) {
        ArrayList<Instance> modifiedVis = new ArrayList<Instance>();
        for (Instance curClass : allowedResources) {
            if (curClass.isVisible() == visible) continue;
            curClass.setVisible(visible);
            modifiedVis.add(curClass);
        }
        return modifiedVis;
    }
}

