/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.AssertedInstancesListDragSourceListener;
import edu.stanford.smi.protegex.owl.ui.individuals.AssertedInstancesListPanel;
import edu.stanford.smi.protegex.owl.ui.individuals.AssertedTypesListPanel;
import edu.stanford.smi.protegex.owl.ui.individuals.IndividualsClassesTreeTarget;
import edu.stanford.smi.protegex.owl.ui.individuals.IndividualsTabClassesPanel;
import edu.stanford.smi.protegex.owl.ui.individuals.InferredInstancesListPanel;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreeCellRenderer;

public class OWLIndividualsTab
extends AbstractTabWidget
implements NavigationHistoryTabWidget {
    private AssertedInstancesListPanel assertedInstancesListPanel;
    private IndividualsTabClassesPanel classesPanel;
    private InferredInstancesListPanel inferredInstancesListPanel;
    private ResourcePanel resourcePanel;
    private AssertedTypesListPanel typesListPanel;

    private void adjustInstancesDisplayPanel() {
        Component lc = null;
        int i = 0;
        while (i < this.assertedInstancesListPanel.getComponentCount()) {
            if (this.assertedInstancesListPanel.getComponent(i) instanceof LabeledComponent) {
                lc = this.assertedInstancesListPanel.getComponent(i);
            }
            ++i;
        }
        assert (lc != null);
        Container parent = lc.getParent();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Asserted", lc);
        tabbedPane.addTab("Inferred", (Component)((Object)this.inferredInstancesListPanel));
        tabbedPane.setBorder(null);
        parent.add("Center", tabbedPane);
    }

    protected AssertedInstancesListPanel createAssertedInstancesListPanel() {
        AssertedInstancesListPanel result = new AssertedInstancesListPanel(this.getOWLModel());
        result.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                Collection selection = OWLIndividualsTab.this.assertedInstancesListPanel.getSelection();
                Instance selectedInstance = selection.size() == 1 ? (Instance)CollectionUtilities.getFirstItem((Collection)selection) : null;
                if (selectedInstance == null || selectedInstance instanceof RDFResource) {
                    RDFResource resource = (RDFResource)selectedInstance;
                    OWLIndividualsTab.this.resourcePanel.setResource(resource);
                    OWLIndividualsTab.this.typesListPanel.setResource(resource);
                } else if (OWLIndividualsTab.this.resourcePanel instanceof ResourceDisplay) {
                    ((ResourceDisplay)OWLIndividualsTab.this.resourcePanel).setInstance(selectedInstance);
                    OWLIndividualsTab.this.typesListPanel.setResource(null);
                }
            }
        });
        this.setInstanceSelectable((Selectable)result.getDragComponent());
        final JList list = (JList)result.getDragComponent();
        list.addMouseListener((MouseListener)new PopupMenuMouseListener(list){

            protected JPopupMenu getPopupMenu() {
                Instance instance = (Instance)list.getSelectedValue();
                if (instance instanceof RDFResource) {
                    JPopupMenu menu = new JPopupMenu();
                    ResourceActionManager.addResourceActions(menu, (Component)list, (RDFResource)instance);
                    if (menu.getComponentCount() > 0) {
                        return menu;
                    }
                }
                return null;
            }

            protected void setSelection(JComponent c, int x, int y) {
                int i = 0;
                while (i < list.getModel().getSize()) {
                    if (list.getCellBounds(i, i).contains(x, y)) {
                        list.setSelectedIndex(i);
                        return;
                    }
                    ++i;
                }
                list.setSelectedIndex(-1);
            }
        });
        return result;
    }

    protected InferredInstancesListPanel createInferredInstancesListPanel() {
        this.inferredInstancesListPanel = new InferredInstancesListPanel();
        this.inferredInstancesListPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                Collection selection = OWLIndividualsTab.this.inferredInstancesListPanel.getSelection();
                Instance selectedInstance = selection.size() == 1 ? (Instance)CollectionUtilities.getFirstItem((Collection)selection) : null;
                if (selectedInstance == null || selectedInstance instanceof RDFResource) {
                    OWLIndividualsTab.this.resourcePanel.setResource((RDFResource)selectedInstance);
                } else if (OWLIndividualsTab.this.resourcePanel instanceof ResourceDisplay) {
                    ((ResourceDisplay)OWLIndividualsTab.this.resourcePanel).setInstance(selectedInstance);
                }
            }
        });
        return this.inferredInstancesListPanel;
    }

    private IndividualsTabClassesPanel createClassesPanel() {
        IndividualsTabClassesPanel classesPanel = new IndividualsTabClassesPanel(this.getOWLModel());
        classesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                OWLIndividualsTab.this.transmitSelection();
            }
        });
        return classesPanel;
    }

    private JComponent createClassSplitter() {
        JSplitPane pane = this.createLeftRightSplitPane("InstancesTab.left_right", 250);
        this.classesPanel = this.createClassesPanel();
        pane.setLeftComponent((Component)((Object)this.classesPanel));
        pane.setRightComponent(this.createInstanceSplitter());
        return pane;
    }

    protected JComponent createDirectTypesList() {
        this.typesListPanel = new AssertedTypesListPanel(this.getOWLModel());
        return this.typesListPanel;
    }

    private JComponent createInstancesPanel() {
        JSplitPane panel = ComponentFactory.createTopBottomSplitPane();
        this.assertedInstancesListPanel = this.createAssertedInstancesListPanel();
        panel.setTopComponent((Component)((Object)this.assertedInstancesListPanel));
        panel.setBottomComponent(this.createDirectTypesList());
        return panel;
    }

    private JComponent createInstanceSplitter() {
        JSplitPane pane = this.createLeftRightSplitPane("InstancesTab.right.left_right", 250);
        pane.setLeftComponent(this.createInstancesPanel());
        this.resourcePanel = ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 2);
        pane.setRightComponent((Component)((Object)this.resourcePanel));
        return pane;
    }

    public boolean displayHostResource(RDFResource resource) {
        if (resource instanceof RDFIndividual && !(resource instanceof OWLOntology) && !(resource instanceof OWLAllDifferent)) {
            this.setSelectedResource(resource);
            return true;
        }
        return false;
    }

    public Selectable getNestedSelectable() {
        return this.assertedInstancesListPanel;
    }

    public void initialize() {
        this.inferredInstancesListPanel = this.createInferredInstancesListPanel();
        this.add(this.createClassSplitter());
        this.transmitSelection();
        this.setupDragAndDrop();
        this.setClsTree(this.classesPanel.getDropComponent());
        this.setLabel("Individuals");
        this.setIcon(OWLIcons.getImageIcon("RDFIndividuals"));
        final SelectableTree tree = (SelectableTree)this.classesPanel.getDropComponent();
        tree.setCellRenderer((TreeCellRenderer)((Object)new InferredInstancesCountRenderer()));
        tree.addMouseListener((MouseListener)new PopupMenuMouseListener((JComponent)tree){

            protected JPopupMenu getPopupMenu() {
                Collection sel = tree.getSelection();
                if (sel.size() == 1) {
                    JPopupMenu menu = new JPopupMenu();
                    Cls cls = (Cls)sel.iterator().next();
                    if (cls instanceof RDFResource) {
                        ResourceActionManager.addResourceActions(menu, (Component)tree, (RDFResource)cls);
                        if (menu.getComponentCount() > 0) {
                            return menu;
                        }
                    }
                }
                return null;
            }

            protected void setSelection(JComponent c, int x, int y) {
                int row = tree.getRowForLocation(x, y);
                if (row >= 0) {
                    tree.setSelectionRow(row);
                }
            }
        });
        this.adjustInstancesDisplayPanel();
    }

    public static boolean isSuitable(Project p, Collection errors) {
        return OWLClassesTab.isSuitable(p, errors);
    }

    protected void transmitSelection(Collection selection) {
        if (selection.contains(this.getOWLModel().getOWLThingClass()) && this.getOWLModel() instanceof OWLDatabaseModel) {
            selection = Collections.EMPTY_LIST;
        }
        this.assertedInstancesListPanel.setClses(selection);
        ArrayList types = new ArrayList();
        for (Object o : selection) {
            if (!(o instanceof RDFSClass)) continue;
            types.add(o);
        }
        this.inferredInstancesListPanel.setTypes(types);
    }

    public void setSelectedCls(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            this.setSelectedClass((RDFSNamedClass)cls);
        }
    }

    public void setSelectedClass(RDFSNamedClass cls) {
        this.classesPanel.setSelectedClass(cls);
    }

    public void setSelectedInstance(Instance instance) {
        if (instance instanceof RDFResource) {
            this.setSelectedResource((RDFResource)instance);
        }
    }

    public void setSelectedResource(RDFResource instance) {
        this.classesPanel.setSelectedClass((RDFSNamedClass)instance.getRDFType());
        this.assertedInstancesListPanel.setSelectedInstance(instance);
        this.typesListPanel.setResource(instance);
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.assertedInstancesListPanel.getDragComponent(), 3, (DragGestureListener)((Object)new AssertedInstancesListDragSourceListener()));
        new DropTarget(this.classesPanel.getDropComponent(), 3, (DropTargetListener)((Object)new IndividualsClassesTreeTarget()));
    }

    protected void transmitSelection() {
        WaitCursor cursor = new WaitCursor((Component)((Object)this));
        try {
            Collection selection = this.classesPanel.getSelection();
            this.transmitSelection(selection);
        }
        finally {
            cursor.hide();
        }
    }

    private class InferredInstancesCountRenderer
    extends FrameRenderer {
        InferredInstancesCountRenderer() {
            this.setDisplayDirectInstanceCount(true);
        }

        protected String getInstanceCountString(Cls cls) {
            RDFSNamedClass c;
            int inferredInstanceCount;
            if (cls instanceof RDFSNamedClass && (inferredInstanceCount = (c = (RDFSNamedClass)cls).getInferredInstanceCount()) > 0) {
                return "  (" + cls.getDirectInstanceCount() + " / " + inferredInstanceCount + ")";
            }
            return super.getInstanceCountString(cls);
        }
    }
}

