/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerAdapter;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes.PrefixesTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PrefixesPanel
extends JPanel
implements Disposable {
    private Action addAction = new AbstractAction("Add new prefix", OWLIcons.getAddIcon("Prefix")){

        public void actionPerformed(ActionEvent e) {
            OWLModel owlModel = PrefixesPanel.this.ontology.getOWLModel();
            try {
                try {
                    owlModel.beginTransaction("Add new namespace prefix");
                    PrefixesPanel.this.addPrefix();
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
        }
    };
    private TableCellRenderer namespaceCellRenderer = new DefaultTableCellRenderer(){

        protected void setValue(Object value) {
            super.setValue(value);
            if (value instanceof String && !PrefixesPanel.this.tableModel.isNamespaceEditable((String)value)) {
                this.setForeground(UNEDITABLE_COLOR);
            } else {
                this.setForeground(Color.black);
            }
        }
    };
    private TableCellRenderer prefixCellRenderer = new DefaultTableCellRenderer(){

        protected void setValue(Object value) {
            super.setValue(value);
            if (value instanceof String && !PrefixesPanel.this.tableModel.isPrefixEditable((String)value)) {
                this.setForeground(UNEDITABLE_COLOR);
            } else {
                this.setForeground(Color.black);
            }
        }
    };
    private JTextField defaultNamespaceField;
    private NamespaceManagerAdapter namespaceManagerListener = new NamespaceManagerAdapter(){

        public void defaultNamespaceChanged(String oldValue, String newValue) {
            PrefixesPanel.this.defaultNamespaceField.setText(newValue);
        }
    };
    private OWLOntology ontology;
    private Action removeAction = new AbstractAction("Remove selected prefix", OWLIcons.getRemoveIcon("Prefix")){

        public void actionPerformed(ActionEvent e) {
            PrefixesPanel.this.removePrefix();
        }
    };
    private JTable table;
    private PrefixesTableModel tableModel;
    private static final Color UNEDITABLE_COLOR = Color.darkGray;

    public PrefixesPanel(OWLOntology ontology) {
        this.ontology = ontology;
        this.tableModel = new PrefixesTableModel(ontology);
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumn prefixColumn = this.table.getColumnModel().getColumn(0);
        TableColumn namespaceColumn = this.table.getColumnModel().getColumn(1);
        prefixColumn.setPreferredWidth(80);
        prefixColumn.setMaxWidth(80);
        prefixColumn.setCellRenderer(this.prefixCellRenderer);
        namespaceColumn.setPreferredWidth(200);
        namespaceColumn.setCellRenderer(this.namespaceCellRenderer);
        JScrollPane scrollPane = new JScrollPane(this.table);
        OWLLabeledComponent lc = new OWLLabeledComponent("Namespace Prefixes", scrollPane);
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        this.removeAction.setEnabled(false);
        lc.addHeaderButton(this.addAction);
        lc.addHeaderButton(this.removeAction);
        this.createDefaultNamespacePanel();
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PrefixesPanel.this.enableActions();
            }
        });
        this.tableModel.getNamespaceManager().addNamespaceManagerListener(this.namespaceManagerListener);
    }

    private String addPrefix() {
        NamespaceManager nsm = this.tableModel.getNamespaceManager();
        String prefix = PrefixesPanel.addPrefix(nsm);
        int row = this.tableModel.getPrefixRow(prefix);
        this.table.getSelectionModel().setSelectionInterval(row, row);
        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
        this.table.requestFocus();
        this.table.editCellAt(row, 0);
        return prefix;
    }

    public static String addPrefix(NamespaceManager nsm) {
        int index = 1;
        String prefix = null;
        while (nsm.getNamespaceForPrefix(prefix = "p" + index++) != null) {
        }
        String namespace = null;
        while (nsm.getPrefix(namespace = "http://www.domain" + index++ + ".com#") != null) {
        }
        nsm.setPrefix(namespace, prefix);
        return prefix;
    }

    private void createDefaultNamespacePanel() {
        NamespaceManager nsm = this.tableModel.getNamespaceManager();
        String namespace = nsm.getDefaultNamespace();
        this.defaultNamespaceField = new JTextField(namespace);
        this.defaultNamespaceField.setEditable(false);
        this.defaultNamespaceField.setMinimumSize(new Dimension(this.defaultNamespaceField.getPreferredSize().width, 30));
    }

    public void dispose() {
        this.tableModel.getNamespaceManager().removeNamespaceManagerListener(this.namespaceManagerListener);
        this.tableModel.dispose();
    }

    private void enableActions() {
        int selIndex = this.table.getSelectedRow();
        boolean enabled = selIndex >= 0 && this.tableModel.getNamespaceManager().isModifiable(this.tableModel.getPrefix(selIndex));
        this.removeAction.setEnabled(enabled);
    }

    public Component getDefaultNamespaceField() {
        return this.defaultNamespaceField;
    }

    public String getSelectedNamespace() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 1) {
            return this.tableModel.getNamespace(rows[0]);
        }
        return null;
    }

    private void makeDefault() {
        OWLModel owlModel = this.ontology.getOWLModel();
        try {
            try {
                int row = this.table.getSelectedRow();
                String prefix = this.tableModel.getPrefix(row);
                NamespaceManager nsm = this.tableModel.getNamespaceManager();
                String namespace = nsm.getNamespaceForPrefix(prefix);
                owlModel.beginTransaction("Make " + namespace + " the default namespace");
                nsm.setDefaultNamespace(namespace);
                nsm.removePrefix(prefix);
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }

    private void removePrefix() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
        int row = this.table.getSelectedRow();
        String prefix = this.tableModel.getPrefix(row);
        OWLModel owlModel = this.ontology.getOWLModel();
        if (owlModel.getRDFResource(String.valueOf(prefix) + ":") instanceof OWLOntology) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "The prefix \"" + prefix + "\" is used by an owl:Ontology element\n" + "of an imported ontology.  Please remove the corresponding\n" + "import first, and then remove the prefix.");
        } else {
            NamespaceManager nsm = this.tableModel.getNamespaceManager();
            try {
                try {
                    owlModel.beginTransaction("Remove namespace prefix " + prefix);
                    nsm.removePrefix(prefix);
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
        }
    }

    public void setSelectedURI(String uri) {
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            String namespace = this.tableModel.getNamespace(i);
            if (namespace.startsWith(uri)) {
                this.table.getSelectionModel().setSelectionInterval(i, i);
                return;
            }
            ++i;
        }
        this.table.getSelectionModel().clearSelection();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addAction.setEnabled(enabled);
        this.removeAction.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }
}

