/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainTableModel;

public class OWLDomainTableModelTestCase
extends AbstractJenaTestCase {
    public void testAddDomainCls() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        OWLDomainTableModel tableModel = new OWLDomainTableModel(property);
        OWLDomainTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertSame((Object)tableModel.getValueAt(0, 0), (Object)this.owlModel.getOWLThingClass());
        RDFSClass domain = property.getDomain(false);
        OWLDomainTableModelTestCase.assertNotNull((Object)domain);
        OWLDomainTableModelTestCase.assertSame((Object)this.owlModel.getOWLThingClass(), (Object)domain);
        property.setDomain(aCls);
        OWLDomainTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        property.addUnionDomainClass(bCls);
        OWLDomainTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertEquals((Object)aCls, (Object)tableModel.getValueAt(0, 0));
        OWLDomainTableModelTestCase.assertEquals((Object)bCls, (Object)tableModel.getValueAt(1, 0));
    }

    public void testRemoveDomainCls() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        property.setDomain(aCls);
        property.addUnionDomainClass(bCls);
        OWLDomainTableModel tableModel = new OWLDomainTableModel(property);
        OWLDomainTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertEquals((Object)aCls, (Object)tableModel.getValueAt(0, 0));
        OWLDomainTableModelTestCase.assertEquals((Object)bCls, (Object)tableModel.getValueAt(1, 0));
        property.removeUnionDomainClass(aCls);
        OWLDomainTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertEquals((Object)bCls, (Object)tableModel.getValueAt(0, 0));
        property.removeUnionDomainClass(bCls);
        OWLDomainTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertSame((Object)this.owlModel.getOWLThingClass(), (Object)tableModel.getValueAt(0, 0));
    }

    public void testInheritanceOfDomain() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLObjectProperty subproperty = this.owlModel.createOWLObjectProperty("subproperty");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        subproperty.addSuperproperty(property);
        bCls.addSuperclass(aCls);
        property.setDomain(aCls);
        OWLDomainTableModel tableModel = new OWLDomainTableModel(subproperty);
        OWLDomainTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertSame((Object)aCls, (Object)tableModel.getValueAt(0, 0));
        subproperty.setDomain(bCls);
        OWLDomainTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertSame((Object)bCls, (Object)tableModel.getValueAt(0, 0));
        subproperty.removeUnionDomainClass(bCls);
        OWLDomainTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        OWLDomainTableModelTestCase.assertSame((Object)aCls, (Object)tableModel.getValueAt(0, 0));
    }
}

