/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourceselection;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.resourceselection.DropDownOverlayIcon;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionComboBox;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public abstract class ResourceSelectionAction
extends AbstractAction
implements ResourceSelectionListener {
    public static boolean activated = true;
    private boolean multipleSelection;
    private boolean showHiddenResources = false;

    public ResourceSelectionAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public ResourceSelectionAction(String name, Icon icon, boolean multipleSelection) {
        super(name, icon);
        this.multipleSelection = multipleSelection;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.multipleSelection) {
            Collection resources = this.pickResources();
            for (RDFResource resource : resources) {
                this.resourceSelected(resource);
            }
        } else {
            RDFResource resource = this.pickResource();
            if (resource != null) {
                this.resourceSelected(resource);
            }
        }
    }

    public void activateComboBox(final JButton button) {
        if (activated) {
            button.setRolloverIcon(new DropDownOverlayIcon(button.getIcon(), button));
            button.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e) && ResourceSelectionAction.this.isEnabled()) {
                        ArrayList<RDFResource> resources = null;
                        if (ResourceSelectionAction.this.getShowHiddenResources()) {
                            resources = ResourceSelectionAction.this.getSelectableResources();
                        } else {
                            resources = new ArrayList<RDFResource>();
                            for (RDFResource resource : ResourceSelectionAction.this.getSelectableResources()) {
                                if (!resource.isVisible() && !resource.isSystem()) continue;
                                resources.add(resource);
                            }
                        }
                        ResourceSelectionComboBox.selectResource(resources, button, 0, ResourceSelectionAction.this, ResourceSelectionAction.this.getRenderer());
                    }
                }
            });
        }
    }

    public ListCellRenderer getRenderer() {
        return new FrameRenderer();
    }

    public abstract Collection getSelectableResources();

    public boolean getShowHiddenResources() {
        return this.showHiddenResources;
    }

    public RDFResource pickResource() {
        return null;
    }

    public Collection pickResources() {
        RDFResource resource = this.pickResource();
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singleton(resource);
    }

    public static void setActivated(boolean value) {
        activated = value;
    }

    public void setShowHiddenResources(boolean value) {
        this.showHiddenResources = value;
    }
}

