/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import java.util.Collection;
import java.util.Iterator;

public class FindResult {
    public static final int RESOURCE_NAME = 0;
    public static final int PROPERTY_NAME = 1;
    public static final int MATCH_VALUE = 2;
    public static final int LANG = 3;
    public static final int NUM_COLUMNS = 4;
    private RDFResource res;
    private Slot prop;
    private String matchValue;
    private String lang;
    private String searchTerm;

    public static FindResult createFindResult(RDFResource res, Slot prop, String searchTerm) {
        try {
            return new FindResult(res, prop, searchTerm);
        }
        catch (Exception e) {
            return null;
        }
    }

    private FindResult(RDFResource res, Slot prop, String searchTerm) throws Exception {
        this.res = res;
        this.prop = prop;
        this.searchTerm = searchTerm;
        if (prop instanceof RDFProperty) {
            Collection values = res.getPropertyValues((RDFProperty)prop);
            Iterator i = values.iterator();
            while (this.matchValue == null && i.hasNext()) {
                Object v = i.next();
                if (v instanceof RDFSLiteral) {
                    RDFSLiteral lit = (RDFSLiteral)v;
                    if (this.matches(lit.getString(), searchTerm)) {
                        this.matchValue = lit.getString();
                        this.lang = lit.getLanguage();
                        continue;
                    }
                    throw new Exception("Cannot find search term [" + searchTerm + "] in literal [" + lit + "]");
                }
                if (this.matches((String)v, searchTerm)) {
                    this.matchValue = (String)v;
                    continue;
                }
                throw new Exception("Cannot find search term [" + searchTerm + "] in string [" + v + "]");
            }
        } else {
            this.matchValue = (String)res.getOwnSlotValue(prop);
        }
    }

    public Object get(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.res;
            }
            case 1: {
                return this.prop;
            }
            case 2: {
                return this.render(this.matchValue);
            }
            case 3: {
                return this.lang;
            }
        }
        return null;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public RDFResource getMatchingResource() {
        return this.res;
    }

    private String render(String value) {
        try {
            String s = this.searchTerm.replaceAll("\\*", "");
            String searchStrLC = s.toLowerCase();
            String valueLC = value.toLowerCase();
            int startInd = valueLC.indexOf(searchStrLC);
            int endInd = startInd + searchStrLC.length();
            StringBuffer buf = new StringBuffer(value);
            buf = buf.insert(endInd, "</b>");
            buf = buf.insert(startInd, "<b>");
            value = "<html>" + buf.toString() + "</html>";
        }
        catch (Exception e) {
            value = "<html><font color=RED>" + value + "</font></html>";
        }
        return value;
    }

    public RDFResource getHost() {
        return (RDFResource)this.get(0);
    }

    public static String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Resource";
            }
            case 1: {
                return "Matching Property";
            }
            case 2: {
                return "Match Value";
            }
            case 3: {
                return "Language";
            }
        }
        return "Unnamed";
    }

    private boolean matches(String value, String searchTerm) {
        String s = searchTerm.replaceAll("\\*", "");
        String searchStrLC = s.toLowerCase();
        String valueLC = value.toLowerCase();
        return valueLC.indexOf(searchStrLC) >= 0;
    }

    public String toString() {
        return "Result [" + this.res + ", " + this.prop + ", " + this.matchValue + ", " + this.lang + "]";
    }
}

