/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.search.FindUsage;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableItem;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableModel;
import java.util.Collection;

public class FindUsageChangedTestCase
extends AbstractJenaTestCase {
    public void testDeleteUsageClass() {
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass findCls = this.owlModel.createOWLNamedClass("Find");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(findCls);
        hostCls.addSuperclass(complementCls);
        Collection items = FindUsage.getItems(findCls);
        FindUsageChangedTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageChangedTestCase.assertEquals((Object)hostCls, (Object)item.host);
        FindUsageChangedTestCase.assertEquals((Object)complementCls, (Object)item.usage);
        FindUsageChangedTestCase.assertEquals((int)0, (int)item.type);
        FindUsageTableModel tableModel = new FindUsageTableModel(this.owlModel, items);
        FindUsageChangedTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        hostCls.removeSuperclass(complementCls);
        FindUsageChangedTestCase.assertEquals((int)0, (int)tableModel.getRowCount());
    }
}

