/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestLibrary;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestSettingsTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class OWLTestSettingsPanel
extends JPanel {
    private JCheckBox automaticTestCheckBox;
    private JTable table;
    private OWLTestSettingsTableModel tableModel;

    public OWLTestSettingsPanel(final OWLTestManager testManager) {
        this.tableModel = new OWLTestSettingsTableModel(testManager);
        this.table = new JTable(this.tableModel){

            public String getToolTipText(MouseEvent event) {
                return OWLTestSettingsPanel.this.getDocumentationOfTestAt(event.getY());
            }
        };
        this.table.setToolTipText("");
        LabeledComponent tablePanel = new LabeledComponent("Available Tests", new JScrollPane(this.table));
        tablePanel.setPreferredSize(new Dimension(600, 400));
        this.table.getColumnModel().getColumn(0).setMaxWidth(80);
        this.automaticTestCheckBox = new JCheckBox("Repair continuously", testManager.isAutoRepairEnabled());
        this.automaticTestCheckBox.setToolTipText("<HTML>If activated, then all repairable tests will be executed after each relevant change (until now: Only for changes in property characteristics).</HTML>");
        this.automaticTestCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                testManager.setAutoRepairEnabled(OWLTestSettingsPanel.this.automaticTestCheckBox.isSelected());
            }
        });
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)tablePanel);
        this.add("South", this.automaticTestCheckBox);
    }

    private String getDocumentationOfTestAt(int y) {
        int row = y / this.table.getRowHeight();
        if (row >= 0 && row < this.tableModel.getRowCount() && !this.tableModel.isSeparator(row)) {
            Class clazz = this.tableModel.getOWLTestClass(row);
            OWLTest test = OWLTestLibrary.getOWLTest(clazz);
            String documentation = test.getDocumentation();
            return documentation;
        }
        return null;
    }

    public static void showOWLTestSettingsDialog(OWLModel owlModel) {
        OWLTestSettingsPanel panel = new OWLTestSettingsPanel(owlModel);
        ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(owlModel.getProject()), panel, "Test Settings", 14);
    }
}

