/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestLibrary;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class OWLTestSettingsTableModel
extends AbstractTableModel {
    public static final int COL_ACTIVATED = 0;
    public static final int COL_NAME = 1;
    public static final int COL_COUNT = 2;
    private List testClasses = new ArrayList();
    private OWLTestManager testManager;

    public OWLTestSettingsTableModel(OWLTestManager testManager) {
        this.testManager = testManager;
        Class[] classes = OWLTestLibrary.getOWLTestClasses();
        Arrays.sort(classes, new Comparator(){

            public int compare(Object o1, Object o2) {
                int groupCompare;
                String group2;
                Class class1 = (Class)o1;
                OWLTest test1 = OWLTestLibrary.getOWLTest(class1);
                Class class2 = (Class)o2;
                OWLTest test2 = OWLTestLibrary.getOWLTest(class2);
                String group1 = test1.getGroup();
                if (group1 == null) {
                    group1 = "";
                }
                if ((group2 = test2.getGroup()) == null) {
                    group2 = "";
                }
                if ((groupCompare = group1.compareTo(group2)) == 0) {
                    return test1.getName().compareTo(test2.getName());
                }
                return groupCompare;
            }
        });
        String previousGroup = null;
        int i = 0;
        while (i < classes.length) {
            Class c = classes[i];
            OWLTest test = OWLTestLibrary.getOWLTest(c);
            String group = test.getGroup();
            if (group != null && !group.equals(previousGroup)) {
                this.testClasses.add(group);
                previousGroup = group;
            }
            this.testClasses.add(c);
            ++i;
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Activated";
        }
        if (column == 1) {
            return "Test Class Name";
        }
        return null;
    }

    public OWLTest getOWLTest(Class clazz) {
        OWLTest[] tests = this.testManager.getOWLTests();
        int i = 0;
        while (i < tests.length) {
            OWLTest test = tests[i];
            if (test.getClass().equals(clazz)) {
                return test;
            }
            ++i;
        }
        return null;
    }

    public Class getOWLTestClass(int rowIndex) {
        return (Class)this.testClasses.get(rowIndex);
    }

    public String getOWLTestClassName(int rowIndex) {
        OWLTest test = this.getOWLTest(this.getOWLTestClass(rowIndex));
        return test.getName();
    }

    public int getRowCount() {
        return this.testClasses.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.isSeparator(rowIndex)) {
            if (columnIndex == 0) {
                String groupName = (String)this.testClasses.get(rowIndex);
                return this.testManager.isOWLTestGroupEnabled(groupName);
            }
            if (columnIndex == 1) {
                return (String)this.testClasses.get(rowIndex);
            }
        } else {
            if (columnIndex == 0) {
                return new Boolean(this.isTestActivated(rowIndex));
            }
            if (columnIndex == 1) {
                Class c = this.getOWLTestClass(rowIndex);
                OWLTest test = OWLTestLibrary.getOWLTest(c);
                String prefix = test.getGroup() == null ? "" : "      ";
                return String.valueOf(prefix) + test.getName();
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public boolean isSeparator(int rowIndex) {
        return this.testClasses.get(rowIndex) instanceof String;
    }

    private boolean isTestActivated(int rowIndex) {
        return this.getOWLTest(this.getOWLTestClass(rowIndex)) != null;
    }

    private void setTestActivated(int rowIndex, boolean value) {
        Class clazz = this.getOWLTestClass(rowIndex);
        if (value) {
            OWLTest test = OWLTestLibrary.getOWLTest(clazz);
            if (test != null) {
                this.testManager.addOWLTest(test);
            }
        } else {
            OWLTest test = this.getOWLTest(clazz);
            if (test != null) {
                this.testManager.removeOWLTest(test);
            }
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            boolean value = (Boolean)aValue;
            if (this.isSeparator(rowIndex)) {
                String groupName = this.getGroupName(rowIndex);
                this.testManager.setOWLTestGroupEnabled(groupName, value);
                this.fireTableDataChanged();
            } else {
                this.setTestActivated(rowIndex, value);
            }
        }
    }

    private String getGroupName(int rowIndex) {
        return (String)this.testClasses.get(rowIndex);
    }
}

