/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.BooleanListWidget;
import edu.stanford.smi.protege.widget.CheckBoxWidget;
import edu.stanford.smi.protege.widget.DefaultWidgetMapper;
import edu.stanford.smi.protege.widget.DirectInstancesWidget;
import edu.stanford.smi.protege.widget.FloatFieldWidget;
import edu.stanford.smi.protege.widget.FloatListWidget;
import edu.stanford.smi.protege.widget.InstanceFieldWidget;
import edu.stanford.smi.protege.widget.InstanceListWidget;
import edu.stanford.smi.protege.widget.IntegerFieldWidget;
import edu.stanford.smi.protege.widget.IntegerListWidget;
import edu.stanford.smi.protege.widget.StringListWidget;
import edu.stanford.smi.protege.widget.TextAreaWidget;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import edu.stanford.smi.protege.widget.UniqueStringWidget;
import edu.stanford.smi.protege.widget.YellowStickyWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.widget.DataRangeFieldWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiResourceWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateTimeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLTimeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMetadata;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetUtil;
import edu.stanford.smi.protegex.owl.ui.widget.RDFListWidget;
import edu.stanford.smi.protegex.owl.ui.widget.ResourceListWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleResourceWidget;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OWLWidgetMapper
extends DefaultWidgetMapper {
    private static Logger log = Log.getLogger(OWLWidgetMapper.class);
    private static Map className2Metadata;
    private static final String[] incompatibleWidgetClassNames;

    static {
        incompatibleWidgetClassNames = new String[]{CheckBoxWidget.class.getName(), DirectInstancesWidget.class.getName(), FloatFieldWidget.class.getName(), FloatListWidget.class.getName(), InstanceFieldWidget.class.getName(), InstanceListWidget.class.getName(), IntegerFieldWidget.class.getName(), IntegerListWidget.class.getName(), ResourceListWidget.class.getName(), StringListWidget.class.getName(), TextAreaWidget.class.getName(), TextFieldWidget.class.getName(), UniqueStringWidget.class.getName(), YellowStickyWidget.class.getName(), "edu.stanford.smi.protegex.widget.contains.ContainsWidget", "edu.stanford.smi.protegex.widget.instancetable.InstanceRowWidget"};
    }

    public OWLWidgetMapper(OWLModel owlModel) {
        super(owlModel.getProject().getInternalProjectKnowledgeBase());
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet) {
        return this.getDefaultWidgetClassName(cls, slot, facet, false);
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet, boolean forceNotNull) {
        if (slot instanceof RDFProperty && cls instanceof RDFSNamedClass) {
            if (!cls.hasTemplateSlot(slot)) {
                return null;
            }
            RDFSNamedClass namedClass = (RDFSNamedClass)cls;
            RDFProperty rdfProperty = (RDFProperty)slot;
            if (rdfProperty.isAnnotationProperty()) {
                return null;
            }
            if (!(rdfProperty.isDomainDefined(true) || OWLWidgetUtil.isRestrictedProperty(namedClass, rdfProperty) || forceNotNull)) {
                return null;
            }
            String defaultClassName = PluginUtilities.getDefaultWidgetClassName((Slot)rdfProperty);
            if (defaultClassName != null) {
                return defaultClassName;
            }
            if (namedClass instanceof OWLNamedClass) {
                OWLNamedClass owlNamedClass = (OWLNamedClass)namedClass;
                ArrayList<RDFProperty> ps = new ArrayList<RDFProperty>();
                ps.add(rdfProperty);
                ps.addAll(rdfProperty.getSuperproperties(true));
                for (RDFProperty property : ps) {
                    if (owlNamedClass.getMaxCardinality(property) != 0) continue;
                    return null;
                }
            }
            OWLWidgetMapper.initWidgetMetadata();
            int bestSuitability = 0;
            String bestClassName = null;
            for (String className : className2Metadata.keySet()) {
                int suitability;
                OWLWidgetMetadata metadata = (OWLWidgetMetadata)className2Metadata.get(className);
                if (metadata == null || (suitability = metadata.getSuitability(namedClass, rdfProperty)) <= bestSuitability) continue;
                bestClassName = className;
                bestSuitability = suitability;
            }
            if (bestClassName != null && bestSuitability > 1) {
                return bestClassName;
            }
            Class[] widgetClasses = new Class[]{DataRangeFieldWidget.class, OWLDateWidget.class, OWLTimeWidget.class, OWLDateTimeWidget.class, RDFListWidget.class, MultiResourceWidget.class, SingleResourceWidget.class, BooleanListWidget.class, MultiLiteralWidget.class, SingleLiteralWidget.class};
            Object[] args = new Object[]{cls, slot, facet};
            int i = 0;
            while (i < widgetClasses.length) {
                Class widgetClass = widgetClasses[i];
                if (OWLWidgetMapper.isSuitable(widgetClass, cls, slot)) {
                    return widgetClass.getName();
                }
                try {
                    Method method = widgetClass.getMethod("isSuitable", Cls.class, Slot.class, Facet.class);
                    if (Boolean.TRUE.equals(method.invoke(null, args))) {
                        return widgetClass.getName();
                    }
                }
                catch (Exception ex) {
                    Log.emptyCatchBlock((Throwable)ex);
                }
                ++i;
            }
        }
        return super.getDefaultWidgetClassName(cls, slot, facet);
    }

    public static OWLWidgetMetadata getOWLWidgetMetadata(String className) {
        OWLWidgetMapper.initWidgetMetadata();
        return (OWLWidgetMetadata)className2Metadata.get(className);
    }

    public Collection getSuitableWidgetClassNames(Cls cls, Slot slot, Facet facet) {
        ArrayList ss = new ArrayList(super.getSuitableWidgetClassNames(cls, slot, facet));
        int i = 0;
        while (i < incompatibleWidgetClassNames.length) {
            String className = incompatibleWidgetClassNames[i];
            ss.remove(className);
            ++i;
        }
        return ss;
    }

    private static void initWidgetMetadata() {
        if (className2Metadata == null) {
            className2Metadata = new HashMap();
            Collection classNames = PluginUtilities.getAvailableSlotWidgetClassNames();
            for (String clsName : classNames) {
                String metadataClassName = String.valueOf(clsName) + "Metadata";
                try {
                    Class metadataClass = PluginUtilities.forName((String)metadataClassName, (boolean)true);
                    if (metadataClass == null) continue;
                    Object metadata = metadataClass.newInstance();
                    className2Metadata.put(clsName, metadata);
                }
                catch (Exception ex) {
                    Log.emptyCatchBlock((Throwable)ex);
                }
            }
        }
    }

    public static boolean isIncompatibleWidgetName(String className) {
        int i = 0;
        while (i < incompatibleWidgetClassNames.length) {
            String incompatiblewidgetclassname = incompatibleWidgetClassNames[i];
            if (className.equals(incompatiblewidgetclassname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSuitable(Class clazz, Cls cls, Slot slot) {
        if (slot instanceof RDFProperty && cls instanceof RDFSNamedClass) {
            RDFProperty property = (RDFProperty)slot;
            String className = clazz.getName();
            OWLWidgetMetadata metadata = OWLWidgetMapper.getOWLWidgetMetadata(className);
            if (metadata != null) {
                RDFSNamedClass namedClass = (RDFSNamedClass)cls;
                return metadata.getSuitability(namedClass, property) > 0;
            }
        }
        return false;
    }
}

