/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.renderer;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;

public class RDFAxiomRenderer
extends OWLModelVisitorAdapter {
    private XMLWriter writer;
    private RDFResource resource;
    private TripleStore tripleStore;

    public RDFAxiomRenderer(RDFResource resource, TripleStore tripleStore, XMLWriter writer) {
        this.writer = writer;
        this.tripleStore = tripleStore;
        this.resource = resource;
    }

    protected RDFAxiomRenderer() {
    }

    public static RenderableAxiomsChecker getChecker() {
        return new RDFAxiomRenderer().new RenderableAxiomsChecker();
    }

    public void write() {
        this.resource.accept(this);
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom owlAllValuesFrom) {
        this.renderClassAxioms(owlAllValuesFrom);
    }

    public void visitOWLCardinality(OWLCardinality owlCardinality) {
        this.renderClassAxioms(owlCardinality);
    }

    public void visitOWLComplementClass(OWLComplementClass owlComplementClass) {
        this.renderClassAxioms(owlComplementClass);
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass owlEnumeratedClass) {
        this.renderClassAxioms(owlEnumeratedClass);
    }

    public void visitOWLHasValue(OWLHasValue owlHasValue) {
        this.renderClassAxioms(owlHasValue);
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass owlIntersectionClass) {
        this.renderClassAxioms(owlIntersectionClass);
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality owlMaxCardinality) {
        this.renderClassAxioms(owlMaxCardinality);
    }

    public void visitOWLMinCardinality(OWLMinCardinality owlMinCardinality) {
        this.renderClassAxioms(owlMinCardinality);
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom owlSomeValuesFrom) {
        this.renderClassAxioms(owlSomeValuesFrom);
    }

    public void visitOWLUnionClass(OWLUnionClass owlUnionClass) {
        this.renderClassAxioms(owlUnionClass);
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty owlDatatypeProperty) {
        this.renderPropertyAxioms(owlDatatypeProperty);
    }

    public void visitOWLIndividual(OWLIndividual owlIndividual) {
        this.renderIndividualAxioms(owlIndividual);
    }

    public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
        this.renderClassAxioms(owlNamedClass);
    }

    public void visitOWLObjectProperty(OWLObjectProperty owlObjectProperty) {
        this.renderPropertyAxioms(owlObjectProperty);
    }

    public void visitRDFIndividual(RDFIndividual rdfIndividual) {
        this.renderIndividualAxioms(rdfIndividual);
    }

    public void visitRDFProperty(RDFProperty rdfProperty) {
        this.renderPropertyAxioms(rdfProperty);
    }

    public void visitRDFSNamedClass(RDFSNamedClass rdfsNamedClass) {
        this.renderClassAxioms(rdfsNamedClass);
    }

    private void renderClassAxioms(RDFSClass cls) {
        try {
            RDFResource type = Util.getType(cls, this.tripleStore);
            if (type != null) {
                Util.insertResourceAsElement(type, this.writer);
            } else {
                this.writer.writeStartElement("rdf:Description");
            }
            Util.insertIDOrAboutAttribute(cls, this.tripleStore, this.writer);
            this.renderTypes(cls, type);
            HashSet<RDFResource> renderedEquivalentClasses = new HashSet<RDFResource>();
            HashSet<RDFResource> renderedNamedClassOperands = new HashSet<RDFResource>();
            RDFProperty equivClassProp = cls.getOWLModel().getRDFProperty("owl:equivalentClass");
            Iterator it = this.tripleStore.listObjects(cls, equivClassProp);
            while (it.hasNext()) {
                RDFResource curSuper = (RDFResource)it.next();
                if (curSuper instanceof OWLNamedClass) {
                    renderedNamedClassOperands.add(curSuper);
                } else if (curSuper instanceof OWLIntersectionClass) {
                    for (Object curOp : ((OWLIntersectionClass)curSuper).getOperands()) {
                        if (!(curOp instanceof OWLNamedClass)) continue;
                        renderedNamedClassOperands.add((RDFResource)curOp);
                    }
                }
                renderedEquivalentClasses.add(curSuper);
                this.writer.writeStartElement("owl:equivalentClass");
                Util.inlineObject(curSuper, this.tripleStore, this.writer);
                this.writer.writeEndElement();
            }
            int processedSupers = 0;
            RDFProperty subClassOfProp = cls.getOWLModel().getRDFProperty("rdfs:subClassOf");
            Iterator it2 = this.tripleStore.listObjects(cls, subClassOfProp);
            while (it2.hasNext()) {
                boolean isOWLThing;
                RDFSClass curSupCls = (RDFSClass)it2.next();
                if (!renderedEquivalentClasses.contains(curSupCls) && !renderedNamedClassOperands.contains(curSupCls) && (!(isOWLThing = curSupCls.equals(curSupCls.getOWLModel().getOWLThingClass())) || isOWLThing && it2.hasNext() || isOWLThing && processedSupers > 0)) {
                    this.writer.writeStartElement("rdfs:subClassOf");
                    Util.inlineObject(curSupCls, this.tripleStore, this.writer);
                    this.writer.writeEndElement();
                }
                ++processedSupers;
            }
            Util.insertProperties(cls, this.tripleStore, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void renderPropertyAxioms(RDFProperty property) {
        try {
            RDFResource type = Util.getType(property, this.tripleStore);
            if (type != null) {
                Util.insertResourceAsElement(type, this.writer);
            } else {
                this.writer.writeStartElement("rdf:Description");
            }
            Util.insertIDOrAboutAttribute(property, this.tripleStore, this.writer);
            this.renderTypes(property, type);
            RDFSClass domain = property.getDomain(false);
            if (domain != null && !domain.equals(property.getOWLModel().getOWLThingClass())) {
                this.writer.writeStartElement("rdfs:domain");
                Util.inlineObject(domain, this.tripleStore, this.writer);
                this.writer.writeEndElement();
            }
            Util.insertProperties(property, this.tripleStore, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void renderIndividualAxioms(RDFIndividual individual) {
        try {
            RDFResource type = Util.getType(individual, this.tripleStore);
            if (type != null) {
                Util.insertResourceAsElement(type, this.writer);
            } else {
                this.writer.writeStartElement("rdf:Description");
            }
            Util.insertIDOrAboutAttribute(individual, this.tripleStore, this.writer);
            this.renderTypes(individual, type);
            Util.insertProperties(individual, this.tripleStore, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void renderTypes(RDFResource resource, RDFResource excludeType) throws IOException {
        Util.renderTypes(resource, this.tripleStore, excludeType, this.writer);
    }

    public class RenderableAxiomsChecker
    extends OWLModelVisitorAdapter {
        private boolean renderable;

        public boolean isRenderable(RDFResource resource) {
            this.renderable = false;
            resource.accept(this);
            return this.renderable;
        }

        public void visitOWLAllValuesFrom(OWLAllValuesFrom owlAllValuesFrom) {
            this.renderable = true;
        }

        public void visitOWLCardinality(OWLCardinality owlCardinality) {
            this.renderable = true;
        }

        public void visitOWLComplementClass(OWLComplementClass owlComplementClass) {
            this.renderable = true;
        }

        public void visitOWLDatatypeProperty(OWLDatatypeProperty owlDatatypeProperty) {
            this.renderable = true;
        }

        public void visitOWLEnumeratedClass(OWLEnumeratedClass owlEnumeratedClass) {
            this.renderable = true;
        }

        public void visitOWLHasValue(OWLHasValue owlHasValue) {
            this.renderable = true;
        }

        public void visitOWLIndividual(OWLIndividual owlIndividual) {
            this.renderable = true;
        }

        public void visitOWLIntersectionClass(OWLIntersectionClass owlIntersectionClass) {
            this.renderable = true;
        }

        public void visitOWLMaxCardinality(OWLMaxCardinality owlMaxCardinality) {
            this.renderable = true;
        }

        public void visitOWLMinCardinality(OWLMinCardinality owlMinCardinality) {
            this.renderable = true;
        }

        public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
            this.renderable = true;
        }

        public void visitOWLObjectProperty(OWLObjectProperty owlObjectProperty) {
            this.renderable = true;
        }

        public void visitOWLSomeValuesFrom(OWLSomeValuesFrom owlSomeValuesFrom) {
            this.renderable = true;
        }

        public void visitOWLUnionClass(OWLUnionClass owlUnionClass) {
            this.renderable = true;
        }

        public void visitRDFIndividual(RDFIndividual rdfIndividual) {
            this.renderable = true;
        }

        public void visitRDFProperty(RDFProperty rdfProperty) {
            this.renderable = true;
        }

        public void visitRDFSNamedClass(RDFSNamedClass rdfsNamedClass) {
            this.renderable = true;
        }
    }
}

