/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.util;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;

public class InlineResourceChecker
extends OWLModelVisitorAdapter {
    private boolean canInline = false;

    public boolean isCanInline() {
        return this.canInline;
    }

    public void visitOWLOntology(OWLOntology owlOntology) {
        this.canInline = true;
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty owlDatatypeProperty) {
        this.canInline = true;
    }

    public void visitOWLIndividual(OWLIndividual owlIndividual) {
        if (!owlIndividual.getOWLModel().isAnonymousResourceName(owlIndividual.getName())) {
            this.canInline = true;
        }
    }

    public void visitRDFDatatype(RDFSDatatype rdfsDatatype) {
        this.canInline = !rdfsDatatype.isAnonymous();
    }

    public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
        this.canInline = true;
    }

    public void visitOWLObjectProperty(OWLObjectProperty owlObjectProperty) {
        this.canInline = true;
    }

    public void visitRDFExternalResource(RDFExternalResource rdfExternalResource) {
        this.canInline = true;
    }

    public void visitRDFIndividual(RDFIndividual rdfIndividual) {
        if (!rdfIndividual.getOWLModel().isAnonymousResourceName(rdfIndividual.getName())) {
            this.canInline = true;
        }
    }

    public void visitRDFProperty(RDFProperty rdfProperty) {
        this.canInline = true;
    }

    public void visitRDFSNamedClass(RDFSNamedClass rdfsNamedClass) {
        this.canInline = true;
    }
}

