/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import junit.framework.Assert;

public class RDFSDatatypeExamples {
    public static void main(String[] args) {
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModel();
        OWLNamedClass cls = owlModel.createOWLNamedClass("Class");
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        OWLDatatypeProperty stringProperty = owlModel.createOWLDatatypeProperty("stringProperty", owlModel.getXSDstring());
        individual.setPropertyValue(stringProperty, "MyString");
        String stringValue = (String)individual.getPropertyValue(stringProperty);
        OWLDatatypeProperty booleanProperty = owlModel.createOWLDatatypeProperty("booleanProperty", owlModel.getXSDboolean());
        individual.setPropertyValue(booleanProperty, Boolean.TRUE);
        Boolean booleanValue = (Boolean)individual.getPropertyValue(booleanProperty);
        OWLDatatypeProperty floatProperty = owlModel.createOWLDatatypeProperty("floatProperty", owlModel.getXSDfloat());
        individual.setPropertyValue(floatProperty, new Float(4.2));
        Float floatValue = (Float)individual.getPropertyValue(floatProperty);
        OWLDatatypeProperty intProperty = owlModel.createOWLDatatypeProperty("intProperty", owlModel.getXSDint());
        individual.setPropertyValue(floatProperty, new Integer(42));
        Integer intValue = (Integer)individual.getPropertyValue(intProperty);
        RDFSLiteral intLiteral = individual.getPropertyValueLiteral(intProperty);
        Assert.assertEquals((int)intLiteral.getInt(), (int)intValue);
        Assert.assertTrue((boolean)intLiteral.getDatatype().equals(owlModel.getXSDint()));
        RDFSDatatype xsdDate = owlModel.getRDFSDatatypeByName("xsd:date");
        OWLDatatypeProperty dateProperty = owlModel.createOWLDatatypeProperty("dateProperty", xsdDate);
        RDFSLiteral dateLiteral = owlModel.createRDFSLiteral("1971-07-06", xsdDate);
        individual.setPropertyValue(dateProperty, dateLiteral);
        RDFSLiteral myDate = (RDFSLiteral)individual.getPropertyValue(dateProperty);
        System.out.println("Date: " + myDate);
        RDFSLiteral langLiteral = owlModel.createRDFSLiteral("Wert", "de");
        individual.setPropertyValue(stringProperty, langLiteral);
        RDFSLiteral result = (RDFSLiteral)individual.getPropertyValue(stringProperty);
        Assert.assertTrue((boolean)result.getLanguage().equals("de"));
        Assert.assertTrue((boolean)result.getString().equals("Wert"));
    }
}

