/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;

class ChangeIncludedProjectsPanel
extends JComponent {
    private SelectableList _list;

    ChangeIncludedProjectsPanel(Project project) {
        this.setLayout(new BorderLayout());
        this._list = ComponentFactory.createSelectableList(null);
        ComponentUtilities.setListValues(this._list, project.getDirectIncludedProjectURIs());
        LabeledComponent labeledComponent = new LabeledComponent("Directly Included Projects", new JScrollPane(this._list));
        labeledComponent.addHeaderButton(this.createSelectProjectAction());
        labeledComponent.addHeaderButton(this.createRemoveProjectAction(this._list));
        this.add(labeledComponent);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public Collection getIncludedProjectURIs() {
        return ComponentUtilities.getListValues(this._list);
    }

    private Action createSelectProjectAction() {
        return new AddAction(ResourceKey.PROJECT_ADD){

            public void onAdd() {
                JFileChooser jFileChooser = ComponentFactory.createFileChooser("Select Project", "Project Files", "pprj");
                int n = jFileChooser.showOpenDialog(ChangeIncludedProjectsPanel.this);
                switch (n) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        ComponentUtilities.addListValue(ChangeIncludedProjectsPanel.this._list, jFileChooser.getSelectedFile().toURI());
                        break;
                    }
                    default: {
                        Assert.fail("bad result: " + n);
                    }
                }
            }
        };
    }

    private Action createRemoveProjectAction(SelectableList selectableList) {
        return new RemoveAction(ResourceKey.PROJECT_REMOVE, (Selectable)selectableList){

            public void onRemove(Collection collection) {
                ComponentUtilities.removeListValues(ChangeIncludedProjectsPanel.this._list, collection);
            }
        };
    }
}

