/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FacetListener;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.event.TransactionListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameCounts;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.MaximumCardinalityConstraint;
import edu.stanford.smi.protege.model.MinimumCardinalityConstraint;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.RoleConstraint;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.model.framestore.DefaultFrameFactory;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.undo.UndoFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultKnowledgeBase
implements KnowledgeBase {
    private static transient Logger log = Log.getLogger(DefaultKnowledgeBase.class);
    private static final int GENERATED_NAME_LENGTH = 8;
    private FrameStoreManager _frameStoreManager;
    private SystemFrames _systemFrames;
    private FrameFactory _frameFactory;
    private Cls _defaultClsMetaCls;
    private Cls _defaultSlotMetaCls;
    private Cls _defaultFacetMetaCls;
    private String _buildString;
    private String _frameNamePrefix;
    private Map _clientInformation = new HashMap();
    private KnowledgeBaseFactory _knowledgeBaseFactory;
    private Project _project;
    private String _name;
    private String _userName;
    private String _versionString;
    private FrameNameValidator _frameNameValidator;

    private void initializeKBName() {
        String string = String.valueOf(Math.random());
        int n = Math.min(string.length(), 8);
        this._name = "KB_" + string.substring(2, n);
    }

    protected SystemFrames createSystemFrames() {
        return new SystemFrames(this);
    }

    protected FrameFactory createFrameFactory() {
        return new DefaultFrameFactory(this);
    }

    protected FrameStoreManager createFrameStoreManager() {
        return new FrameStoreManager(this);
    }

    protected FrameStoreManager getFrameStoreManager() {
        return this._frameStoreManager;
    }

    public FrameStore getHeadFrameStore() {
        if (this._frameStoreManager == null) {
            throw new RuntimeException("Method called on closed knowledgeBase: " + this.getName());
        }
        return this._frameStoreManager.getHeadFrameStore();
    }

    public DefaultKnowledgeBase(KnowledgeBaseFactory knowledgeBaseFactory) {
        this.initializeKBName();
        this._systemFrames = this.createSystemFrames();
        this._defaultClsMetaCls = this._systemFrames.getStandardClsMetaCls();
        this._defaultSlotMetaCls = this._systemFrames.getStandardSlotMetaCls();
        this._defaultFacetMetaCls = this._systemFrames.getStandardFacetMetaCls();
        this._frameFactory = this.createFrameFactory();
        this._frameStoreManager = this.createFrameStoreManager();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Phase 1 Initialization of Model starts");
        }
        this._knowledgeBaseFactory = knowledgeBaseFactory;
    }

    public DefaultKnowledgeBase() {
        this.initializeKBName();
        this._systemFrames = this.createSystemFrames();
        this._defaultClsMetaCls = this._systemFrames.getStandardClsMetaCls();
        this._defaultSlotMetaCls = this._systemFrames.getStandardSlotMetaCls();
        this._defaultFacetMetaCls = this._systemFrames.getStandardFacetMetaCls();
        this._frameFactory = this.createFrameFactory();
        this._frameStoreManager = this.createFrameStoreManager();
    }

    public synchronized SystemFrames getSystemFrames() {
        return this._systemFrames;
    }

    public synchronized FrameFactory getFrameFactory() {
        return this._frameFactory;
    }

    public synchronized void close() {
        this._frameStoreManager.close();
    }

    public synchronized boolean setCleanDispatchEnabled(boolean bl) {
        return this._frameStoreManager.setCleanDispatchEnabled(bl);
    }

    public synchronized boolean setArgumentCheckingEnabled(boolean bl) {
        return this._frameStoreManager.setArgumentCheckingEnabled(bl);
    }

    public synchronized boolean isJournalingEnabled() {
        return this._frameStoreManager.isJournalingEnabled();
    }

    public synchronized boolean isCallCachingEnabled() {
        return this._frameStoreManager.isCallCachingEnabled();
    }

    public synchronized boolean setJournalingEnabled(boolean bl) {
        return this._frameStoreManager.setJournalingEnabled(bl);
    }

    public synchronized boolean setUndoEnabled(boolean bl) {
        return this._frameStoreManager.setUndoEnabled(bl);
    }

    public synchronized boolean setEventDispatchEnabled(boolean bl) {
        return this._frameStoreManager.setEventDispatchEnabled(bl);
    }

    public synchronized boolean setCallCachingEnabled(boolean bl) {
        return this._frameStoreManager.setCallCachingEnabled(bl);
    }

    public synchronized boolean setGenerateEventsEnabled(boolean bl) {
        return this._frameStoreManager.setGenerateEventsEnabled(bl);
    }

    private UndoFrameStore getUndoFrameStore() {
        return this._frameStoreManager.getUndoFrameStore();
    }

    public synchronized boolean isUndoEnabled() {
        return this._frameStoreManager.isUndoEnabled();
    }

    public synchronized List getDirectOwnSlotValues(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getDirectOwnSlotValues(frame, slot);
    }

    public synchronized Cls createCls(String string, Collection collection, Collection collection2, boolean bl) {
        return this.createCls(null, string, collection, collection2, bl);
    }

    public synchronized Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        return this.getHeadFrameStore().createCls(frameID, string, collection2, collection, bl);
    }

    public synchronized Slot createSlot(String string, Cls cls, Collection collection, boolean bl) {
        return this.createSlot(null, string, CollectionUtilities.createCollection(cls), collection, bl);
    }

    public synchronized Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        return this.getHeadFrameStore().createSlot(frameID, string, collection, collection2, bl);
    }

    public synchronized SimpleInstance createSimpleInstance(String string, Cls cls, boolean bl) {
        return this.createSimpleInstance(null, string, cls, bl);
    }

    public synchronized SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        return this.getHeadFrameStore().createSimpleInstance(frameID, string, collection, bl);
    }

    public synchronized SimpleInstance createSimpleInstance(FrameID frameID, String string, Cls cls, boolean bl) {
        Collection collection = CollectionUtilities.createCollection(cls);
        return this.createSimpleInstance(frameID, string, collection, bl);
    }

    public synchronized void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof Slot && slot.equals(this._systemFrames.getValueTypeSlot())) {
            ValueType valueType = ValueTypeConstraint.getType(collection);
            collection = CollectionUtilities.removeFirst(collection);
            this.setValueTypeValues((Slot)frame, valueType, collection);
        } else {
            this.getHeadFrameStore().setDirectOwnSlotValues(frame, slot, collection);
        }
    }

    public synchronized Frame getFrame(FrameID frameID) {
        return this.getHeadFrameStore().getFrame(frameID);
    }

    public synchronized Frame getFrame(String string) {
        return this.getHeadFrameStore().getFrame(string);
    }

    public synchronized Collection getOwnSlotValues(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getOwnSlotValues(frame, slot);
    }

    public synchronized Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        List list = this.getDirectOwnSlotValues(frame, slot);
        return CollectionUtilities.getFirstItem(list);
    }

    public synchronized Collection getOwnSlots(Frame frame) {
        return this.getHeadFrameStore().getOwnSlots(frame);
    }

    public synchronized Collection getTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getTemplateSlots(cls);
    }

    public synchronized Collection getReferences(Frame frame) {
        return this.getHeadFrameStore().getReferences(frame);
    }

    public synchronized void deleteFrame(Frame frame) {
        if (frame instanceof Cls) {
            this.deleteCls((Cls)frame);
        } else if (frame instanceof Slot) {
            this.deleteSlot((Slot)frame);
        } else if (frame instanceof Facet) {
            this.deleteFacet((Facet)frame);
        } else {
            this.deleteSimpleInstance((SimpleInstance)frame);
        }
    }

    public synchronized boolean setEventsEnabled(boolean bl) {
        return this.setGenerateEventsEnabled(bl);
    }

    public synchronized boolean getEventsEnabled() {
        return this.getGenerateEventsEnabled();
    }

    public synchronized boolean getGenerateEventsEnabled() {
        return this._frameStoreManager.getGenerateEventsEnabled();
    }

    public synchronized boolean getDispatchEventsEnabled() {
        return this._frameStoreManager.getDispatchEventsEnabled();
    }

    public synchronized boolean setDispatchEventsEnabled(boolean bl) {
        return this._frameStoreManager.setEventDispatchEnabled(bl);
    }

    public synchronized boolean setChangeMonitorEnabled(boolean bl) {
        return this._frameStoreManager.setChangeMonitorEnabled(bl);
    }

    public synchronized Cls getDirectType(Instance instance) {
        Collection collection = this.getDirectTypes(instance);
        return (Cls)CollectionUtilities.getFirstItem(collection);
    }

    public synchronized Collection getDirectSuperclasses(Cls cls) {
        return this.getHeadFrameStore().getDirectSuperclasses(cls);
    }

    public synchronized String getName(Frame frame) {
        return this.getHeadFrameStore().getFrameName(frame);
    }

    public synchronized void addJavaLoadPackage(String string) {
        this._frameFactory.addJavaPackage(string);
    }

    public synchronized boolean areValidOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        boolean bl = true;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (bl && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            bl = facet.areValidValues(frame, slot, collection);
        }
        return bl;
    }

    public synchronized void changeFrameName(Frame frame, String string) {
        this.setFrameName(frame, string);
    }

    public synchronized void setFrameName(Frame frame, String string) {
        if (!this.isValidFrameName(string, frame)) {
            throw new IllegalArgumentException("Invalid frame name: " + string);
        }
        this.getHeadFrameStore().setFrameName(frame, string);
    }

    public synchronized boolean containsFrame(String string) {
        return this.getFrame(string) != null;
    }

    public synchronized Cls createCls(String string, Collection collection) {
        return this.createCls(string, collection, this.getDefaultClsMetaCls(collection));
    }

    private Cls getDefaultClsMetaCls(Collection collection) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
        Cls cls2 = cls == null || DefaultKnowledgeBase.equals(cls, this._systemFrames.getRootCls()) ? this._defaultClsMetaCls : cls.getDirectType();
        return cls2;
    }

    public synchronized Cls createCls(String string, Collection collection, Cls cls) {
        return this.createCls(string, collection, cls, true);
    }

    public synchronized Cls createCls(String string, Collection collection, Cls cls, boolean bl) {
        Collection collection2 = CollectionUtilities.createCollection(cls);
        return this.createCls(string, collection, collection2, bl);
    }

    public synchronized Facet createFacet(String string) {
        return this.createFacet(string, this._defaultFacetMetaCls);
    }

    public synchronized Facet createFacet(String string, Cls cls) {
        return this.createFacet(string, cls, true);
    }

    public synchronized Facet createFacet(String string, Cls cls, boolean bl) {
        Collection collection = CollectionUtilities.createCollection(cls);
        return this.createFacet(null, string, collection, bl);
    }

    public synchronized Facet createFacet(FrameID frameID, String string, Collection arrayList, boolean bl) {
        if (arrayList.isEmpty()) {
            arrayList = new ArrayList<Cls>();
            arrayList.add(this._defaultFacetMetaCls);
        }
        return this.getHeadFrameStore().createFacet(frameID, string, arrayList, bl);
    }

    public synchronized Instance createInstance(String string, Cls cls) {
        return this.createInstance(string, cls, true);
    }

    public synchronized Instance createInstance(String string, Collection collection) {
        return this.createInstance(null, string, collection, true);
    }

    public synchronized Instance createInstance(String string, Cls cls, boolean bl) {
        return this.createInstance(null, string, cls, bl);
    }

    public synchronized Instance createInstance(FrameID frameID, String string, Cls cls, boolean bl) {
        Collection collection = CollectionUtilities.createCollection(cls);
        return this.createInstance(frameID, string, collection, bl);
    }

    public synchronized Instance createInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
        Instance instance = cls == null ? this.createSimpleInstance(frameID, string, cls, bl) : (this.isClsMetaCls(cls) ? this.createCls(frameID, string, Collections.EMPTY_LIST, collection, bl) : (this.isSlotMetaCls(cls) ? this.createSlot(frameID, string, collection, Collections.EMPTY_LIST, bl) : (this.isFacetMetaCls(cls) ? this.createFacet(frameID, string, collection, bl) : this.createSimpleInstance(frameID, string, collection, bl))));
        return instance;
    }

    public synchronized Slot createSlot(String string) {
        return this.createSlot(string, this._defaultSlotMetaCls);
    }

    public synchronized Slot createSlot(String string, Cls cls) {
        return this.createSlot(string, cls, true);
    }

    public synchronized Slot createSlot(String string, Cls cls, boolean bl) {
        return this.createSlot(string, cls, Collections.EMPTY_LIST, bl);
    }

    public String createUniqueFrameName(String string) {
        return null;
    }

    public synchronized void deleteCls(Cls cls) {
        if (!this.getInstances(cls).isEmpty()) {
            throw new RuntimeException("Delete of class with instances.");
        }
        this.getHeadFrameStore().deleteCls(cls);
        DefaultKnowledgeBase.markAsDeleted(cls);
    }

    private void moveSubclassesToParents(Cls cls, Collection collection) {
        for (Cls cls2 : new ArrayList(this.getDirectSubclasses(cls))) {
            this.moveSubclassToParents(cls2, cls, collection);
        }
    }

    private void moveSubclassToParents(Cls cls, Cls cls2, Collection collection) {
        for (Cls cls3 : collection) {
            this.addDirectSuperclass(cls, cls3);
            this.removeDirectSuperclass(cls, cls2);
        }
    }

    private void moveInstancesToParents(Cls cls, Collection collection) {
        for (Instance instance : new ArrayList(this.getDirectInstances(cls))) {
            this.moveInstanceToParents(instance, cls, collection);
        }
    }

    private void moveInstanceToParents(Instance instance, Cls cls, Collection collection) {
        for (Cls cls2 : collection) {
            this.addDirectType(instance, cls2);
            this.removeDirectType(instance, cls);
        }
    }

    public synchronized void deleteFacet(Facet facet) {
        this.getHeadFrameStore().deleteFacet(facet);
        DefaultKnowledgeBase.markAsDeleted(facet);
    }

    public synchronized void deleteInstance(Instance instance) {
        this.deleteFrame(instance);
    }

    public synchronized void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.getHeadFrameStore().deleteSimpleInstance(simpleInstance);
        DefaultKnowledgeBase.markAsDeleted(simpleInstance);
    }

    public synchronized void deleteSlot(Slot slot) {
        this.getHeadFrameStore().deleteSlot(slot);
        DefaultKnowledgeBase.markAsDeleted(slot);
    }

    private static void markAsDeleted(Frame frame) {
        frame.markDeleted(true);
    }

    public synchronized String getBuildString() {
        return this._buildString;
    }

    public synchronized Object getClientInformation(Object object) {
        return this._clientInformation.get(object);
    }

    public synchronized Cls getCls(String string) {
        return (Cls)this.getFrameOfType(string, Cls.class);
    }

    private Frame getFrameOfType(String string, Class clazz) {
        Frame frame = this.getFrame(string);
        if (frame != null && !clazz.isInstance(frame)) {
            this.getFrame(string);
            Log.getLogger().warning("Wrong type: " + frame);
            frame = null;
        }
        return frame;
    }

    public synchronized int getClsCount() {
        return this.getHeadFrameStore().getClsCount();
    }

    public synchronized int getSimpleInstanceCount() {
        return this.getHeadFrameStore().getSimpleInstanceCount();
    }

    public synchronized Collection getClses() {
        return this.getHeadFrameStore().getClses();
    }

    public synchronized Collection getClsNameMatches(String string, int n) {
        Collection collection = this.getFrameNameMatches(string, n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Cls) continue;
            iterator.remove();
        }
        return collection;
    }

    public synchronized Cls getDefaultClsMetaCls() {
        return this._defaultClsMetaCls;
    }

    public synchronized Cls getDefaultFacetMetaCls() {
        return this._defaultFacetMetaCls;
    }

    public synchronized Cls getDefaultSlotMetaCls() {
        return this._defaultSlotMetaCls;
    }

    public synchronized Facet getFacet(String string) {
        return (Facet)this.getFrameOfType(string, Facet.class);
    }

    public synchronized int getFacetCount() {
        return this.getHeadFrameStore().getFacetCount();
    }

    public synchronized Collection getFacets() {
        return this.getHeadFrameStore().getFacets();
    }

    public synchronized int getFrameCount() {
        return this.getHeadFrameStore().getFrameCount();
    }

    public synchronized String getFrameCreationTimestamp(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getCreationTimestampSlot());
    }

    public synchronized String getFrameCreator(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getCreatorSlot());
    }

    public synchronized String getFrameLastModificationTimestamp(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getModificationTimestampSlot());
    }

    public synchronized String getFrameLastModifier(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getModifierSlot());
    }

    public synchronized Collection getFrameNameMatches(String string, int n) {
        return this.getFramesWithMatchingDirectOwnSlotValue(this._systemFrames.getNameSlot(), string, n);
    }

    public synchronized Collection getFramesWithValue(Slot slot, Facet facet, boolean bl, Object object) {
        Set set = facet == null ? (bl ? this.getHeadFrameStore().getClsesWithDirectTemplateSlotValue(slot, object) : this.getHeadFrameStore().getFramesWithDirectOwnSlotValue(slot, object)) : this.getHeadFrameStore().getClsesWithDirectTemplateFacetValue(slot, facet, object);
        return set;
    }

    public synchronized Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        return this.getHeadFrameStore().getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
    }

    public synchronized String getFrameNamePrefix() {
        return this._frameNamePrefix;
    }

    public synchronized Collection getFrames() {
        return this.getHeadFrameStore().getFrames();
    }

    public synchronized Instance getInstance(String string) {
        return (Instance)this.getFrame(string);
    }

    public synchronized SimpleInstance getSimpleInstance(String string) {
        return (SimpleInstance)this.getFrame(string);
    }

    public synchronized Collection getInstances() {
        return this.getFrames();
    }

    public synchronized Collection getInstances(Cls cls) {
        return this.getHeadFrameStore().getInstances(cls);
    }

    public synchronized String getInvalidOwnSlotValuesText(Frame frame, Slot slot, Collection collection) {
        String string = null;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (string == null && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            string = facet.getInvalidValuesText(frame, slot, collection);
        }
        return string;
    }

    public synchronized String getInvalidOwnSlotValueText(Frame frame, Slot slot, Object object) {
        String string = null;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (string == null && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            string = facet.getInvalidValueText(frame, slot, object);
        }
        return string;
    }

    public synchronized KnowledgeBaseFactory getKnowledgeBaseFactory() {
        return this._knowledgeBaseFactory;
    }

    public synchronized Collection getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        Set set = facet == null ? (bl ? this.getHeadFrameStore().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n) : this.getHeadFrameStore().getFramesWithMatchingDirectOwnSlotValue(slot, string, n)) : this.getHeadFrameStore().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n);
        return set;
    }

    public synchronized String getName() {
        return this._name;
    }

    public synchronized int getNextFrameNumber() {
        return 0;
    }

    public synchronized Project getProject() {
        return this._project;
    }

    public synchronized Collection getReachableSimpleInstances(Collection collection) {
        HashSet hashSet = new HashSet();
        for (Instance instance : collection) {
            this.addReachableSimpleInstances(instance, hashSet);
        }
        return hashSet;
    }

    private void addReachableSimpleInstances(Instance instance, Collection collection) {
        if (!collection.contains(instance)) {
            collection.add(instance);
            for (Slot slot : this.getOwnSlots(instance)) {
                this.addInstances(instance, slot, collection);
            }
        }
    }

    private synchronized void addInstances(Instance instance, Slot slot, Collection collection) {
        if (instance.getOwnSlotValueType(slot) == ValueType.INSTANCE) {
            for (Instance instance2 : instance.getOwnSlotValues(slot)) {
                if (!(instance2 instanceof SimpleInstance)) continue;
                this.addReachableSimpleInstances(instance2, collection);
            }
        }
    }

    public synchronized Collection getReferences(Object object, int n) {
        return this.getHeadFrameStore().getReferences(object);
    }

    public synchronized Collection getMatchingReferences(String string, int n) {
        return this.getHeadFrameStore().getMatchingReferences(string, n);
    }

    public synchronized Collection getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        return this.getHeadFrameStore().getClsesWithMatchingBrowserText(string, collection, n);
    }

    public synchronized Cls getRootCls() {
        return this._systemFrames.getRootCls();
    }

    public synchronized Collection getRootClses() {
        return CollectionUtilities.createCollection(this.getRootCls());
    }

    public synchronized Cls getRootClsMetaCls() {
        return this._systemFrames.getRootClsMetaCls();
    }

    public synchronized Cls getRootFacetMetaCls() {
        return this._systemFrames.getRootFacetMetaCls();
    }

    public synchronized Cls getRootSlotMetaCls() {
        return this._systemFrames.getRootSlotMetaCls();
    }

    public synchronized Collection getRootSlots() {
        ArrayList arrayList = new ArrayList(this.getSlots());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (this.getDirectSuperslotCount(slot) <= 0) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public synchronized Slot getSlot(String string) {
        return (Slot)this.getFrameOfType(string, Slot.class);
    }

    public synchronized int getSlotCount() {
        return this.getHeadFrameStore().getSlotCount();
    }

    public synchronized Collection getSlots() {
        return this.getHeadFrameStore().getSlots();
    }

    public synchronized String getSlotValueLastModificationTimestamp(Frame frame, Slot slot, boolean bl) {
        return null;
    }

    public synchronized String getSlotValueLastModifier(Frame frame, Slot slot, boolean bl) {
        return null;
    }

    public synchronized Collection getSubclasses(Cls cls) {
        return this.getHeadFrameStore().getSubclasses(cls);
    }

    public synchronized Collection getUnreachableSimpleInstances(Collection collection) {
        HashSet hashSet = new HashSet(this.getFrames());
        hashSet.removeAll(this.getClses());
        hashSet.removeAll(this.getSlots());
        hashSet.removeAll(this.getFacets());
        hashSet.removeAll(this.getReachableSimpleInstances(collection));
        return hashSet;
    }

    public synchronized String getUserName() {
        return this._userName;
    }

    public synchronized String getVersionString() {
        return this._versionString;
    }

    public synchronized boolean hasChanged() {
        return this._frameStoreManager.hasChanged();
    }

    public synchronized boolean isAutoUpdatingFacetValues() {
        return false;
    }

    public synchronized boolean isClsMetaCls(Cls cls) {
        Cls cls2 = this.getRootClsMetaCls();
        return DefaultKnowledgeBase.equals(cls, cls2) || this.hasSuperclass(cls, cls2);
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public synchronized boolean isDefaultClsMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultClsMetaCls);
    }

    public synchronized boolean isDefaultFacetMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultFacetMetaCls);
    }

    public synchronized boolean isDefaultSlotMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultSlotMetaCls);
    }

    public synchronized boolean isFacetMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this.getRootFacetMetaCls());
    }

    public synchronized boolean isLoading() {
        return false;
    }

    public synchronized boolean isSlotMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this.getRootSlotMetaCls());
    }

    public synchronized boolean isValidOwnSlotValue(Frame frame, Slot slot, Object object) {
        boolean bl = true;
        Iterator iterator = this.getOwnSlotFacets(frame, slot).iterator();
        while (bl && iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            bl = facet.isValidValue(frame, slot, object);
        }
        return bl;
    }

    public synchronized void removeJavaLoadPackage(String string) {
        this._frameFactory.removeJavaPackage(string);
    }

    public synchronized void setAutoUpdateFacetValues(boolean bl) {
        this.setModificationRecordUpdatingEnabled(bl);
    }

    public synchronized boolean setModificationRecordUpdatingEnabled(boolean bl) {
        return this._frameStoreManager.setModificationRecordUpdatingEnabled(bl);
    }

    public synchronized void setBuildString(String string) {
        this._buildString = string;
    }

    public synchronized void setChanged(boolean bl) {
        this._frameStoreManager.setChanged(bl);
    }

    public synchronized Object setClientInformation(Object object, Object object2) {
        Object v = this._clientInformation.get(object);
        this._clientInformation.put(object, object2);
        return v;
    }

    public synchronized void setDefaultClsMetaCls(Cls cls) {
        if (cls == null || this.isClsMetaCls(cls)) {
            this._defaultClsMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a class meta class: " + cls);
        }
    }

    public synchronized void setDefaultFacetMetaCls(Cls cls) {
        if (cls == null || this.isFacetMetaCls(cls)) {
            this._defaultFacetMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a facet meta class: " + cls);
        }
    }

    public synchronized void setDefaultSlotMetaCls(Cls cls) {
        if (cls == null || this.isSlotMetaCls(cls)) {
            this._defaultSlotMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a slot meta class: " + cls);
        }
    }

    public synchronized void setFrameNamePrefix(String string) {
        this._frameNamePrefix = string;
    }

    public synchronized void setLoading(boolean bl) {
        this.setEventsEnabled(!bl);
    }

    public synchronized void setName(String string) {
        this._name = string;
    }

    public synchronized void setNextFrameNumber(int n) {
    }

    public synchronized void setProject(Project project) {
        this._project = project;
    }

    public synchronized void setUserName(String string) {
        this._userName = string;
        this._frameStoreManager.setAuthor(string);
    }

    public synchronized void setValueChecking(boolean bl) {
        this.setFacetCheckingEnabled(bl);
    }

    public synchronized boolean setFacetCheckingEnabled(boolean bl) {
        return this._frameStoreManager.setFacetCheckingEnabled(bl);
    }

    public synchronized void setVersionString(String string) {
        this._versionString = string;
    }

    public synchronized void dispose() {
        this._frameStoreManager.close();
        this._frameStoreManager = null;
        this._project = null;
    }

    public synchronized boolean isClosed() {
        return this._frameStoreManager != null;
    }

    public synchronized Collection getReachableSimpleInstances(Frame frame) {
        return this.getReachableSimpleInstances(CollectionUtilities.createCollection(frame));
    }

    public synchronized void addOwnSlotValue(Frame frame, Slot slot, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getDirectOwnSlotValues(frame, slot));
        arrayList.add(object);
        this.setDirectOwnSlotValues(frame, slot, arrayList);
    }

    public synchronized Collection getDocumentation(Frame frame) {
        return this.getOwnSlotValues(frame, this._systemFrames.getDocumentationSlot());
    }

    public synchronized boolean getOwnSlotAllowsMultipleValues(Frame frame, Slot slot) {
        Cls cls = ((Instance)frame).getDirectType();
        return this.getTemplateSlotAllowsMultipleValues(cls, slot);
    }

    public synchronized Collection getOwnSlotAndSubslotValues(Frame frame, Slot slot) {
        return this.getOwnSlotValues(frame, slot);
    }

    public synchronized Collection getOwnSlotDefaultValues(Frame frame, Slot slot) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Cls cls : ((Instance)frame).getDirectTypes()) {
            linkedHashSet.addAll(this.getTemplateSlotDefaultValues(cls, slot));
        }
        return linkedHashSet;
    }

    public synchronized Collection getOwnSlotFacets(Frame frame, Slot slot) {
        return this.getOwnFacets(frame, slot);
    }

    public synchronized Collection getOwnSlotFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getOwnFacetValues(frame, slot, facet);
    }

    public synchronized Collection getOwnFacets(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getOwnFacets(frame, slot);
    }

    public synchronized Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getOwnFacetValues(frame, slot, facet);
    }

    public synchronized Object getOwnSlotValue(Frame frame, Slot slot) {
        Collection collection = this.getOwnSlotValues(frame, slot);
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public synchronized int getOwnSlotValueCount(Frame frame, Slot slot) {
        return this.getOwnSlotValues(frame, slot).size();
    }

    public synchronized ValueType getOwnSlotValueType(Frame frame, Slot slot) {
        Collection collection = this.getOwnFacetValues(frame, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getType(collection);
    }

    public synchronized boolean hasOwnSlot(Frame frame, Slot slot) {
        return this.getOwnSlots(frame).contains(slot);
    }

    public synchronized void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        this.getHeadFrameStore().moveDirectOwnSlotValue(frame, slot, n, n2);
    }

    public synchronized void removeOwnSlotValue(Frame frame, Slot slot, Object object) {
        ArrayList arrayList = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
        arrayList.remove(object);
        this.setDirectOwnSlotValues(frame, slot, arrayList);
    }

    public synchronized void setDocumentation(Frame frame, String string) {
        this.setDirectOwnSlotValue(frame, this._systemFrames.getDocumentationSlot(), string);
    }

    public synchronized void setDocumentation(Frame frame, Collection collection) {
        this.setDirectOwnSlotValues(frame, this._systemFrames.getDocumentationSlot(), collection);
    }

    public synchronized void setOwnSlotValue(Frame frame, Slot slot, Object object) {
        this.setDirectOwnSlotValue(frame, slot, object);
    }

    public synchronized void setDirectOwnSlotValue(Frame frame, Slot slot, Object object) {
        Collection collection = CollectionUtilities.createCollection(object);
        this.setDirectOwnSlotValues(frame, slot, collection);
    }

    public synchronized void setOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.setDirectOwnSlotValues(frame, slot, collection);
    }

    public synchronized void notifyVisibilityChanged(Frame frame) {
    }

    public synchronized Slot getAssociatedSlot(Facet facet) {
        return (Slot)this.getOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot());
    }

    public synchronized void setAssociatedSlot(Facet facet, Slot slot) {
        this.setDirectOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot(), slot);
    }

    public synchronized void addDirectSuperclass(Cls cls, Cls cls2) {
        this.getHeadFrameStore().addDirectSuperclass(cls, cls2);
    }

    public synchronized void removeDirectSuperclass(Cls cls, Cls cls2) {
        this.getHeadFrameStore().removeDirectSuperclass(cls, cls2);
    }

    public synchronized void addDirectType(Instance instance, Cls cls) {
        this.getHeadFrameStore().addDirectType(instance, cls);
    }

    public synchronized void removeDirectType(Instance instance, Cls cls) {
        this.getHeadFrameStore().removeDirectType(instance, cls);
    }

    public synchronized void moveDirectType(Instance instance, Cls cls, int n) {
        this.getHeadFrameStore().moveDirectType(instance, cls, n);
    }

    public synchronized void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getHeadFrameStore().addDirectTemplateSlot(cls, slot);
    }

    public synchronized void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getHeadFrameStore().removeDirectTemplateSlot(cls, slot);
    }

    public synchronized void addTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getDirectTemplateFacetValues(cls, slot, facet));
        arrayList.add(object);
        this.setDirectTemplateFacetValues(cls, slot, facet, arrayList);
    }

    public synchronized void addTemplateSlotValue(Cls cls, Slot slot, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getHeadFrameStore().getDirectTemplateSlotValues(cls, slot));
        arrayList.add(object);
        this.setDirectTemplateSlotValues(cls, slot, arrayList);
    }

    public synchronized Slot getNameSlot() {
        return this._systemFrames.getNameSlot();
    }

    public synchronized int getDirectInstanceCount(Cls cls) {
        return this.getDirectInstances(cls).size();
    }

    public synchronized Collection getDirectInstances(Cls cls) {
        return this.getHeadFrameStore().getDirectInstances(cls);
    }

    public synchronized int getDirectSubclassCount(Cls cls) {
        return this.getHeadFrameStore().getDirectOwnSlotValuesCount(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    public synchronized Collection getDirectSubclasses(Cls cls) {
        return this.getHeadFrameStore().getDirectSubclasses(cls);
    }

    public synchronized int getDirectSuperclassCount(Cls cls) {
        return this.getDirectSuperclasses(cls).size();
    }

    public synchronized List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getDirectTemplateFacetValues(cls, slot, facet);
    }

    public synchronized Collection getDirectTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getDirectTemplateSlots(cls);
    }

    public synchronized List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getDirectTemplateSlotValues(cls, slot);
    }

    public synchronized int getInstanceCount(Cls cls) {
        return this.getInstances(cls).size();
    }

    public synchronized Collection getSuperclasses(Cls cls) {
        return this.getHeadFrameStore().getSuperclasses(cls);
    }

    public synchronized Collection getTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getTemplateFacets(cls, slot);
    }

    public synchronized Object getTemplateFacetValue(Cls cls, Slot slot, Facet facet) {
        Collection collection = this.getTemplateFacetValues(cls, slot, facet);
        return CollectionUtilities.getFirstItem(collection);
    }

    public synchronized Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getTemplateFacetValues(cls, slot, facet);
    }

    public synchronized Collection getTemplateSlotAllowedClses(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedClses(collection);
    }

    public synchronized Collection getTemplateSlotAllowedParents(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedParents(collection);
    }

    public synchronized Collection getTemplateSlotAllowedValues(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedValues(collection);
    }

    public synchronized boolean getTemplateSlotAllowsMultipleValues(Cls cls, Slot slot) {
        Integer n = this.getTemplateSlotMaximumCardinality2(cls, slot);
        return MaximumCardinalityConstraint.allowsMultipleValues(n);
    }

    public synchronized Collection getTemplateSlotDefaultValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getDefaultValuesFacet());
    }

    public synchronized Collection getTemplateSlotDocumentation(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getDocumentationFacet());
    }

    public synchronized int getTemplateSlotMaximumCardinality(Cls cls, Slot slot) {
        Integer n = this.getTemplateSlotMaximumCardinality2(cls, slot);
        return MaximumCardinalityConstraint.getValue(n);
    }

    public synchronized Integer getTemplateSlotMaximumCardinality2(Cls cls, Slot slot) {
        return (Integer)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet());
    }

    public synchronized Integer getTemplateSlotMinimumCardinality2(Cls cls, Slot slot) {
        return (Integer)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMinimumCardinalityFacet());
    }

    public synchronized Number getTemplateSlotMaximumValue(Cls cls, Slot slot) {
        return (Number)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMaximumValueFacet());
    }

    public synchronized int getTemplateSlotMinimumCardinality(Cls cls, Slot slot) {
        Integer n = this.getTemplateSlotMinimumCardinality2(cls, slot);
        return MinimumCardinalityConstraint.getValue(n);
    }

    public synchronized Number getTemplateSlotMinimumValue(Cls cls, Slot slot) {
        return (Number)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMinimumValueFacet());
    }

    public synchronized Object getTemplateSlotValue(Cls cls, Slot slot) {
        Collection collection = this.getTemplateSlotValues(cls, slot);
        return CollectionUtilities.getFirstItem(collection);
    }

    public synchronized Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getTemplateSlotValues(cls, slot);
    }

    public synchronized ValueType getTemplateSlotValueType(Cls cls, Slot slot) {
        Collection collection = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getType(collection);
    }

    public synchronized boolean hasDirectlyOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        List list = this.getDirectTemplateFacetValues(cls, slot, facet);
        return !list.isEmpty();
    }

    public synchronized boolean hasDirectlyOverriddenTemplateSlot(Cls cls, Slot slot) {
        return this.getDirectlyOverriddenTemplateSlots(cls).contains(slot);
    }

    public synchronized Collection getDirectlyOverriddenTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getDirectlyOverriddenTemplateSlots(cls);
    }

    public synchronized Collection getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getDirectlyOverriddenTemplateFacets(cls, slot);
    }

    public synchronized boolean hasDirectSuperslot(Slot slot, Slot slot2) {
        return this.getDirectSuperslots(slot).contains(slot2);
    }

    public synchronized boolean hasSuperslot(Slot slot, Slot slot2) {
        return this.getSuperslots(slot).contains(slot2);
    }

    public synchronized boolean hasDirectSuperclass(Cls cls, Cls cls2) {
        return this.getDirectSuperclasses(cls).contains(cls2);
    }

    public synchronized boolean hasDirectTemplateSlot(Cls cls, Slot slot) {
        return this.getDirectTemplateSlots(cls).contains(slot);
    }

    public synchronized boolean hasInheritedTemplateSlot(Cls cls, Slot slot) {
        return this.getInheritedTemplateSlots(cls).contains(slot);
    }

    public synchronized Collection getInheritedTemplateSlots(Cls cls) {
        HashSet hashSet = new HashSet(this.getTemplateSlots(cls));
        hashSet.removeAll(this.getDirectTemplateSlots(cls));
        return hashSet;
    }

    public synchronized boolean hasOverriddenTemplateSlot(Cls cls, Slot slot) {
        return this.getOverriddenTemplateSlots(cls).contains(slot);
    }

    public synchronized Collection getOverriddenTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getOverriddenTemplateSlots(cls);
    }

    public synchronized boolean hasOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        return this.getOverriddenTemplateFacets(cls, slot).contains(facet);
    }

    public synchronized Collection getOverriddenTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getOverriddenTemplateFacets(cls, slot);
    }

    public synchronized void removeTemplateFacetOverrides(Cls cls, Slot slot) {
        this.removeDirectTemplateFacetOverrides(cls, slot);
    }

    public synchronized void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getHeadFrameStore().removeDirectTemplateFacetOverrides(cls, slot);
    }

    public synchronized boolean hasSuperclass(Cls cls, Cls cls2) {
        return this.getSuperclasses(cls).contains(cls2);
    }

    public synchronized boolean hasTemplateSlot(Cls cls, Slot slot) {
        return this.getTemplateSlots(cls).contains(slot);
    }

    public synchronized boolean isAbstract(Cls cls) {
        String string = (String)this.getOwnSlotValue(cls, this._systemFrames.getRoleSlot());
        return RoleConstraint.isAbstract(string);
    }

    public synchronized boolean isMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this._systemFrames.getRootMetaCls());
    }

    public synchronized void moveDirectSubclass(Cls cls, Cls cls2, Cls cls3) {
        int n;
        ArrayList arrayList = new ArrayList(this.getDirectSubclasses(cls));
        int n2 = arrayList.indexOf(cls2);
        int n3 = n = cls3 == null ? 0 : arrayList.indexOf(cls3);
        if (n2 > n) {
            ++n;
        }
        this.moveDirectSubclass(cls, cls2, n);
    }

    public synchronized void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        this.getHeadFrameStore().moveDirectSubclass(cls, cls2, n);
    }

    public synchronized void moveDirectSubslot(Slot slot, Slot slot2, Slot slot3) {
        int n;
        ArrayList arrayList = new ArrayList(this.getDirectSubslots(slot));
        int n2 = arrayList.indexOf(slot2);
        int n3 = n = slot3 == null ? 0 : arrayList.indexOf(slot3);
        if (n2 > n) {
            ++n;
        }
        this.moveDirectSubslot(slot, slot2, n);
    }

    public synchronized void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        this.getHeadFrameStore().moveDirectSubslot(slot, slot2, n);
    }

    public synchronized void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        this.getHeadFrameStore().moveDirectTemplateSlot(cls, slot, n);
    }

    public synchronized void setAbstract(Cls cls, boolean bl) {
        String string = bl ? "Abstract" : "Concrete";
        this.setDirectOwnSlotValue(cls, this._systemFrames.getRoleSlot(), string);
    }

    public synchronized void setDirectTypeOfSubclasses(Cls cls, Cls cls2) {
        for (Cls cls3 : this.getSubclasses(cls)) {
            this.setDirectType(cls3, cls2);
        }
    }

    public synchronized void setTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object object) {
        this.setDirectTemplateFacetValue(cls, slot, facet, object);
    }

    public synchronized void setDirectTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object object) {
        Collection collection = CollectionUtilities.createCollection(object);
        this.setDirectTemplateFacetValues(cls, slot, facet, collection);
    }

    public synchronized void setTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        this.setDirectTemplateFacetValues(cls, slot, facet, collection);
    }

    public synchronized void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        if (facet.equals(this._systemFrames.getValueTypeFacet())) {
            this.setTemplateSlotValueTypeValues(cls, slot, collection);
        } else {
            this.getHeadFrameStore().setDirectTemplateFacetValues(cls, slot, facet, collection);
        }
    }

    private void setTemplateSlotValueTypeValues(Cls cls, Slot slot, ValueType valueType, Collection collection) {
        List list = ValueTypeConstraint.getValues(valueType, collection);
        this.setTemplateSlotValueTypeValues(cls, slot, list);
    }

    public synchronized void setTemplateSlotAllowedClses(Cls cls, Slot slot, Collection collection) {
        if (!collection.isEmpty()) {
            collection = ValueTypeConstraint.getValues(ValueType.INSTANCE, collection);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, collection);
    }

    public synchronized void setTemplateSlotAllowedParents(Cls cls, Slot slot, Collection collection) {
        if (!collection.isEmpty()) {
            collection = ValueTypeConstraint.getValues(ValueType.CLS, collection);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, collection);
    }

    public synchronized void setTemplateSlotAllowedValues(Cls cls, Slot slot, Collection collection) {
        if (!collection.isEmpty()) {
            collection = ValueTypeConstraint.getValues(ValueType.SYMBOL, collection);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, collection);
    }

    public synchronized void setTemplateSlotAllowsMultipleValues(Cls cls, Slot slot, boolean bl) {
        Integer n = MaximumCardinalityConstraint.getValue(bl);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet(), n);
    }

    public synchronized void setTemplateSlotDefaultValues(Cls cls, Slot slot, Collection collection) {
        this.setDirectTemplateFacetValues(cls, slot, this._systemFrames.getDefaultValuesFacet(), collection);
    }

    public synchronized void setTemplateSlotDocumentation(Cls cls, Slot slot, String string) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getDocumentationFacet(), string);
    }

    public synchronized void setTemplateSlotDocumentation(Cls cls, Slot slot, Collection collection) {
        this.setDirectTemplateFacetValues(cls, slot, this._systemFrames.getDocumentationFacet(), collection);
    }

    public synchronized void setTemplateSlotMaximumCardinality(Cls cls, Slot slot, int n) {
        Integer n2 = MaximumCardinalityConstraint.getValue(n);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet(), n2);
    }

    public synchronized void setTemplateSlotMaximumValue(Cls cls, Slot slot, Number number) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumValueFacet(), number);
    }

    public synchronized void setTemplateSlotMinimumCardinality(Cls cls, Slot slot, int n) {
        Integer n2 = MinimumCardinalityConstraint.getValue(n);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMinimumCardinalityFacet(), n2);
    }

    public synchronized void setTemplateSlotMinimumValue(Cls cls, Slot slot, Number number) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMinimumValueFacet(), number);
    }

    public synchronized void setTemplateSlotValue(Cls cls, Slot slot, Object object) {
        Collection collection = CollectionUtilities.createCollection(object);
        this.setDirectTemplateSlotValues(cls, slot, collection);
    }

    public synchronized void setTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.setDirectTemplateSlotValues(cls, slot, collection);
    }

    public synchronized void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.getHeadFrameStore().setDirectTemplateSlotValues(cls, slot, collection);
    }

    public synchronized void setTemplateSlotValueType(Cls cls, Slot slot, ValueType valueType) {
        if (!this.getTemplateSlotValueType(cls, slot).equals(valueType)) {
            this.setTemplateSlotValueTypeValues(cls, slot, valueType, Collections.EMPTY_LIST);
        }
    }

    public synchronized void addInstance(Instance instance, String string, Cls cls, boolean bl) {
    }

    public synchronized String getBrowserText(Instance instance) {
        String string;
        if (instance.isDeleted()) {
            string = "<<deleted>>";
        } else {
            Cls cls = instance.getDirectType();
            if (this._project == null) {
                string = this.getName(instance);
            } else if (cls == null) {
                string = this.getMissingTypeString(instance);
            } else {
                BrowserSlotPattern browserSlotPattern = this._project.getBrowserSlotPattern(cls);
                if (browserSlotPattern == null) {
                    string = this.getDisplaySlotNotSetString(instance);
                } else {
                    string = browserSlotPattern.getBrowserText(instance);
                    if (string == null) {
                        string = this.getDisplaySlotPatternValueNotSetString(instance, browserSlotPattern);
                    }
                }
            }
        }
        return string;
    }

    protected String getMissingTypeString(Instance instance) {
        return instance.getName();
    }

    protected String getDisplaySlotNotSetString(Instance instance) {
        return instance.getName();
    }

    protected String getDisplaySlotPatternValueNotSetString(Instance instance, BrowserSlotPattern browserSlotPattern) {
        return instance.getName();
    }

    protected String toString(BrowserSlotPattern browserSlotPattern) {
        return this.getBrowserText(browserSlotPattern.getFirstSlot());
    }

    protected String toString(Object object) {
        return object instanceof Frame ? this.toStringForFrame((Frame)object) : this.toStringForObject(object);
    }

    protected String toStringForFrame(Frame frame) {
        return frame.getBrowserText();
    }

    protected String toStringForObject(Object object) {
        return object.toString();
    }

    public synchronized Collection getDirectTypes(Instance instance) {
        return this.getHeadFrameStore().getDirectTypes(instance);
    }

    public synchronized boolean hasDirectType(Instance instance, Cls cls) {
        return this.getDirectTypes(instance).contains(cls);
    }

    public synchronized boolean hasType(Instance instance, Cls cls) {
        return this.getTypes(instance).contains(cls);
    }

    public synchronized Collection getTypes(Instance instance) {
        return this.getHeadFrameStore().getTypes(instance);
    }

    public synchronized Instance setDirectType(Instance instance, Cls cls) {
        Collection collection = CollectionUtilities.createCollection(cls);
        return this.setDirectTypes(instance, collection);
    }

    public synchronized Instance setDirectTypes(Instance instance, Collection collection) {
        ArrayList arrayList = new ArrayList(this.getDirectTypes(instance));
        ArrayList arrayList2 = new ArrayList(arrayList);
        arrayList2.removeAll(collection);
        ArrayList arrayList3 = new ArrayList(collection);
        arrayList3.removeAll(arrayList);
        this.addDirectTypes(instance, arrayList3);
        this.removeDirectTypes(instance, arrayList2);
        return instance;
    }

    public synchronized void addDirectTypes(Instance instance, Collection collection) {
        for (Cls cls : collection) {
            this.getHeadFrameStore().addDirectType(instance, cls);
        }
    }

    public synchronized void removeDirectTypes(Instance instance, Collection collection) {
        for (Cls cls : collection) {
            this.getHeadFrameStore().removeDirectType(instance, cls);
        }
    }

    public synchronized void addDirectSuperslot(Slot slot, Slot slot2) {
        this.getHeadFrameStore().addDirectSuperslot(slot, slot2);
    }

    public synchronized Collection getAllowedClses(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedClses(collection);
    }

    public synchronized Collection getAllowedParents(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedParents(collection);
    }

    public synchronized Collection getAllowedValues(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedValues(collection);
    }

    private Object getStandardSlotValue(Slot slot, Slot slot2) {
        Collection collection = this.getStandardSlotValues(slot, slot2);
        return CollectionUtilities.getFirstItem(collection);
    }

    private Collection getStandardSlotValues(Slot slot, Slot slot2) {
        Collection collection = this.getDirectOwnSlotValues(slot, slot2);
        if (collection.isEmpty()) {
            collection = this.getOwnSlotValues(slot, slot2);
        }
        return collection;
    }

    public synchronized boolean getAllowsMultipleValues(Slot slot) {
        Integer n = this.getMaximumCardinality2(slot);
        return MaximumCardinalityConstraint.allowsMultipleValues(n);
    }

    public synchronized Facet getAssociatedFacet(Slot slot) {
        Facet facet = null;
        Object object = this.getOwnSlotValue(slot, this._systemFrames.getAssociatedFacetSlot());
        if (object instanceof Facet) {
            facet = (Facet)object;
        } else if (object != null) {
            Log.getLogger().warning("Invalid facet: " + object);
        }
        return facet;
    }

    public synchronized Collection getDefaultValues(Slot slot) {
        return this.getOwnSlotValues(slot, this._systemFrames.getDefaultValuesSlot());
    }

    public synchronized int getDirectSubslotCount(Slot slot) {
        return this.getDirectSubslots(slot).size();
    }

    public synchronized Collection getDirectSubslots(Slot slot) {
        return this.getHeadFrameStore().getDirectSubslots(slot);
    }

    public synchronized Collection getDirectSuperslots(Slot slot) {
        return this.getHeadFrameStore().getDirectSuperslots(slot);
    }

    public synchronized int getDirectSuperslotCount(Slot slot) {
        return this.getDirectSuperslots(slot).size();
    }

    public synchronized Slot getInverseSlot(Slot slot) {
        return (Slot)this.getOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot());
    }

    public synchronized Integer getMaximumCardinality2(Slot slot) {
        return (Integer)this.getStandardSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot());
    }

    public synchronized int getMaximumCardinality(Slot slot) {
        Integer n = this.getMaximumCardinality2(slot);
        return MaximumCardinalityConstraint.getValue(n);
    }

    public synchronized Number getMaximumValue(Slot slot) {
        return (Number)this.getStandardSlotValue(slot, this._systemFrames.getMaximumValueSlot());
    }

    public synchronized int getMinimumCardinality(Slot slot) {
        Integer n = (Integer)this.getOwnSlotValue(slot, this._systemFrames.getMinimumCardinalitySlot());
        return MinimumCardinalityConstraint.getValue(n);
    }

    public synchronized Number getMinimumValue(Slot slot) {
        return (Number)this.getOwnSlotValue(slot, this._systemFrames.getMinimumValueSlot());
    }

    public synchronized Collection getSubslots(Slot slot) {
        return this.getHeadFrameStore().getSubslots(slot);
    }

    public synchronized Collection getSuperslots(Slot slot) {
        return this.getHeadFrameStore().getSuperslots(slot);
    }

    public synchronized Collection getDirectDomain(Slot slot) {
        return this.getHeadFrameStore().getDirectDomain(slot);
    }

    public synchronized Collection getDomain(Slot slot) {
        return this.getHeadFrameStore().getDomain(slot);
    }

    public synchronized Collection getValues(Slot slot) {
        return this.getOwnSlotValues(slot, this._systemFrames.getValuesSlot());
    }

    public synchronized ValueType getValueType(Slot slot) {
        Collection collection = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getType(collection);
    }

    public synchronized boolean hasSlotValueAtSomeFrame(Slot slot) {
        return false;
    }

    public synchronized void removeDirectSuperslot(Slot slot, Slot slot2) {
        this.getHeadFrameStore().removeDirectSuperslot(slot, slot2);
    }

    private void setValueTypeValues(Slot slot, ValueType valueType, Collection collection) {
        ValueType valueType2 = this.getValueType(slot);
        List list = ValueTypeConstraint.getValues(valueType, collection);
        this.getHeadFrameStore().setDirectOwnSlotValues(slot, this._systemFrames.getValueTypeSlot(), list);
        if (!DefaultKnowledgeBase.areComparableTypes(valueType2, valueType)) {
            this.setDefaultValues(slot, Collections.EMPTY_LIST);
            this.setValues(slot, Collections.EMPTY_LIST);
            this.clearValues(null, slot);
        }
    }

    private static boolean areComparableTypes(ValueType valueType, ValueType valueType2) {
        return DefaultKnowledgeBase.equals(valueType, valueType2) || DefaultKnowledgeBase.isFrameType(valueType) && DefaultKnowledgeBase.isFrameType(valueType2) || DefaultKnowledgeBase.isStringType(valueType) && DefaultKnowledgeBase.isStringType(valueType2) || valueType.equals(ValueType.ANY) || valueType2 == null;
    }

    private static boolean isFrameType(ValueType valueType) {
        return DefaultKnowledgeBase.equals(valueType, ValueType.CLS) || DefaultKnowledgeBase.equals(valueType, ValueType.INSTANCE);
    }

    private static boolean isStringType(ValueType valueType) {
        return DefaultKnowledgeBase.equals(valueType, ValueType.STRING) || DefaultKnowledgeBase.equals(valueType, ValueType.SYMBOL);
    }

    private void clearValues(Cls cls, Slot slot) {
        this.clearOwnSlotValues(cls, slot);
        this.clearTemplateSlotValues(cls, slot);
    }

    private void clearOwnSlotValues(Cls cls, Slot slot) {
        for (Frame frame : new ArrayList(this.getFramesWithAnyOwnSlotValue(slot))) {
            if (cls != null && !this.hasType((Instance)frame, cls)) continue;
            this.setOwnSlotValues(frame, slot, Collections.EMPTY_SET);
        }
    }

    private Collection getFramesWithAnyOwnSlotValue(Slot slot) {
        return this.getHeadFrameStore().getFramesWithAnyDirectOwnSlotValue(slot);
    }

    private Collection getClsesWithAnyTemplateSlotValue(Slot slot) {
        return this.getHeadFrameStore().getClsesWithAnyDirectTemplateSlotValue(slot);
    }

    private void clearTemplateSlotValues(Cls cls, Slot slot) {
        for (Cls cls2 : new ArrayList(this.getClsesWithAnyTemplateSlotValue(slot))) {
            if (cls != null && !this.hasSuperclass(cls2, cls)) continue;
            this.setTemplateSlotValues(cls2, slot, Collections.EMPTY_SET);
        }
    }

    private void setTemplateSlotValueTypeValues(Cls cls, Slot slot, Collection collection) {
        ValueType valueType = this.getTemplateSlotValueType(cls, slot);
        ValueType valueType2 = collection.isEmpty() ? null : ValueTypeConstraint.getType(collection);
        this.getHeadFrameStore().setDirectTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet(), collection);
        if (!DefaultKnowledgeBase.areComparableTypes(valueType, valueType2)) {
            this.setTemplateSlotDefaultValues(cls, slot, Collections.EMPTY_LIST);
            this.setTemplateSlotValues(cls, slot, Collections.EMPTY_LIST);
            this.clearValues(cls, slot);
        }
    }

    public synchronized void setAllowedClses(Slot slot, Collection collection) {
        this.setValueTypeValues(slot, ValueType.INSTANCE, collection);
    }

    public synchronized void setAllowedParents(Slot slot, Collection collection) {
        this.setValueTypeValues(slot, ValueType.CLS, collection);
    }

    public synchronized void setAllowedValues(Slot slot, Collection collection) {
        this.setValueTypeValues(slot, ValueType.SYMBOL, collection);
    }

    public synchronized void setAllowsMultipleValues(Slot slot, boolean bl) {
        Integer n = MaximumCardinalityConstraint.getValue(bl);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot(), n);
    }

    public synchronized void setAssociatedFacet(Slot slot, Facet facet) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getAssociatedFacetSlot(), facet);
    }

    public synchronized void setDefaultValues(Slot slot, Collection collection) {
        this.setDirectOwnSlotValues(slot, this._systemFrames.getDefaultValuesSlot(), collection);
    }

    public synchronized void setDirectTypeOfSubslots(Slot slot, Cls cls) {
        for (Slot slot2 : this.getSubslots(slot)) {
            this.setDirectType(slot2, cls);
        }
    }

    public synchronized void setInverseSlot(Slot slot, Slot slot2) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot(), slot2);
    }

    public synchronized void setMaximumCardinality(Slot slot, int n) {
        Integer n2 = MaximumCardinalityConstraint.getValue(n);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot(), n2);
    }

    public synchronized void setMaximumValue(Slot slot, Number number) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumValueSlot(), number);
    }

    public synchronized void setMinimumCardinality(Slot slot, int n) {
        Integer n2 = MinimumCardinalityConstraint.getValue(n);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMinimumCardinalitySlot(), n2);
    }

    public synchronized void setMinimumValue(Slot slot, Number number) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMinimumValueSlot(), number);
    }

    public synchronized void setValues(Slot slot, Collection collection) {
        this.setDirectOwnSlotValues(slot, this._systemFrames.getValuesSlot(), collection);
    }

    public synchronized void setValueType(Slot slot, ValueType valueType) {
        if (!this.getValueType(slot).equals(valueType)) {
            this.setValueTypeValues(slot, valueType, Collections.EMPTY_LIST);
        }
    }

    public synchronized void addFrameListener(Frame frame, FrameListener frameListener) {
        this.addListener(FrameListener.class, frame, frameListener);
    }

    public synchronized void addFrameListener(FrameListener frameListener) {
        this.addFrameListener(null, frameListener);
    }

    public synchronized void removeFrameListener(Frame frame, FrameListener frameListener) {
        this.removeListener(FrameListener.class, frame, frameListener);
    }

    public synchronized void removeFrameListener(FrameListener frameListener) {
        this.removeFrameListener(null, frameListener);
    }

    public synchronized void addSlotListener(Slot slot, SlotListener slotListener) {
        this.addListener(SlotListener.class, slot, slotListener);
    }

    public synchronized void addSlotListener(SlotListener slotListener) {
        this.addSlotListener(null, slotListener);
    }

    public synchronized void removeSlotListener(Slot slot, SlotListener slotListener) {
        this.removeListener(SlotListener.class, slot, slotListener);
    }

    public synchronized void removeSlotListener(SlotListener slotListener) {
        this.removeSlotListener(null, slotListener);
    }

    public synchronized void addInstanceListener(Instance instance, InstanceListener instanceListener) {
        this.addListener(InstanceListener.class, instance, instanceListener);
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.addInstanceListener(null, instanceListener);
    }

    public synchronized void removeInstanceListener(Instance instance, InstanceListener instanceListener) {
        this.removeListener(InstanceListener.class, instance, instanceListener);
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.removeInstanceListener(null, instanceListener);
    }

    public synchronized void addClsListener(ClsListener clsListener) {
        this.addClsListener(null, clsListener);
    }

    public synchronized void addClsListener(Cls cls, ClsListener clsListener) {
        this.addListener(ClsListener.class, cls, clsListener);
    }

    public synchronized void removeClsListener(Cls cls, ClsListener clsListener) {
        this.removeListener(ClsListener.class, cls, clsListener);
    }

    public synchronized void removeClsListener(ClsListener clsListener) {
        this.removeClsListener(null, clsListener);
    }

    public synchronized void addKnowledgeBaseListener(KnowledgeBaseListener knowledgeBaseListener) {
        this.addListener(KnowledgeBaseListener.class, this, knowledgeBaseListener);
    }

    public synchronized void removeKnowledgeBaseListener(KnowledgeBaseListener knowledgeBaseListener) {
        this.removeListener(KnowledgeBaseListener.class, this, knowledgeBaseListener);
    }

    public synchronized void addFacetListener(Facet facet, FacetListener facetListener) {
        this.addListener(FacetListener.class, this, facetListener);
    }

    public synchronized void addFacetListener(FacetListener facetListener) {
        this.addFacetListener(null, facetListener);
    }

    public synchronized void removeFacetListener(Facet facet, FacetListener facetListener) {
        this.removeListener(FacetListener.class, facet, facetListener);
    }

    public synchronized void removeFacetListener(FacetListener facetListener) {
        this.removeFacetListener(null, facetListener);
    }

    private void addListener(Class clazz, Object object, EventListener eventListener) {
        this._frameStoreManager.addListener(clazz, object, eventListener);
    }

    private void removeListener(Class clazz, Object object, EventListener eventListener) {
        this._frameStoreManager.removeListener(clazz, object, eventListener);
    }

    public synchronized String toString() {
        return StringUtilities.getClassName(this) + "(" + this.getName() + ")";
    }

    public synchronized Collection getCurrentUsers() {
        return Collections.EMPTY_LIST;
    }

    public synchronized boolean beginTransaction(String string) {
        return this.getHeadFrameStore().beginTransaction(string);
    }

    public synchronized boolean commitTransaction() {
        return this.getHeadFrameStore().commitTransaction();
    }

    public synchronized boolean rollbackTransaction() {
        return this.getHeadFrameStore().rollbackTransaction();
    }

    public synchronized boolean endTransaction(boolean bl) {
        boolean bl2 = bl ? this.commitTransaction() : !this.rollbackTransaction();
        return bl2;
    }

    public synchronized void setFrameFactory(FrameFactory frameFactory) {
        this._frameFactory = frameFactory;
    }

    public CommandManager getCommandManager() {
        return this.getUndoFrameStore();
    }

    public synchronized void setFrameNameValidator(FrameNameValidator frameNameValidator) {
        this._frameNameValidator = frameNameValidator;
    }

    public synchronized boolean isValidFrameName(String string, Frame frame) {
        return this._frameNameValidator == null ? true : this._frameNameValidator.isValid(string, frame);
    }

    public synchronized String getInvalidFrameNameDescription(String string, Frame frame) {
        String string2 = null;
        if (this._frameNameValidator != null) {
            string2 = this._frameNameValidator.getErrorMessage(string, frame);
        }
        return string2;
    }

    public synchronized void setPollForEvents(boolean bl) {
        this._frameStoreManager.setPollForEvents(bl);
    }

    public synchronized void setDirectBrowserSlot(Cls cls, Slot slot) {
        this.setDirectBrowserSlotPattern(cls, new BrowserSlotPattern(slot));
    }

    public synchronized void setDirectBrowserSlotPattern(Cls cls, BrowserSlotPattern browserSlotPattern) {
        this.getProject().setDirectBrowserSlotPattern(cls, browserSlotPattern);
        this._frameStoreManager.notifyInstancesOfBrowserTextChange(cls);
    }

    public synchronized void removeFrameStore(FrameStore frameStore) {
        this._frameStoreManager.removeFrameStore(frameStore);
    }

    public synchronized void insertFrameStore(FrameStore frameStore) {
        this._frameStoreManager.insertFrameStore(frameStore);
    }

    public synchronized void insertFrameStore(FrameStore frameStore, int n) {
        this._frameStoreManager.insertFrameStore(frameStore, n);
    }

    public synchronized List getFrameStores() {
        return this._frameStoreManager.getFrameStores();
    }

    public synchronized void setTerminalFrameStore(FrameStore frameStore) {
        this._frameStoreManager.setTerminalFrameStore(frameStore);
    }

    public synchronized FrameStore getTerminalFrameStore() {
        return this._frameStoreManager.getTerminalFrameStore();
    }

    public synchronized void clearAllListeners() {
        this._frameStoreManager.clearAllListeners();
    }

    public synchronized FrameCounts getFrameCounts() {
        return this.getProject().getFrameCounts();
    }

    public BrowserSlotPattern getDirectBrowserSlotPattern(Cls cls) {
        return this.getProject().getDirectBrowserSlotPattern(cls);
    }

    public void setDirectBrowserTextPattern(Cls cls, BrowserSlotPattern browserSlotPattern) {
        this.getProject().setDirectBrowserSlotPattern(cls, browserSlotPattern);
    }

    public synchronized Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getDirectOwnSlotValuesClosure(frame, slot);
    }

    public boolean getValueChecking() {
        return this.getFacetCheckingEnabled();
    }

    public synchronized boolean getFacetCheckingEnabled() {
        return this._frameStoreManager.getFacetCheckingEnabled();
    }

    public void startJournaling(URI uRI) {
        this._frameStoreManager.startJournaling(uRI);
    }

    public void stopJournaling() {
        this._frameStoreManager.stopJournaling();
    }

    public synchronized boolean setGenerateDeletingFrameEventsEnabled(boolean bl) {
        return this._frameStoreManager.setGenerateDeletingFrameEventsEnabled(bl);
    }

    public synchronized void flushCache() {
        this.getFrameStoreManager().reinitialize();
    }

    public synchronized Cls getReifiedRelationCls() {
        return this._systemFrames.getRelationCls();
    }

    public synchronized Slot getReifedRelationFromSlot() {
        return this._systemFrames.getFromSlot();
    }

    public synchronized Slot getReifedRelationToSlot() {
        return this._systemFrames.getToSlot();
    }

    public synchronized void addTransactionListener(TransactionListener transactionListener) {
        this.addListener(TransactionListener.class, this, transactionListener);
    }

    public synchronized void removeTransactionListener(TransactionListener transactionListener) {
        this.removeListener(TransactionListener.class, this, transactionListener);
    }
}

