/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore_Test;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import java.util.EventObject;
import java.util.List;

public class EventGeneratorFrameStore_Test
extends FrameStore_Test {
    private KnowledgeBase _kb;

    protected FrameStore createFrameStore(DefaultKnowledgeBase defaultKnowledgeBase) {
        this._kb = defaultKnowledgeBase;
        EventGeneratorFrameStore eventGeneratorFrameStore = new EventGeneratorFrameStore(defaultKnowledgeBase);
        eventGeneratorFrameStore.setDelegate(new InMemoryFrameStore(defaultKnowledgeBase));
        return eventGeneratorFrameStore;
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this._kb = null;
    }

    public void testCreateClsEvent() {
        Cls cls = this._kb.getRootCls();
        Cls cls2 = this._kb.getCls(":STANDARD-CLASS");
        Slot slot = this._kb.getSlot(":DIRECT-SUBCLASSES");
        Slot slot2 = this._kb.getSlot(":DIRECT-INSTANCES");
        Cls cls3 = this.createCls();
        List<EventObject> list = this.getTestFrameStore().getEvents();
        EventGeneratorFrameStore_Test.assertTrue((boolean)list.contains(new KnowledgeBaseEvent(this._kb, 601, cls3)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)list.contains(new ClsEvent(cls, 303, (Object)cls3)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)list.contains(new FrameEvent(cls, 110, (Object)slot)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)list.contains(new ClsEvent(cls2, 305, (Object)cls3)));
        EventGeneratorFrameStore_Test.assertTrue((boolean)list.contains(new FrameEvent(cls2, 110, (Object)slot2, null)));
    }

    public void testAddSuperclassEvent() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        this.getTestFrameStore().getEvents();
        this.getTestFrameStore().addDirectSuperclass(cls, cls2);
        List<EventObject> list = this.getTestFrameStore().getEvents();
        ClsEvent clsEvent = new ClsEvent(cls, 301, (Object)cls2);
        ClsEvent clsEvent2 = new ClsEvent(cls2, 303, (Object)cls);
        EventGeneratorFrameStore_Test.assertEquals((String)"kb event", (Object)clsEvent, (Object)list.get(0));
        EventGeneratorFrameStore_Test.assertEquals((String)"kb event", (Object)clsEvent2, (Object)list.get(1));
    }

    public void testDeleteClsEvents() {
        Cls cls = this.createCls();
        KnowledgeBaseEvent knowledgeBaseEvent = new KnowledgeBaseEvent(this._kb, 602, cls, (Object)cls.getName());
        this.getTestFrameStore().getEvents();
        this.getTestFrameStore().deleteCls(cls);
        List<EventObject> list = this.getTestFrameStore().getEvents();
        EventGeneratorFrameStore_Test.assertTrue((boolean)list.contains(knowledgeBaseEvent));
    }
}

