/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.IncludedFrameLookup;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.Tree;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludedFrameLookupImpl
implements IncludedFrameLookup {
    Slot nameSlot;
    Collection<NarrowFrameStore> stores;
    Map<Integer, NarrowFrameStore> frameStoreMap;

    public IncludedFrameLookupImpl(Slot slot, NarrowFrameStore narrowFrameStore, Tree<NarrowFrameStore> tree) {
        this.nameSlot = slot;
        this.stores = tree.getDescendents(narrowFrameStore);
        this.fillFrameStoreMap();
    }

    private void fillFrameStoreMap() {
        this.frameStoreMap = new HashMap<Integer, NarrowFrameStore>();
        for (NarrowFrameStore narrowFrameStore : this.stores) {
            FrameID frameID = narrowFrameStore.generateFrameID();
            int n = frameID.getMemoryProjectPart();
            this.frameStoreMap.put(new Integer(n), narrowFrameStore);
        }
    }

    @Override
    public Slot getNameSlot() {
        return this.nameSlot;
    }

    @Override
    public boolean isEmpty() {
        return this.stores.isEmpty();
    }

    @Override
    public String getInherittedFrameName(Frame frame) {
        if (frame == null) {
            return null;
        }
        int n = frame.getFrameID().getMemoryProjectPart();
        NarrowFrameStore narrowFrameStore = this.frameStoreMap.get(new Integer(n));
        if (narrowFrameStore == null) {
            return null;
        }
        for (Object e : narrowFrameStore.getValues(frame, this.getNameSlot(), null, false)) {
            if (!(e instanceof String)) continue;
            return (String)e;
        }
        return null;
    }

    @Override
    public Frame getInheritedFrame(String string) {
        for (NarrowFrameStore narrowFrameStore : this.stores) {
            Set<Frame> set = narrowFrameStore.getFrames(this.nameSlot, null, false, string);
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) continue;
            Frame frame = (Frame)iterator.next();
            return frame;
        }
        return null;
    }

    @Override
    public Frame getInheritedFrame(FrameID frameID) {
        int n = frameID.getMemoryProjectPart();
        NarrowFrameStore narrowFrameStore = this.frameStoreMap.get(new Integer(n));
        if (narrowFrameStore != null) {
            return narrowFrameStore.getFrame(frameID);
        }
        return null;
    }
}

