/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.AbstractFormatter;
import edu.stanford.smi.protege.util.ApplicationProperties;
import java.lang.reflect.Method;
import java.util.logging.LogRecord;

public class JournalFormater
extends AbstractFormatter {
    private final String appUsername = ApplicationProperties.getUserName();

    private String getUsername() {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        return remoteSession == null ? this.appUsername : remoteSession.getUserName();
    }

    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JournalFormater.getDateString());
        stringBuffer.append(" ");
        stringBuffer.append(this.getUsername());
        stringBuffer.append(" - ");
        Object[] objectArray = logRecord.getParameters();
        Method method = (Method)objectArray[0];
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        for (int i = 1; i < objectArray.length - 1; ++i) {
            Object object = objectArray[i];
            if (i != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(JournalFormater.toString(object));
        }
        stringBuffer.append(") returns ");
        Object object = objectArray[objectArray.length - 1];
        stringBuffer.append(JournalFormater.toString(object));
        stringBuffer.append(JournalFormater.getLineSeparator());
        return stringBuffer.toString();
    }
}

