/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteClientProject;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.StatusBar;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;

public class RemoteProjectUtil {
    private static Thread thread;
    private static final int DELAY_MSEC = 2000;

    public static void configure(ProjectView projectView) {
        StatusBar statusBar = new StatusBar();
        projectView.add((Component)statusBar, "South");
        RemoteProjectUtil.createUpdateThread((RemoteClientProject)projectView.getProject(), statusBar);
    }

    public static void dispose(ProjectView projectView) {
        thread = null;
    }

    private static void createUpdateThread(final RemoteClientProject remoteClientProject, final StatusBar statusBar) {
        thread = new Thread("Status Bar Updater"){

            public void run() {
                try {
                    while (thread == this) {
                        try {
                            1.sleep(2000L);
                            RemoteProjectUtil.updateStatus(remoteClientProject, statusBar);
                        }
                        catch (InterruptedException interruptedException) {
                            Log.getLogger().log(Level.INFO, "Exception caught", interruptedException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static void updateStatus(RemoteClientProject remoteClientProject, StatusBar statusBar) {
        ArrayList arrayList = new ArrayList(remoteClientProject.getCurrentUsers());
        arrayList.remove(remoteClientProject.getLocalUser());
        String string = StringUtilities.commaSeparatedList(arrayList);
        String string2 = string.length() == 0 ? "No other users" : "Other users: " + string;
        statusBar.setText(string2);
    }
}

