/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalizeFrameStoreHandler
extends AbstractFrameStoreInvocationHandler {
    private static transient Logger log = Log.getLogger(LocalizeFrameStoreHandler.class);
    private int counter = 0;
    private KnowledgeBase _kb;

    public LocalizeFrameStoreHandler(KnowledgeBase knowledgeBase) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering the Localize constructor");
        }
        this._kb = knowledgeBase;
    }

    protected Object handleInvoke(Method method, Object[] objectArray) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Received Remote Invocation of " + method);
            log.fine("Count = " + ++this.counter);
        }
        this.localize(objectArray);
        return this.invoke(method, objectArray);
    }

    private void localize(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                LocalizeUtils.localize(object, this._kb);
            }
        }
    }

    public FrameStore newFrameStore() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class[] classArray = new Class[]{FrameStore.class};
        return (FrameStore)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)this);
    }
}

