/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.clips.ClipsUtil;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public abstract class ClipsFileWriter {
    private PrintWriter _writer;

    protected ClipsFileWriter(Writer writer) {
        this._writer = new PrintWriter(writer);
        this.printVersion();
    }

    public void flush() {
        this._writer.flush();
    }

    public void print(int n) {
        this._writer.print(n);
    }

    public void print(String string) {
        this._writer.print(string);
    }

    public void printFrame(Frame frame) {
        this._writer.print(ClipsFileWriter.toExternalFrameName(frame));
    }

    public void printFrameName(String string) {
        this._writer.print(ClipsFileWriter.toExternalFrameName(string));
    }

    public void println() {
        this._writer.println();
    }

    public void println(String string) {
        this._writer.println(string);
    }

    public boolean printSucceeded() {
        return !this._writer.checkError();
    }

    private void printVersion() {
        this.println("; " + new Date().toString());
        this.println("; ");
        this.println(";+ (version \"" + Text.getVersion() + "\")");
        this.println(";+ (build \"" + Text.getBuildInfo() + "\")");
    }

    public static String toExternalFrameName(Frame frame) {
        return ClipsFileWriter.toExternalFrameName(frame.getName());
    }

    public static String toExternalFrameName(String string) {
        return ClipsUtil.toExternalSymbol(string);
    }

    protected static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }
}

