/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.AbstractKnowledgeBaseFactory;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.clips.ClipsFileWriter;
import edu.stanford.smi.protege.storage.clips.ClsStorer;
import edu.stanford.smi.protege.storage.clips.FileSourcesPanel;
import edu.stanford.smi.protege.storage.clips.InstanceStorer;
import edu.stanford.smi.protege.storage.clips.Parser;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;

public class ClipsKnowledgeBaseFactory
extends AbstractKnowledgeBaseFactory {
    public static final String DESCRIPTION = Text.getProgramName() + " Files (.pont and .pins)";
    private static final String CLSES_FILE_NAME = "classes_file_name";
    private static final String INSTANCES_FILE_NAME = "instances_file_name";

    public KnowledgeBase createKnowledgeBase(Collection collection) {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase(this);
        return defaultKnowledgeBase;
    }

    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String string, PropertyList propertyList) {
        return new FileSourcesPanel(string, propertyList);
    }

    public static String getClsesSourceFile(PropertyList propertyList) {
        return propertyList.getString(CLSES_FILE_NAME);
    }

    public static URI getClsesSourceRelativeURI(PropertyList propertyList) {
        return URIUtilities.createURI(ClipsKnowledgeBaseFactory.getClsesSourceFile(propertyList));
    }

    public Reader getClsesSourceReader(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = ClipsKnowledgeBaseFactory.getClsesSourceFile(propertyList);
        return string == null ? null : this.createReader(knowledgeBase, string, collection);
    }

    public Reader getInstancesSourceReader(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = ClipsKnowledgeBaseFactory.getInstancesSourceFile(propertyList);
        return string == null ? null : this.createReader(knowledgeBase, string, collection);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public static String getInstancesSourceFile(PropertyList propertyList) {
        return propertyList.getString(INSTANCES_FILE_NAME);
    }

    public static URI getInstancesSourceRelativeURI(PropertyList propertyList) {
        return URIUtilities.createURI(ClipsKnowledgeBaseFactory.getInstancesSourceFile(propertyList));
    }

    public boolean isComplete(PropertyList propertyList) {
        return true;
    }

    protected void loadKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, boolean bl, Collection collection) {
        Reader reader = this.getClsesSourceReader(knowledgeBase, propertyList, collection);
        Reader reader2 = this.getInstancesSourceReader(knowledgeBase, propertyList, collection);
        this.loadKnowledgeBase(knowledgeBase, reader, reader2, bl, collection);
        this.close(reader);
        this.close(reader2);
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, Reader reader, Reader reader2, boolean bl, Collection collection) {
        Parser parser;
        boolean bl2 = knowledgeBase.setCallCachingEnabled(false);
        boolean bl3 = knowledgeBase.setGenerateEventsEnabled(false);
        if (reader != null) {
            parser = new Parser(reader);
            parser.loadClses(knowledgeBase, bl, collection);
        }
        if (reader2 != null) {
            parser = new Parser(reader2);
            parser.loadInstances(knowledgeBase, bl, collection);
        }
        knowledgeBase.setGenerateEventsEnabled(bl3);
        knowledgeBase.setCallCachingEnabled(bl2);
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, String string, String string2, boolean bl, Collection collection) {
        BufferedReader bufferedReader = this.createReader(knowledgeBase, string, collection);
        BufferedReader bufferedReader2 = this.createReader(knowledgeBase, string2, collection);
        this.loadKnowledgeBase(knowledgeBase, bufferedReader, bufferedReader2, bl, collection);
        FileUtilities.close(bufferedReader);
        FileUtilities.close(bufferedReader2);
    }

    public KnowledgeBase loadKnowledgeBase(Reader reader, Reader reader2, Collection collection) {
        KnowledgeBase knowledgeBase = this.createKnowledgeBase(collection);
        this.loadKnowledgeBase(knowledgeBase, reader, reader2, false, collection);
        return knowledgeBase;
    }

    public KnowledgeBase loadKnowledgeBase(String string, String string2, Collection collection) {
        KnowledgeBase knowledgeBase = this.createKnowledgeBase(collection);
        this.loadKnowledgeBase(knowledgeBase, string, string2, false, collection);
        return knowledgeBase;
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string;
        boolean bl = false;
        String string2 = knowledgeBase.getProject().getProjectName();
        String string3 = ClipsKnowledgeBaseFactory.getClsesSourceFile(propertyList);
        if (string3 == null) {
            string3 = string2 + ".pont";
            bl = true;
        }
        if ((string = ClipsKnowledgeBaseFactory.getInstancesSourceFile(propertyList)) == null) {
            string = string2 + ".pins";
            bl = true;
        }
        if (bl) {
            ClipsKnowledgeBaseFactory.setSourceFiles(propertyList, string3, string);
        }
        this.saveKnowledgeBase(knowledgeBase, string3, string, collection);
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, Writer writer, Writer writer2, Collection collection) {
        ClipsFileWriter clipsFileWriter;
        if (writer != null) {
            clipsFileWriter = new ClsStorer(writer);
            ((ClsStorer)clipsFileWriter).storeClses(knowledgeBase, collection);
        }
        if (writer2 != null) {
            clipsFileWriter = new InstanceStorer(writer2);
            ((InstanceStorer)clipsFileWriter).storeInstances(knowledgeBase, collection);
        }
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, String string, String string2, Collection collection) {
        BufferedWriter bufferedWriter = null;
        BufferedWriter bufferedWriter2 = null;
        try {
            File file = this.createTempFile(knowledgeBase, string);
            File file2 = this.createTempFile(knowledgeBase, string2);
            bufferedWriter = this.createWriter(file);
            bufferedWriter2 = this.createWriter(file2);
            this.saveKnowledgeBase(knowledgeBase, bufferedWriter, bufferedWriter2, collection);
            this.close(bufferedWriter);
            this.close(bufferedWriter2);
            if (collection.isEmpty()) {
                this.makeTempFilePermanent(file);
                this.makeTempFilePermanent(file2);
            }
        }
        catch (Exception exception) {
            collection.add(exception);
            this.close(bufferedWriter);
            this.close(bufferedWriter2);
        }
    }

    public static void setSourceFiles(PropertyList propertyList, String string, String string2) {
        ClipsKnowledgeBaseFactory.setProperty(propertyList, CLSES_FILE_NAME, string);
        ClipsKnowledgeBaseFactory.setProperty(propertyList, INSTANCES_FILE_NAME, string2);
    }

    public static void setSourceURIs(PropertyList propertyList, URI uRI, URI uRI2) {
        Assert.assertTrue("Classes uri", uRI == null || !uRI.isAbsolute());
        Assert.assertTrue("Instances uri", uRI2 == null || !uRI2.isAbsolute());
        ClipsKnowledgeBaseFactory.setSourceFiles(propertyList, ClipsKnowledgeBaseFactory.toString(uRI), ClipsKnowledgeBaseFactory.toString(uRI2));
    }

    private static String toString(URI uRI) {
        return uRI == null ? null : uRI.toString();
    }

    private static void setProperty(PropertyList propertyList, String string, String string2) {
        propertyList.setString(string, string2);
    }
}

