/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;

public class CardinalityFacetRenderer
extends DefaultRenderer {
    private Facet _minCardinalityFacet;
    private Facet _maxCardinalityFacet;

    public CardinalityFacetRenderer(KnowledgeBase knowledgeBase) {
        this._minCardinalityFacet = knowledgeBase.getFacet(":MINIMUM-CARDINALITY");
        this._maxCardinalityFacet = knowledgeBase.getFacet(":MAXIMUM-CARDINALITY");
    }

    private static Integer getFacetValue(Cls cls, Slot slot, Facet facet) {
        return (Integer)CollectionUtilities.getFirstItem(cls.getTemplateFacetValues(slot, facet));
    }

    public void load(Object object) {
        FrameSlotCombination frameSlotCombination = (FrameSlotCombination)object;
        Cls cls = (Cls)frameSlotCombination.getFrame();
        Slot slot = frameSlotCombination.getSlot();
        StringBuffer stringBuffer = new StringBuffer();
        Integer n = CardinalityFacetRenderer.getFacetValue(cls, slot, this._minCardinalityFacet);
        int n2 = 0;
        if (n != null) {
            stringBuffer.append("required ");
            n2 = n;
        }
        Integer n3 = CardinalityFacetRenderer.getFacetValue(cls, slot, this._maxCardinalityFacet);
        int n4 = 0;
        if (n3 == null) {
            stringBuffer.append("multiple");
        } else {
            n4 = n3;
            if (n4 == 0) {
                stringBuffer.append("none");
            } else if (n4 == 1) {
                stringBuffer.append("single");
            } else {
                stringBuffer.append("multiple");
            }
        }
        if (n2 > 1 || n4 > 1) {
            stringBuffer.append("   (");
            stringBuffer.append(n2);
            stringBuffer.append(":");
            if (n4 == 0) {
                stringBuffer.append("*");
            } else {
                stringBuffer.append(n4);
            }
            stringBuffer.append(")");
        }
        this.setMainText(stringBuffer.toString());
        this.setGrayedText(!cls.isEditable());
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }
}

