/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class ReferenceNode
extends LazyTreeNode {
    private Slot _slot;
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            ReferenceNode.this.reload();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void nameChanged(FrameEvent frameEvent) {
            ReferenceNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            ReferenceNode.this.reload();
        }

        public void visibilityChanged(FrameEvent frameEvent) {
            ReferenceNode.this.notifyNodeChanged();
        }
    };

    public ReferenceNode(LazyTreeNode lazyTreeNode, Frame frame, Slot slot) {
        super(lazyTreeNode, frame);
        this._slot = slot;
        frame.addFrameListener(this._frameListener);
        if (frame instanceof Cls) {
            ((Cls)frame).addClsListener(this._clsListener);
        }
    }

    private static void addOwnSlotReferences(Frame frame, Slot slot, Collection collection) {
        ValueType valueType;
        if (frame.hasOwnSlot(slot) && ((valueType = frame.getOwnSlotValueType(slot)).equals(ValueType.INSTANCE) || valueType.equals(ValueType.CLS))) {
            collection.addAll(frame.getOwnSlotValues(slot));
        }
    }

    private static void addReferences(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof Cls) {
            Cls cls = (Cls)frame;
            ReferenceNode.addTemplateSlotReferences(cls, slot, collection);
        }
        ReferenceNode.addOwnSlotReferences(frame, slot, collection);
    }

    private static void addTemplateSlotReferences(Cls cls, Slot slot, Collection collection) {
        if (cls.hasTemplateSlot(slot)) {
            ValueType valueType = cls.getTemplateSlotValueType(slot);
            if (valueType.equals(ValueType.INSTANCE)) {
                collection.addAll(cls.getTemplateSlotAllowedClses(slot));
            } else if (valueType.equals(ValueType.CLS)) {
                collection.addAll(cls.getTemplateSlotAllowedParents(slot));
            }
        }
    }

    public LazyTreeNode createNode(Object object) {
        return new ReferenceNode(this, (Frame)object, this._slot);
    }

    public int getChildObjectCount() {
        return this.getChildObjects().size();
    }

    public Collection getChildObjects() {
        ArrayList arrayList = new ArrayList();
        Frame frame = (Frame)this.getUserObject();
        if (this._slot == null) {
            if (frame instanceof Cls) {
                Cls cls = (Cls)frame;
                for (Slot slot : cls.getTemplateSlots()) {
                    ReferenceNode.addTemplateSlotReferences(cls, slot, arrayList);
                }
            }
            for (Slot slot : frame.getOwnSlots()) {
                if (slot.isSystem()) continue;
                ReferenceNode.addOwnSlotReferences(frame, slot, arrayList);
            }
        } else {
            ReferenceNode.addReferences(frame, this._slot, arrayList);
        }
        return arrayList;
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }
}

