/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialogCloseDoubleClickAdapter;
import edu.stanford.smi.protege.util.SimpleListModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class SelectInstancesPanel
extends JComponent {
    protected JTree _clsTree;
    protected JList _instanceList;
    protected JComboBox _directAllInstanceComboBox;
    private static String DIRECT_INSTANCES_TEXT = "Direct Instances";
    private static String ALL_INSTANCES_TEXT = "All Instances";
    private static Object _oldDirectAllInstancesState = DIRECT_INSTANCES_TEXT;

    protected SelectInstancesPanel(KnowledgeBase knowledgeBase, Collection collection) {
        this.setPreferredSize(new Dimension(500, 300));
        if (collection.isEmpty()) {
            collection = knowledgeBase.getRootClses();
        }
        this.createWidgets(knowledgeBase, collection);
        this.fixRenderer();
    }

    protected LabeledComponent createClsesLabeledComponent(KnowledgeBase knowledgeBase, Collection collection) {
        LabeledComponent labeledComponent = new LabeledComponent("Allowed Classes", new JScrollPane(this._clsTree));
        labeledComponent.setFooterComponent(new ClsTreeFinder(knowledgeBase, this._clsTree));
        return labeledComponent;
    }

    protected JComponent createClsTree(Collection collection) {
        ParentChildRoot parentChildRoot = new ParentChildRoot(collection);
        this._clsTree = ComponentFactory.createSelectableTree(null, parentChildRoot);
        this._clsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SelectInstancesPanel.this.loadInstances();
            }
        });
        FrameRenderer frameRenderer = FrameRenderer.createInstance();
        frameRenderer.setDisplayDirectInstanceCount(true);
        this._clsTree.setCellRenderer(frameRenderer);
        int n = this._clsTree.getRowCount();
        int n2 = n - collection.size();
        for (int i = n - 1; i > n2; --i) {
            this._clsTree.expandRow(i);
        }
        this._clsTree.setSelectionRow(0);
        return this._clsTree;
    }

    private void fixRenderer() {
        boolean bl = this._directAllInstanceComboBox.getSelectedItem().equals(ALL_INSTANCES_TEXT);
        FrameRenderer frameRenderer = (FrameRenderer)this._instanceList.getCellRenderer();
        frameRenderer.setDisplayType(bl);
    }

    protected LabeledComponent createInstanceLabeledComponent() {
        LabeledComponent labeledComponent = new LabeledComponent(null, new JScrollPane(this._instanceList));
        labeledComponent.setHeaderComponent(this.createDirectAllInstanceComboBox(), "West");
        labeledComponent.setFooterComponent(new ListFinder(this._instanceList, "Find Instance"));
        return labeledComponent;
    }

    protected JComboBox createDirectAllInstanceComboBox() {
        this._directAllInstanceComboBox = ComponentFactory.createComboBox();
        this._directAllInstanceComboBox.addItem(DIRECT_INSTANCES_TEXT);
        this._directAllInstanceComboBox.addItem(ALL_INSTANCES_TEXT);
        this.loadState();
        this._directAllInstanceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectInstancesPanel.this.loadInstances();
                SelectInstancesPanel.this.fixRenderer();
                SelectInstancesPanel.this.saveState();
            }
        });
        return this._directAllInstanceComboBox;
    }

    private void saveState() {
        _oldDirectAllInstancesState = this._directAllInstanceComboBox.getSelectedItem();
    }

    private void loadState() {
        this._directAllInstanceComboBox.setSelectedItem(_oldDirectAllInstancesState);
    }

    protected JComponent createInstanceList() {
        this._instanceList = ComponentFactory.createList(null);
        this._instanceList.setCellRenderer(FrameRenderer.createInstance());
        this._instanceList.addMouseListener(new ModalDialogCloseDoubleClickAdapter());
        return this._instanceList;
    }

    protected void createWidgets(KnowledgeBase knowledgeBase, Collection collection) {
        this.createInstanceList();
        LabeledComponent labeledComponent = this.createInstanceLabeledComponent();
        this.createClsTree(collection);
        LabeledComponent labeledComponent2 = this.createClsesLabeledComponent(knowledgeBase, collection);
        JSplitPane jSplitPane = ComponentFactory.createLeftRightSplitPane(labeledComponent2, labeledComponent);
        jSplitPane.setDividerLocation(0);
        this.setLayout(new BorderLayout());
        this.add(jSplitPane);
    }

    protected SimpleListModel getInstanceModel() {
        return (SimpleListModel)this._instanceList.getModel();
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._instanceList);
    }

    protected void loadInstances() {
        ArrayList arrayList = new ArrayList();
        for (Cls cls : ComponentUtilities.getSelection(this._clsTree)) {
            arrayList.addAll(this.getInstances(cls));
        }
        Collections.sort(arrayList, new FrameComparator());
        this.getInstanceModel().setValues(arrayList);
        if (!arrayList.isEmpty()) {
            this._instanceList.setSelectedIndex(0);
        }
    }

    protected Collection getInstances(Cls cls) {
        boolean bl = this._directAllInstanceComboBox.getSelectedItem().equals(DIRECT_INSTANCES_TEXT);
        return bl ? cls.getDirectInstances() : cls.getInstances();
    }
}

