/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.SlotWidgetComparer;
import edu.stanford.smi.protege.widget.WidgetLayoutStrategy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class DefaultWidgetLayoutStrategy
implements WidgetLayoutStrategy {
    private static final int COLUMN_WIDTH = 250;
    private static final int MAX_COLUMNS = 3;

    private boolean canStretchVertically(Component component) {
        return component.getPreferredSize().height > ComponentUtilities.getStandardRowHeight();
    }

    private void doOneColumnLayout(List list) {
        Collections.sort(list, new SlotWidgetComparer());
        Point point = new Point();
        Dimension dimension = new Dimension();
        for (Component component : list) {
            Dimension dimension2 = component.getPreferredSize();
            if (dimension2.width + point.x > 250) {
                point.x = 0;
                point.y += dimension.height;
            }
            component.setBounds(new Rectangle(point, component.getPreferredSize()));
            point.x += dimension2.width;
            dimension = dimension2;
        }
    }

    private void doThreeColumnLayout(List list) {
        this.doNColumnLayout(3, list);
    }

    private void doTwoColumnLayout(List list) {
        this.doNColumnLayout(2, list);
    }

    private void doNColumnLayout(int n, List list) {
        if (!list.isEmpty()) {
            this.doOneColumnLayout(list);
            JComponent jComponent = (JComponent)list.get(list.size() - 1);
            Rectangle rectangle = jComponent.getBounds();
            int n2 = (rectangle.y + rectangle.height) / n;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Component[] componentArray = new Component[n];
            for (Component component : list) {
                int n7 = component.getY() / n2;
                if (n7 != n4) {
                    n4 = n7;
                    n3 = component.getY();
                    n5 = n6;
                }
                Point point = new Point(component.getX() + n5, component.getY() - n3);
                n6 = Math.max(n6, point.x + component.getWidth());
                component.setLocation(point);
                componentArray[n7] = component;
            }
            this.evenBottomComponents(componentArray);
        }
    }

    private void evenBottomComponents(Component[] componentArray) {
        Component component;
        int n;
        int n2 = 0;
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (component == null) continue;
            n2 = Math.max(n2, component.getY() + component.getHeight());
        }
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (component == null || !this.canStretchVertically(component)) continue;
            Dimension dimension = new Dimension(component.getWidth(), n2 - component.getY());
            component.setSize(dimension);
        }
    }

    private int getPreferredNumberOfColumns(List list) {
        int n = 0;
        int n2 = 0;
        for (Component component : list) {
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        int n3 = (n2 + 250 - 1) / 250;
        n3 = Math.max(n3, (n - 1) / 250 + 1);
        n3 = Math.min(3, n3);
        return n3;
    }

    public void layout(Container container, int n) {
        ArrayList<Component> arrayList = new ArrayList<Component>(Arrays.asList(container.getComponents()));
        List list = arrayList.subList(n, arrayList.size());
        int n2 = this.getPreferredNumberOfColumns(list);
        switch (n2) {
            case 1: {
                this.doOneColumnLayout(list);
                break;
            }
            case 2: {
                this.doTwoColumnLayout(list);
                break;
            }
            default: {
                this.doThreeColumnLayout(list);
            }
        }
        this.shiftMovableComponents(arrayList, n);
    }

    private void shiftMovableComponents(List list, int n) {
        Cloneable cloneable;
        Component component;
        int n2;
        int n3 = 0;
        int n4 = list.size();
        if (n < n4) {
            for (n2 = 0; n2 < n; ++n2) {
                component = (Component)list.get(n2);
                cloneable = component.getBounds();
                n3 = Math.max(n3, cloneable.y + cloneable.height);
            }
        }
        if (n3 > 0) {
            for (n2 = n; n2 < n4; ++n2) {
                component = (Component)list.get(n2);
                cloneable = component.getLocation();
                ((Point)cloneable).y += n3;
                component.setLocation((Point)cloneable);
            }
        }
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

