/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameMapping;
import edu.stanford.smi.protege.model.framestore.IncludedFrameLookup;
import edu.stanford.smi.protege.model.framestore.IncludingKBSupport;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IncludingKBAdapter
implements NarrowFrameStore,
IncludingKBSupport,
FrameMapping {
    private static Logger log = Log.getLogger(IncludingKBAdapter.class);
    private IncludedFrameLookup iframes;
    private FrameFactory frameFactory;
    private NarrowFrameStore delegate;
    protected int memoryProjectId;
    private Set<Frame> frameSetCache;

    public IncludingKBAdapter(NarrowFrameStore narrowFrameStore) {
        this.delegate = narrowFrameStore;
    }

    public void initialize(FrameFactory frameFactory) {
        this.frameFactory = frameFactory;
        FrameID frameID = this.delegate.generateFrameID();
        this.memoryProjectId = frameID.getMemoryProjectPart();
    }

    protected void setMemoryProjectId(int n) {
        this.memoryProjectId = n;
    }

    public abstract boolean isLocalFrameIncluded(Frame var1);

    public boolean isGlobalFrameInherited(Frame frame) {
        return frame.getFrameID().isUser() && frame.getFrameID().getMemoryProjectPart() != this.memoryProjectId;
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this.delegate;
    }

    public IncludedFrameLookup getIncludedFrames() {
        return this.iframes;
    }

    @Override
    public void setIncludedFrames(IncludedFrameLookup includedFrameLookup) {
        this.iframes = includedFrameLookup;
    }

    protected FrameFactory getFrameFactory() {
        return this.frameFactory;
    }

    public boolean noIncludedFrames() {
        return this.iframes == null || this.iframes.isEmpty();
    }

    @Override
    public Frame mapLocalFrame(Frame frame) {
        if (frame == null || this.noIncludedFrames() || frame.getFrameID().isSystem() || !this.isLocalFrameIncluded(frame)) {
            return frame;
        }
        String string = null;
        List list = this.delegate.getValues(frame, this.iframes.getNameSlot(), null, false);
        for (Object e : list) {
            if (!(e instanceof String)) continue;
            string = (String)e;
            break;
        }
        if (string == null) {
            return null;
        }
        return this.iframes.getInheritedFrame(string);
    }

    @Override
    public Frame mapGlobalFrame(Frame frame, boolean bl) {
        Object object;
        if (log.isLoggable(Level.FINEST) && frame != null) {
            log.finest("(" + this.memoryProjectId + ") Mapping global frame with id = " + frame.getFrameID() + " create flag = " + bl);
        }
        if (frame == null || this.noIncludedFrames() || frame.getFrameID().isSystem() || !this.isGlobalFrameInherited(frame)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("no mapping needed");
            }
            return frame;
        }
        String string = this.iframes.getInherittedFrameName(frame);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("global frame has name = " + string);
        }
        if (string != null && (object = this.delegate.getFrames(this.iframes.getNameSlot(), null, false, string).iterator()).hasNext()) {
            Frame frame2 = (Frame)object.next();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("found local frame with appropriate name with id = " + frame2.getFrameID());
            }
            return frame2;
        }
        if (bl) {
            object = this.createLocalFrame(frame, string);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Created mapped local frame with id = " + object.getFrameID());
            }
            return object;
        }
        return null;
    }

    protected Frame createLocalFrame(Frame frame, String string) {
        int n = 0;
        n = frame instanceof Cls ? 6 : (frame instanceof Slot ? 7 : (frame instanceof Facet ? 8 : 5));
        Frame frame2 = this.frameFactory.createFrameFromClassId(n, this.delegate.generateFrameID());
        if (string != null) {
            this.delegate.addValues(frame2, this.iframes.getNameSlot(), null, false, Collections.singleton(string));
        }
        return frame2;
    }

    @Override
    public Slot mapGlobalSlot(Slot slot, boolean bl) {
        Frame frame = this.mapGlobalFrame(slot, bl);
        if (frame == null) {
            return null;
        }
        if (frame instanceof Slot) {
            return (Slot)frame;
        }
        throw new RuntimeException("Inconsistent ontologies - inherited frame " + slot + " is also know as a non-slot frame " + frame + " by narrow frame store " + this);
    }

    @Override
    public Facet mapGlobalFacet(Facet facet, boolean bl) {
        Frame frame = this.mapGlobalFrame(facet, bl);
        if (frame == null) {
            return null;
        }
        if (frame instanceof Facet) {
            return (Facet)frame;
        }
        throw new RuntimeException("Inconsistent ontologies - inherited frame " + facet + " is also know as a non-slot frame " + frame + " by narrow frame store " + this);
    }

    @Override
    public Slot mapLocalSlot(Slot slot) {
        Frame frame = this.mapLocalFrame(slot);
        if (frame == null) {
            return null;
        }
        if (frame instanceof Slot) {
            return (Slot)frame;
        }
        throw new RuntimeException("Inconsistent ontologies - inherited frame " + frame + " is also know as a non-slot frame " + slot + " by narrow frame store " + this);
    }

    @Override
    public Facet mapLocalFacet(Facet facet) {
        Frame frame = this.mapLocalFrame(facet);
        if (frame == null) {
            return null;
        }
        if (frame instanceof Facet) {
            return (Facet)frame;
        }
        throw new RuntimeException("Inconsistent ontologies - inherited frame " + frame + " is also know as a non-slot frame " + facet + " by narrow frame store " + this);
    }

    @Override
    public Object mapLocalObject(Object object) {
        if (object instanceof Frame) {
            return this.mapLocalFrame((Frame)object);
        }
        return object;
    }

    @Override
    public Object mapGlobalObject(Object object, boolean bl) {
        if (object instanceof Frame) {
            return this.mapGlobalFrame((Frame)object, bl);
        }
        return object;
    }

    @Override
    public List mapLocalList(List list) {
        if (this.noIncludedFrames()) {
            return list;
        }
        if (!this.containsFrames(list)) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : list) {
            arrayList.add(this.mapLocalObject(e));
        }
        return arrayList;
    }

    @Override
    public List mapGlobalList(List list, boolean bl) {
        if (this.noIncludedFrames()) {
            return list;
        }
        if (!this.containsFrames(list)) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : list) {
            Object object = this.mapGlobalObject(e, bl);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    @Override
    public Collection mapLocalCollection(Collection collection) {
        if (!this.containsFrames(collection)) {
            return collection;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : collection) {
            arrayList.add(this.mapLocalObject(e));
        }
        return arrayList;
    }

    @Override
    public Collection mapGlobalCollection(Collection collection, boolean bl) {
        if (!this.containsFrames(collection)) {
            return collection;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : collection) {
            Object object = this.mapGlobalObject(e, bl);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private boolean containsFrames(Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof Frame)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Frame> mapLocalFrameSet(Set<Frame> set) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (Frame frame : set) {
            Frame frame2 = this.mapLocalFrame(frame);
            hashSet.add(frame2);
        }
        return hashSet;
    }

    private Set<Reference> mapLocalReferences(Set<Reference> set) {
        HashSet<Reference> hashSet = new HashSet<Reference>();
        for (Reference reference : set) {
            hashSet.add(new ReferenceImpl(this.mapLocalFrame(reference.getFrame()), this.mapLocalSlot(reference.getSlot()), this.mapLocalFacet(reference.getFacet()), reference.isTemplate()));
        }
        return hashSet;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void setName(String string) {
        this.delegate.setName(string);
    }

    @Override
    public FrameID generateFrameID() {
        return this.delegate.generateFrameID();
    }

    @Override
    public int getFrameCount() {
        return this.getFrames().size();
    }

    @Override
    public int getClsCount() {
        int n = 0;
        for (Frame frame : this.getFrames()) {
            if (!(frame instanceof Cls)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getSlotCount() {
        int n = 0;
        for (Frame frame : this.getFrames()) {
            if (!(frame instanceof Slot)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getFacetCount() {
        int n = 0;
        for (Frame frame : this.getFrames()) {
            if (!(frame instanceof Facet)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getSimpleInstanceCount() {
        int n = 0;
        for (Frame frame : this.getFrames()) {
            if (!(frame instanceof SimpleInstance)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Set<Frame> getFrames() {
        if (this.frameSetCache != null) {
            return this.frameSetCache;
        }
        this.frameSetCache = new HashSet<Frame>();
        for (Frame frame : this.delegate.getFrames()) {
            if (this.isLocalFrameIncluded(frame)) continue;
            this.frameSetCache.add(frame);
        }
        return this.frameSetCache;
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        if (frameID.getMemoryProjectPart() != this.memoryProjectId) {
            return this.iframes.getInheritedFrame(frameID);
        }
        return this.delegate.getFrame(frameID);
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        if (this.isGlobalFrameInherited(frame) && slot.getFrameID().equals(Model.SlotID.NAME)) {
            return new ArrayList();
        }
        frame = this.mapGlobalFrame(frame, false);
        slot = this.mapGlobalSlot(slot, false);
        facet = this.mapGlobalFacet(facet, false);
        if (frame == null || slot == null) {
            return new ArrayList();
        }
        List list = this.delegate.getValues(frame, slot, facet, bl);
        return this.mapLocalList(list);
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        if (this.isGlobalFrameInherited(frame) && slot.getFrameID().equals(Model.SlotID.NAME)) {
            return 0;
        }
        frame = this.mapGlobalFrame(frame, false);
        slot = this.mapGlobalSlot(slot, false);
        facet = this.mapGlobalFacet(facet, false);
        if (frame == null || slot == null) {
            return 0;
        }
        return this.delegate.getValuesCount(frame, slot, facet, bl);
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        frame = this.mapGlobalFrame(frame, true);
        slot = this.mapGlobalSlot(slot, true);
        facet = this.mapGlobalFacet(facet, true);
        this.delegate.addValues(frame, slot, facet, bl, collection);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        frame = this.mapGlobalFrame(frame, true);
        slot = this.mapGlobalSlot(slot, true);
        facet = this.mapGlobalFacet(facet, true);
        this.delegate.moveValue(frame, slot, facet, bl, n, n2);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        frame = this.mapGlobalFrame(frame, true);
        slot = this.mapGlobalSlot(slot, true);
        facet = this.mapGlobalFacet(facet, true);
        object = this.mapGlobalObject(object, true);
        this.delegate.removeValue(frame, slot, facet, bl, object);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        frame = this.mapGlobalFrame(frame, true);
        slot = this.mapGlobalSlot(slot, true);
        facet = this.mapGlobalFacet(facet, true);
        collection = this.mapGlobalCollection(collection, true);
        this.delegate.setValues(frame, slot, facet, bl, collection);
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        slot = this.mapGlobalSlot(slot, false);
        facet = this.mapGlobalFacet(facet, false);
        object = this.mapGlobalObject(object, false);
        if (slot == null || object == null) {
            return new HashSet<Frame>();
        }
        Set<Frame> set = this.delegate.getFrames(slot, facet, bl, object);
        set = this.mapLocalFrameSet(set);
        return set;
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        slot = this.mapGlobalSlot(slot, false);
        facet = this.mapGlobalFacet(facet, false);
        if (slot == null) {
            return new HashSet<Frame>();
        }
        Set<Frame> set = this.delegate.getFramesWithAnyValue(slot, facet, bl);
        return this.mapLocalFrameSet(set);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        slot = this.mapGlobalSlot(slot, false);
        facet = this.mapGlobalFacet(facet, false);
        if (slot == null) {
            return new HashSet<Frame>();
        }
        Set<Frame> set = this.delegate.getMatchingFrames(slot, facet, bl, string, n);
        return this.mapLocalFrameSet(set);
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        return this.delegate.getReferences(object);
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        return this.delegate.getMatchingReferences(string, n);
    }

    @Override
    public Set executeQuery(Query query) {
        return this.delegate.executeQuery(query);
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.delegate.deleteFrame(frame);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.delegate.getClosure(frame, slot, facet, bl);
    }

    @Override
    public void replaceFrame(Frame frame) {
        this.delegate.replaceFrame(frame);
    }

    @Override
    public boolean beginTransaction(String string) {
        return this.delegate.beginTransaction(string);
    }

    @Override
    public boolean commitTransaction() {
        return this.delegate.commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        return this.delegate.rollbackTransaction();
    }
}

